/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawMerchantsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.merchants.AsyncCustomAttributeDefinitionsClient;
import com.squareup.square.merchants.AsyncCustomAttributesClient;
import com.squareup.square.types.GetMerchantResponse;
import com.squareup.square.types.GetMerchantsRequest;
import com.squareup.square.types.ListMerchantsRequest;
import com.squareup.square.types.Merchant;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncMerchantsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawMerchantsClient rawClient;
    protected final Supplier<AsyncCustomAttributeDefinitionsClient> customAttributeDefinitionsClient;
    protected final Supplier<AsyncCustomAttributesClient> customAttributesClient;

    public AsyncMerchantsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawMerchantsClient(clientOptions);
        this.customAttributeDefinitionsClient = Suppliers.memoize(() -> new AsyncCustomAttributeDefinitionsClient(clientOptions));
        this.customAttributesClient = Suppliers.memoize(() -> new AsyncCustomAttributesClient(clientOptions));
    }

    public AsyncRawMerchantsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Merchant>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Merchant>> list(ListMerchantsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Merchant>> list(ListMerchantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetMerchantResponse> get(GetMerchantsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetMerchantResponse)response.body());
    }

    public CompletableFuture<GetMerchantResponse> get(GetMerchantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetMerchantResponse)response.body());
    }

    public AsyncCustomAttributeDefinitionsClient customAttributeDefinitions() {
        return this.customAttributeDefinitionsClient.get();
    }

    public AsyncCustomAttributesClient customAttributes() {
        return this.customAttributesClient.get();
    }
}

