/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawLaborClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.labor.AsyncBreakTypesClient;
import com.squareup.square.labor.AsyncEmployeeWagesClient;
import com.squareup.square.labor.AsyncShiftsClient;
import com.squareup.square.labor.AsyncTeamMemberWagesClient;
import com.squareup.square.labor.AsyncWorkweekConfigsClient;
import com.squareup.square.types.BulkPublishScheduledShiftsRequest;
import com.squareup.square.types.BulkPublishScheduledShiftsResponse;
import com.squareup.square.types.CreateScheduledShiftRequest;
import com.squareup.square.types.CreateScheduledShiftResponse;
import com.squareup.square.types.CreateTimecardRequest;
import com.squareup.square.types.CreateTimecardResponse;
import com.squareup.square.types.DeleteTimecardRequest;
import com.squareup.square.types.DeleteTimecardResponse;
import com.squareup.square.types.PublishScheduledShiftRequest;
import com.squareup.square.types.PublishScheduledShiftResponse;
import com.squareup.square.types.RetrieveScheduledShiftRequest;
import com.squareup.square.types.RetrieveScheduledShiftResponse;
import com.squareup.square.types.RetrieveTimecardRequest;
import com.squareup.square.types.RetrieveTimecardResponse;
import com.squareup.square.types.SearchScheduledShiftsRequest;
import com.squareup.square.types.SearchScheduledShiftsResponse;
import com.squareup.square.types.SearchTimecardsRequest;
import com.squareup.square.types.SearchTimecardsResponse;
import com.squareup.square.types.UpdateScheduledShiftRequest;
import com.squareup.square.types.UpdateScheduledShiftResponse;
import com.squareup.square.types.UpdateTimecardRequest;
import com.squareup.square.types.UpdateTimecardResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncLaborClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawLaborClient rawClient;
    protected final Supplier<AsyncBreakTypesClient> breakTypesClient;
    protected final Supplier<AsyncEmployeeWagesClient> employeeWagesClient;
    protected final Supplier<AsyncShiftsClient> shiftsClient;
    protected final Supplier<AsyncTeamMemberWagesClient> teamMemberWagesClient;
    protected final Supplier<AsyncWorkweekConfigsClient> workweekConfigsClient;

    public AsyncLaborClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawLaborClient(clientOptions);
        this.breakTypesClient = Suppliers.memoize(() -> new AsyncBreakTypesClient(clientOptions));
        this.employeeWagesClient = Suppliers.memoize(() -> new AsyncEmployeeWagesClient(clientOptions));
        this.shiftsClient = Suppliers.memoize(() -> new AsyncShiftsClient(clientOptions));
        this.teamMemberWagesClient = Suppliers.memoize(() -> new AsyncTeamMemberWagesClient(clientOptions));
        this.workweekConfigsClient = Suppliers.memoize(() -> new AsyncWorkweekConfigsClient(clientOptions));
    }

    public AsyncRawLaborClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateScheduledShiftResponse> createScheduledShift(CreateScheduledShiftRequest request) {
        return this.rawClient.createScheduledShift(request).thenApply(response -> (CreateScheduledShiftResponse)response.body());
    }

    public CompletableFuture<CreateScheduledShiftResponse> createScheduledShift(CreateScheduledShiftRequest request, RequestOptions requestOptions) {
        return this.rawClient.createScheduledShift(request, requestOptions).thenApply(response -> (CreateScheduledShiftResponse)response.body());
    }

    public CompletableFuture<BulkPublishScheduledShiftsResponse> bulkPublishScheduledShifts(BulkPublishScheduledShiftsRequest request) {
        return this.rawClient.bulkPublishScheduledShifts(request).thenApply(response -> (BulkPublishScheduledShiftsResponse)response.body());
    }

    public CompletableFuture<BulkPublishScheduledShiftsResponse> bulkPublishScheduledShifts(BulkPublishScheduledShiftsRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkPublishScheduledShifts(request, requestOptions).thenApply(response -> (BulkPublishScheduledShiftsResponse)response.body());
    }

    public CompletableFuture<SearchScheduledShiftsResponse> searchScheduledShifts() {
        return this.rawClient.searchScheduledShifts().thenApply(response -> (SearchScheduledShiftsResponse)response.body());
    }

    public CompletableFuture<SearchScheduledShiftsResponse> searchScheduledShifts(SearchScheduledShiftsRequest request) {
        return this.rawClient.searchScheduledShifts(request).thenApply(response -> (SearchScheduledShiftsResponse)response.body());
    }

    public CompletableFuture<SearchScheduledShiftsResponse> searchScheduledShifts(SearchScheduledShiftsRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchScheduledShifts(request, requestOptions).thenApply(response -> (SearchScheduledShiftsResponse)response.body());
    }

    public CompletableFuture<RetrieveScheduledShiftResponse> retrieveScheduledShift(RetrieveScheduledShiftRequest request) {
        return this.rawClient.retrieveScheduledShift(request).thenApply(response -> (RetrieveScheduledShiftResponse)response.body());
    }

    public CompletableFuture<RetrieveScheduledShiftResponse> retrieveScheduledShift(RetrieveScheduledShiftRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveScheduledShift(request, requestOptions).thenApply(response -> (RetrieveScheduledShiftResponse)response.body());
    }

    public CompletableFuture<UpdateScheduledShiftResponse> updateScheduledShift(UpdateScheduledShiftRequest request) {
        return this.rawClient.updateScheduledShift(request).thenApply(response -> (UpdateScheduledShiftResponse)response.body());
    }

    public CompletableFuture<UpdateScheduledShiftResponse> updateScheduledShift(UpdateScheduledShiftRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateScheduledShift(request, requestOptions).thenApply(response -> (UpdateScheduledShiftResponse)response.body());
    }

    public CompletableFuture<PublishScheduledShiftResponse> publishScheduledShift(PublishScheduledShiftRequest request) {
        return this.rawClient.publishScheduledShift(request).thenApply(response -> (PublishScheduledShiftResponse)response.body());
    }

    public CompletableFuture<PublishScheduledShiftResponse> publishScheduledShift(PublishScheduledShiftRequest request, RequestOptions requestOptions) {
        return this.rawClient.publishScheduledShift(request, requestOptions).thenApply(response -> (PublishScheduledShiftResponse)response.body());
    }

    public CompletableFuture<CreateTimecardResponse> createTimecard(CreateTimecardRequest request) {
        return this.rawClient.createTimecard(request).thenApply(response -> (CreateTimecardResponse)response.body());
    }

    public CompletableFuture<CreateTimecardResponse> createTimecard(CreateTimecardRequest request, RequestOptions requestOptions) {
        return this.rawClient.createTimecard(request, requestOptions).thenApply(response -> (CreateTimecardResponse)response.body());
    }

    public CompletableFuture<SearchTimecardsResponse> searchTimecards() {
        return this.rawClient.searchTimecards().thenApply(response -> (SearchTimecardsResponse)response.body());
    }

    public CompletableFuture<SearchTimecardsResponse> searchTimecards(SearchTimecardsRequest request) {
        return this.rawClient.searchTimecards(request).thenApply(response -> (SearchTimecardsResponse)response.body());
    }

    public CompletableFuture<SearchTimecardsResponse> searchTimecards(SearchTimecardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchTimecards(request, requestOptions).thenApply(response -> (SearchTimecardsResponse)response.body());
    }

    public CompletableFuture<RetrieveTimecardResponse> retrieveTimecard(RetrieveTimecardRequest request) {
        return this.rawClient.retrieveTimecard(request).thenApply(response -> (RetrieveTimecardResponse)response.body());
    }

    public CompletableFuture<RetrieveTimecardResponse> retrieveTimecard(RetrieveTimecardRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveTimecard(request, requestOptions).thenApply(response -> (RetrieveTimecardResponse)response.body());
    }

    public CompletableFuture<UpdateTimecardResponse> updateTimecard(UpdateTimecardRequest request) {
        return this.rawClient.updateTimecard(request).thenApply(response -> (UpdateTimecardResponse)response.body());
    }

    public CompletableFuture<UpdateTimecardResponse> updateTimecard(UpdateTimecardRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateTimecard(request, requestOptions).thenApply(response -> (UpdateTimecardResponse)response.body());
    }

    public CompletableFuture<DeleteTimecardResponse> deleteTimecard(DeleteTimecardRequest request) {
        return this.rawClient.deleteTimecard(request).thenApply(response -> (DeleteTimecardResponse)response.body());
    }

    public CompletableFuture<DeleteTimecardResponse> deleteTimecard(DeleteTimecardRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteTimecard(request, requestOptions).thenApply(response -> (DeleteTimecardResponse)response.body());
    }

    public AsyncBreakTypesClient breakTypes() {
        return this.breakTypesClient.get();
    }

    public AsyncEmployeeWagesClient employeeWages() {
        return this.employeeWagesClient.get();
    }

    public AsyncShiftsClient shifts() {
        return this.shiftsClient.get();
    }

    public AsyncTeamMemberWagesClient teamMemberWages() {
        return this.teamMemberWagesClient.get();
    }

    public AsyncWorkweekConfigsClient workweekConfigs() {
        return this.workweekConfigsClient.get();
    }
}

