/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawInvoicesClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.CancelInvoiceRequest;
import com.squareup.square.types.CancelInvoiceResponse;
import com.squareup.square.types.CreateInvoiceAttachmentRequest;
import com.squareup.square.types.CreateInvoiceAttachmentResponse;
import com.squareup.square.types.CreateInvoiceRequest;
import com.squareup.square.types.CreateInvoiceResponse;
import com.squareup.square.types.DeleteInvoiceAttachmentRequest;
import com.squareup.square.types.DeleteInvoiceAttachmentResponse;
import com.squareup.square.types.DeleteInvoiceResponse;
import com.squareup.square.types.DeleteInvoicesRequest;
import com.squareup.square.types.GetInvoiceResponse;
import com.squareup.square.types.GetInvoicesRequest;
import com.squareup.square.types.Invoice;
import com.squareup.square.types.ListInvoicesRequest;
import com.squareup.square.types.PublishInvoiceRequest;
import com.squareup.square.types.PublishInvoiceResponse;
import com.squareup.square.types.SearchInvoicesRequest;
import com.squareup.square.types.SearchInvoicesResponse;
import com.squareup.square.types.UpdateInvoiceRequest;
import com.squareup.square.types.UpdateInvoiceResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncInvoicesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawInvoicesClient rawClient;

    public AsyncInvoicesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawInvoicesClient(clientOptions);
    }

    public AsyncRawInvoicesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Invoice>> list(ListInvoicesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Invoice>> list(ListInvoicesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateInvoiceResponse> create(CreateInvoiceRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateInvoiceResponse)response.body());
    }

    public CompletableFuture<CreateInvoiceResponse> create(CreateInvoiceRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateInvoiceResponse)response.body());
    }

    public CompletableFuture<SearchInvoicesResponse> search(SearchInvoicesRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SearchInvoicesResponse)response.body());
    }

    public CompletableFuture<SearchInvoicesResponse> search(SearchInvoicesRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SearchInvoicesResponse)response.body());
    }

    public CompletableFuture<GetInvoiceResponse> get(GetInvoicesRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetInvoiceResponse)response.body());
    }

    public CompletableFuture<GetInvoiceResponse> get(GetInvoicesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetInvoiceResponse)response.body());
    }

    public CompletableFuture<UpdateInvoiceResponse> update(UpdateInvoiceRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateInvoiceResponse)response.body());
    }

    public CompletableFuture<UpdateInvoiceResponse> update(UpdateInvoiceRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateInvoiceResponse)response.body());
    }

    public CompletableFuture<DeleteInvoiceResponse> delete(DeleteInvoicesRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteInvoiceResponse)response.body());
    }

    public CompletableFuture<DeleteInvoiceResponse> delete(DeleteInvoicesRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteInvoiceResponse)response.body());
    }

    public CompletableFuture<CreateInvoiceAttachmentResponse> createInvoiceAttachment(CreateInvoiceAttachmentRequest request) {
        return this.rawClient.createInvoiceAttachment(request).thenApply(response -> (CreateInvoiceAttachmentResponse)response.body());
    }

    public CompletableFuture<CreateInvoiceAttachmentResponse> createInvoiceAttachment(CreateInvoiceAttachmentRequest request, RequestOptions requestOptions) {
        return this.rawClient.createInvoiceAttachment(request, requestOptions).thenApply(response -> (CreateInvoiceAttachmentResponse)response.body());
    }

    public CompletableFuture<DeleteInvoiceAttachmentResponse> deleteInvoiceAttachment(DeleteInvoiceAttachmentRequest request) {
        return this.rawClient.deleteInvoiceAttachment(request).thenApply(response -> (DeleteInvoiceAttachmentResponse)response.body());
    }

    public CompletableFuture<DeleteInvoiceAttachmentResponse> deleteInvoiceAttachment(DeleteInvoiceAttachmentRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteInvoiceAttachment(request, requestOptions).thenApply(response -> (DeleteInvoiceAttachmentResponse)response.body());
    }

    public CompletableFuture<CancelInvoiceResponse> cancel(CancelInvoiceRequest request) {
        return this.rawClient.cancel(request).thenApply(response -> (CancelInvoiceResponse)response.body());
    }

    public CompletableFuture<CancelInvoiceResponse> cancel(CancelInvoiceRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).thenApply(response -> (CancelInvoiceResponse)response.body());
    }

    public CompletableFuture<PublishInvoiceResponse> publish(PublishInvoiceRequest request) {
        return this.rawClient.publish(request).thenApply(response -> (PublishInvoiceResponse)response.body());
    }

    public CompletableFuture<PublishInvoiceResponse> publish(PublishInvoiceRequest request, RequestOptions requestOptions) {
        return this.rawClient.publish(request, requestOptions).thenApply(response -> (PublishInvoiceResponse)response.body());
    }
}

