/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawInventoryClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.BatchChangeInventoryRequest;
import com.squareup.square.types.BatchChangeInventoryResponse;
import com.squareup.square.types.BatchGetInventoryChangesResponse;
import com.squareup.square.types.BatchGetInventoryCountsRequest;
import com.squareup.square.types.BatchGetInventoryCountsResponse;
import com.squareup.square.types.BatchRetrieveInventoryChangesRequest;
import com.squareup.square.types.ChangesInventoryRequest;
import com.squareup.square.types.DeprecatedGetAdjustmentInventoryRequest;
import com.squareup.square.types.DeprecatedGetPhysicalCountInventoryRequest;
import com.squareup.square.types.GetAdjustmentInventoryRequest;
import com.squareup.square.types.GetInventoryAdjustmentResponse;
import com.squareup.square.types.GetInventoryPhysicalCountResponse;
import com.squareup.square.types.GetInventoryRequest;
import com.squareup.square.types.GetInventoryTransferResponse;
import com.squareup.square.types.GetPhysicalCountInventoryRequest;
import com.squareup.square.types.GetTransferInventoryRequest;
import com.squareup.square.types.InventoryChange;
import com.squareup.square.types.InventoryCount;
import java.util.concurrent.CompletableFuture;

public class AsyncInventoryClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawInventoryClient rawClient;

    public AsyncInventoryClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawInventoryClient(clientOptions);
    }

    public AsyncRawInventoryClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<GetInventoryAdjustmentResponse> deprecatedGetAdjustment(DeprecatedGetAdjustmentInventoryRequest request) {
        return this.rawClient.deprecatedGetAdjustment(request).thenApply(response -> (GetInventoryAdjustmentResponse)response.body());
    }

    public CompletableFuture<GetInventoryAdjustmentResponse> deprecatedGetAdjustment(DeprecatedGetAdjustmentInventoryRequest request, RequestOptions requestOptions) {
        return this.rawClient.deprecatedGetAdjustment(request, requestOptions).thenApply(response -> (GetInventoryAdjustmentResponse)response.body());
    }

    public CompletableFuture<GetInventoryAdjustmentResponse> getAdjustment(GetAdjustmentInventoryRequest request) {
        return this.rawClient.getAdjustment(request).thenApply(response -> (GetInventoryAdjustmentResponse)response.body());
    }

    public CompletableFuture<GetInventoryAdjustmentResponse> getAdjustment(GetAdjustmentInventoryRequest request, RequestOptions requestOptions) {
        return this.rawClient.getAdjustment(request, requestOptions).thenApply(response -> (GetInventoryAdjustmentResponse)response.body());
    }

    public CompletableFuture<BatchChangeInventoryResponse> deprecatedBatchChange(BatchChangeInventoryRequest request) {
        return this.rawClient.deprecatedBatchChange(request).thenApply(response -> (BatchChangeInventoryResponse)response.body());
    }

    public CompletableFuture<BatchChangeInventoryResponse> deprecatedBatchChange(BatchChangeInventoryRequest request, RequestOptions requestOptions) {
        return this.rawClient.deprecatedBatchChange(request, requestOptions).thenApply(response -> (BatchChangeInventoryResponse)response.body());
    }

    public CompletableFuture<BatchGetInventoryChangesResponse> deprecatedBatchGetChanges() {
        return this.rawClient.deprecatedBatchGetChanges().thenApply(response -> (BatchGetInventoryChangesResponse)response.body());
    }

    public CompletableFuture<BatchGetInventoryChangesResponse> deprecatedBatchGetChanges(BatchRetrieveInventoryChangesRequest request) {
        return this.rawClient.deprecatedBatchGetChanges(request).thenApply(response -> (BatchGetInventoryChangesResponse)response.body());
    }

    public CompletableFuture<BatchGetInventoryChangesResponse> deprecatedBatchGetChanges(BatchRetrieveInventoryChangesRequest request, RequestOptions requestOptions) {
        return this.rawClient.deprecatedBatchGetChanges(request, requestOptions).thenApply(response -> (BatchGetInventoryChangesResponse)response.body());
    }

    public CompletableFuture<BatchGetInventoryCountsResponse> deprecatedBatchGetCounts() {
        return this.rawClient.deprecatedBatchGetCounts().thenApply(response -> (BatchGetInventoryCountsResponse)response.body());
    }

    public CompletableFuture<BatchGetInventoryCountsResponse> deprecatedBatchGetCounts(BatchGetInventoryCountsRequest request) {
        return this.rawClient.deprecatedBatchGetCounts(request).thenApply(response -> (BatchGetInventoryCountsResponse)response.body());
    }

    public CompletableFuture<BatchGetInventoryCountsResponse> deprecatedBatchGetCounts(BatchGetInventoryCountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.deprecatedBatchGetCounts(request, requestOptions).thenApply(response -> (BatchGetInventoryCountsResponse)response.body());
    }

    public CompletableFuture<BatchChangeInventoryResponse> batchCreateChanges(BatchChangeInventoryRequest request) {
        return this.rawClient.batchCreateChanges(request).thenApply(response -> (BatchChangeInventoryResponse)response.body());
    }

    public CompletableFuture<BatchChangeInventoryResponse> batchCreateChanges(BatchChangeInventoryRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchCreateChanges(request, requestOptions).thenApply(response -> (BatchChangeInventoryResponse)response.body());
    }

    public CompletableFuture<SyncPagingIterable<InventoryChange>> batchGetChanges() {
        return this.rawClient.batchGetChanges().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<InventoryChange>> batchGetChanges(BatchRetrieveInventoryChangesRequest request) {
        return this.rawClient.batchGetChanges(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<InventoryChange>> batchGetChanges(BatchRetrieveInventoryChangesRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchGetChanges(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<InventoryCount>> batchGetCounts() {
        return this.rawClient.batchGetCounts().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<InventoryCount>> batchGetCounts(BatchGetInventoryCountsRequest request) {
        return this.rawClient.batchGetCounts(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<InventoryCount>> batchGetCounts(BatchGetInventoryCountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchGetCounts(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetInventoryPhysicalCountResponse> deprecatedGetPhysicalCount(DeprecatedGetPhysicalCountInventoryRequest request) {
        return this.rawClient.deprecatedGetPhysicalCount(request).thenApply(response -> (GetInventoryPhysicalCountResponse)response.body());
    }

    public CompletableFuture<GetInventoryPhysicalCountResponse> deprecatedGetPhysicalCount(DeprecatedGetPhysicalCountInventoryRequest request, RequestOptions requestOptions) {
        return this.rawClient.deprecatedGetPhysicalCount(request, requestOptions).thenApply(response -> (GetInventoryPhysicalCountResponse)response.body());
    }

    public CompletableFuture<GetInventoryPhysicalCountResponse> getPhysicalCount(GetPhysicalCountInventoryRequest request) {
        return this.rawClient.getPhysicalCount(request).thenApply(response -> (GetInventoryPhysicalCountResponse)response.body());
    }

    public CompletableFuture<GetInventoryPhysicalCountResponse> getPhysicalCount(GetPhysicalCountInventoryRequest request, RequestOptions requestOptions) {
        return this.rawClient.getPhysicalCount(request, requestOptions).thenApply(response -> (GetInventoryPhysicalCountResponse)response.body());
    }

    public CompletableFuture<GetInventoryTransferResponse> getTransfer(GetTransferInventoryRequest request) {
        return this.rawClient.getTransfer(request).thenApply(response -> (GetInventoryTransferResponse)response.body());
    }

    public CompletableFuture<GetInventoryTransferResponse> getTransfer(GetTransferInventoryRequest request, RequestOptions requestOptions) {
        return this.rawClient.getTransfer(request, requestOptions).thenApply(response -> (GetInventoryTransferResponse)response.body());
    }

    public CompletableFuture<SyncPagingIterable<InventoryCount>> get(GetInventoryRequest request) {
        return this.rawClient.get(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<InventoryCount>> get(GetInventoryRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<InventoryChange>> changes(ChangesInventoryRequest request) {
        return this.rawClient.changes(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<InventoryChange>> changes(ChangesInventoryRequest request, RequestOptions requestOptions) {
        return this.rawClient.changes(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }
}

