/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawGiftCardsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.giftcards.AsyncActivitiesClient;
import com.squareup.square.types.CreateGiftCardRequest;
import com.squareup.square.types.CreateGiftCardResponse;
import com.squareup.square.types.GetGiftCardFromGanRequest;
import com.squareup.square.types.GetGiftCardFromGanResponse;
import com.squareup.square.types.GetGiftCardFromNonceRequest;
import com.squareup.square.types.GetGiftCardFromNonceResponse;
import com.squareup.square.types.GetGiftCardResponse;
import com.squareup.square.types.GetGiftCardsRequest;
import com.squareup.square.types.GiftCard;
import com.squareup.square.types.LinkCustomerToGiftCardRequest;
import com.squareup.square.types.LinkCustomerToGiftCardResponse;
import com.squareup.square.types.ListGiftCardsRequest;
import com.squareup.square.types.UnlinkCustomerFromGiftCardRequest;
import com.squareup.square.types.UnlinkCustomerFromGiftCardResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncGiftCardsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawGiftCardsClient rawClient;
    protected final Supplier<AsyncActivitiesClient> activitiesClient;

    public AsyncGiftCardsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawGiftCardsClient(clientOptions);
        this.activitiesClient = Suppliers.memoize(() -> new AsyncActivitiesClient(clientOptions));
    }

    public AsyncRawGiftCardsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<GiftCard>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<GiftCard>> list(ListGiftCardsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<GiftCard>> list(ListGiftCardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateGiftCardResponse> create(CreateGiftCardRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateGiftCardResponse)response.body());
    }

    public CompletableFuture<CreateGiftCardResponse> create(CreateGiftCardRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateGiftCardResponse)response.body());
    }

    public CompletableFuture<GetGiftCardFromGanResponse> getFromGan(GetGiftCardFromGanRequest request) {
        return this.rawClient.getFromGan(request).thenApply(response -> (GetGiftCardFromGanResponse)response.body());
    }

    public CompletableFuture<GetGiftCardFromGanResponse> getFromGan(GetGiftCardFromGanRequest request, RequestOptions requestOptions) {
        return this.rawClient.getFromGan(request, requestOptions).thenApply(response -> (GetGiftCardFromGanResponse)response.body());
    }

    public CompletableFuture<GetGiftCardFromNonceResponse> getFromNonce(GetGiftCardFromNonceRequest request) {
        return this.rawClient.getFromNonce(request).thenApply(response -> (GetGiftCardFromNonceResponse)response.body());
    }

    public CompletableFuture<GetGiftCardFromNonceResponse> getFromNonce(GetGiftCardFromNonceRequest request, RequestOptions requestOptions) {
        return this.rawClient.getFromNonce(request, requestOptions).thenApply(response -> (GetGiftCardFromNonceResponse)response.body());
    }

    public CompletableFuture<LinkCustomerToGiftCardResponse> linkCustomer(LinkCustomerToGiftCardRequest request) {
        return this.rawClient.linkCustomer(request).thenApply(response -> (LinkCustomerToGiftCardResponse)response.body());
    }

    public CompletableFuture<LinkCustomerToGiftCardResponse> linkCustomer(LinkCustomerToGiftCardRequest request, RequestOptions requestOptions) {
        return this.rawClient.linkCustomer(request, requestOptions).thenApply(response -> (LinkCustomerToGiftCardResponse)response.body());
    }

    public CompletableFuture<UnlinkCustomerFromGiftCardResponse> unlinkCustomer(UnlinkCustomerFromGiftCardRequest request) {
        return this.rawClient.unlinkCustomer(request).thenApply(response -> (UnlinkCustomerFromGiftCardResponse)response.body());
    }

    public CompletableFuture<UnlinkCustomerFromGiftCardResponse> unlinkCustomer(UnlinkCustomerFromGiftCardRequest request, RequestOptions requestOptions) {
        return this.rawClient.unlinkCustomer(request, requestOptions).thenApply(response -> (UnlinkCustomerFromGiftCardResponse)response.body());
    }

    public CompletableFuture<GetGiftCardResponse> get(GetGiftCardsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetGiftCardResponse)response.body());
    }

    public CompletableFuture<GetGiftCardResponse> get(GetGiftCardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetGiftCardResponse)response.body());
    }

    public AsyncActivitiesClient activities() {
        return this.activitiesClient.get();
    }
}

