/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawEmployeesClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.Employee;
import com.squareup.square.types.GetEmployeeResponse;
import com.squareup.square.types.GetEmployeesRequest;
import com.squareup.square.types.ListEmployeesRequest;
import java.util.concurrent.CompletableFuture;

public class AsyncEmployeesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawEmployeesClient rawClient;

    public AsyncEmployeesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawEmployeesClient(clientOptions);
    }

    public AsyncRawEmployeesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Employee>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Employee>> list(ListEmployeesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Employee>> list(ListEmployeesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetEmployeeResponse> get(GetEmployeesRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetEmployeeResponse)response.body());
    }

    public CompletableFuture<GetEmployeeResponse> get(GetEmployeesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetEmployeeResponse)response.body());
    }
}

