/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawCustomersClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.customers.AsyncCardsClient;
import com.squareup.square.customers.AsyncCustomAttributeDefinitionsClient;
import com.squareup.square.customers.AsyncCustomAttributesClient;
import com.squareup.square.customers.AsyncGroupsClient;
import com.squareup.square.customers.AsyncSegmentsClient;
import com.squareup.square.types.BulkCreateCustomersRequest;
import com.squareup.square.types.BulkCreateCustomersResponse;
import com.squareup.square.types.BulkDeleteCustomersRequest;
import com.squareup.square.types.BulkDeleteCustomersResponse;
import com.squareup.square.types.BulkRetrieveCustomersRequest;
import com.squareup.square.types.BulkRetrieveCustomersResponse;
import com.squareup.square.types.BulkUpdateCustomersRequest;
import com.squareup.square.types.BulkUpdateCustomersResponse;
import com.squareup.square.types.CreateCustomerRequest;
import com.squareup.square.types.CreateCustomerResponse;
import com.squareup.square.types.Customer;
import com.squareup.square.types.DeleteCustomerResponse;
import com.squareup.square.types.DeleteCustomersRequest;
import com.squareup.square.types.GetCustomerResponse;
import com.squareup.square.types.GetCustomersRequest;
import com.squareup.square.types.ListCustomersRequest;
import com.squareup.square.types.SearchCustomersRequest;
import com.squareup.square.types.SearchCustomersResponse;
import com.squareup.square.types.UpdateCustomerRequest;
import com.squareup.square.types.UpdateCustomerResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncCustomersClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCustomersClient rawClient;
    protected final Supplier<AsyncCustomAttributeDefinitionsClient> customAttributeDefinitionsClient;
    protected final Supplier<AsyncGroupsClient> groupsClient;
    protected final Supplier<AsyncSegmentsClient> segmentsClient;
    protected final Supplier<AsyncCardsClient> cardsClient;
    protected final Supplier<AsyncCustomAttributesClient> customAttributesClient;

    public AsyncCustomersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomersClient(clientOptions);
        this.customAttributeDefinitionsClient = Suppliers.memoize(() -> new AsyncCustomAttributeDefinitionsClient(clientOptions));
        this.groupsClient = Suppliers.memoize(() -> new AsyncGroupsClient(clientOptions));
        this.segmentsClient = Suppliers.memoize(() -> new AsyncSegmentsClient(clientOptions));
        this.cardsClient = Suppliers.memoize(() -> new AsyncCardsClient(clientOptions));
        this.customAttributesClient = Suppliers.memoize(() -> new AsyncCustomAttributesClient(clientOptions));
    }

    public AsyncRawCustomersClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Customer>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Customer>> list(ListCustomersRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Customer>> list(ListCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateCustomerResponse> create() {
        return this.rawClient.create().thenApply(response -> (CreateCustomerResponse)response.body());
    }

    public CompletableFuture<CreateCustomerResponse> create(CreateCustomerRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateCustomerResponse)response.body());
    }

    public CompletableFuture<CreateCustomerResponse> create(CreateCustomerRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateCustomerResponse)response.body());
    }

    public CompletableFuture<BulkCreateCustomersResponse> batchCreate(BulkCreateCustomersRequest request) {
        return this.rawClient.batchCreate(request).thenApply(response -> (BulkCreateCustomersResponse)response.body());
    }

    public CompletableFuture<BulkCreateCustomersResponse> batchCreate(BulkCreateCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchCreate(request, requestOptions).thenApply(response -> (BulkCreateCustomersResponse)response.body());
    }

    public CompletableFuture<BulkDeleteCustomersResponse> bulkDeleteCustomers(BulkDeleteCustomersRequest request) {
        return this.rawClient.bulkDeleteCustomers(request).thenApply(response -> (BulkDeleteCustomersResponse)response.body());
    }

    public CompletableFuture<BulkDeleteCustomersResponse> bulkDeleteCustomers(BulkDeleteCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkDeleteCustomers(request, requestOptions).thenApply(response -> (BulkDeleteCustomersResponse)response.body());
    }

    public CompletableFuture<BulkRetrieveCustomersResponse> bulkRetrieveCustomers(BulkRetrieveCustomersRequest request) {
        return this.rawClient.bulkRetrieveCustomers(request).thenApply(response -> (BulkRetrieveCustomersResponse)response.body());
    }

    public CompletableFuture<BulkRetrieveCustomersResponse> bulkRetrieveCustomers(BulkRetrieveCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkRetrieveCustomers(request, requestOptions).thenApply(response -> (BulkRetrieveCustomersResponse)response.body());
    }

    public CompletableFuture<BulkUpdateCustomersResponse> bulkUpdateCustomers(BulkUpdateCustomersRequest request) {
        return this.rawClient.bulkUpdateCustomers(request).thenApply(response -> (BulkUpdateCustomersResponse)response.body());
    }

    public CompletableFuture<BulkUpdateCustomersResponse> bulkUpdateCustomers(BulkUpdateCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkUpdateCustomers(request, requestOptions).thenApply(response -> (BulkUpdateCustomersResponse)response.body());
    }

    public CompletableFuture<SearchCustomersResponse> search() {
        return this.rawClient.search().thenApply(response -> (SearchCustomersResponse)response.body());
    }

    public CompletableFuture<SearchCustomersResponse> search(SearchCustomersRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SearchCustomersResponse)response.body());
    }

    public CompletableFuture<SearchCustomersResponse> search(SearchCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SearchCustomersResponse)response.body());
    }

    public CompletableFuture<GetCustomerResponse> get(GetCustomersRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetCustomerResponse)response.body());
    }

    public CompletableFuture<GetCustomerResponse> get(GetCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetCustomerResponse)response.body());
    }

    public CompletableFuture<UpdateCustomerResponse> update(UpdateCustomerRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateCustomerResponse)response.body());
    }

    public CompletableFuture<UpdateCustomerResponse> update(UpdateCustomerRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateCustomerResponse)response.body());
    }

    public CompletableFuture<DeleteCustomerResponse> delete(DeleteCustomersRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteCustomerResponse)response.body());
    }

    public CompletableFuture<DeleteCustomerResponse> delete(DeleteCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteCustomerResponse)response.body());
    }

    public AsyncCustomAttributeDefinitionsClient customAttributeDefinitions() {
        return this.customAttributeDefinitionsClient.get();
    }

    public AsyncGroupsClient groups() {
        return this.groupsClient.get();
    }

    public AsyncSegmentsClient segments() {
        return this.segmentsClient.get();
    }

    public AsyncCardsClient cards() {
        return this.cardsClient.get();
    }

    public AsyncCustomAttributesClient customAttributes() {
        return this.customAttributesClient.get();
    }
}

