/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawBankAccountsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.BankAccount;
import com.squareup.square.types.GetBankAccountByV1IdResponse;
import com.squareup.square.types.GetBankAccountResponse;
import com.squareup.square.types.GetBankAccountsRequest;
import com.squareup.square.types.GetByV1IdBankAccountsRequest;
import com.squareup.square.types.ListBankAccountsRequest;
import java.util.concurrent.CompletableFuture;

public class AsyncBankAccountsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawBankAccountsClient rawClient;

    public AsyncBankAccountsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawBankAccountsClient(clientOptions);
    }

    public AsyncRawBankAccountsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<BankAccount>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<BankAccount>> list(ListBankAccountsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<BankAccount>> list(ListBankAccountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetBankAccountByV1IdResponse> getByV1Id(GetByV1IdBankAccountsRequest request) {
        return this.rawClient.getByV1Id(request).thenApply(response -> (GetBankAccountByV1IdResponse)response.body());
    }

    public CompletableFuture<GetBankAccountByV1IdResponse> getByV1Id(GetByV1IdBankAccountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.getByV1Id(request, requestOptions).thenApply(response -> (GetBankAccountByV1IdResponse)response.body());
    }

    public CompletableFuture<GetBankAccountResponse> get(GetBankAccountsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetBankAccountResponse)response.body());
    }

    public CompletableFuture<GetBankAccountResponse> get(GetBankAccountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetBankAccountResponse)response.body());
    }
}

