/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jgrapht.graph;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import sqldelight.org.jgrapht.Graph;
import sqldelight.org.jgrapht.GraphType;
import sqldelight.org.jgrapht.graph.GraphSpecificsStrategy;
import sqldelight.org.jgrapht.graph.IntrusiveEdgesSpecifics;
import sqldelight.org.jgrapht.graph.UniformIntrusiveEdgesSpecifics;
import sqldelight.org.jgrapht.graph.WeightedIntrusiveEdgesSpecifics;
import sqldelight.org.jgrapht.graph.specifics.FastLookupDirectedSpecifics;
import sqldelight.org.jgrapht.graph.specifics.FastLookupUndirectedSpecifics;
import sqldelight.org.jgrapht.graph.specifics.Specifics;

public class FastLookupGraphSpecificsStrategy<V, E>
implements GraphSpecificsStrategy<V, E> {
    private static final long serialVersionUID = -5490869870275054280L;

    @Override
    public Function<GraphType, IntrusiveEdgesSpecifics<V, E>> getIntrusiveEdgesSpecificsFactory() {
        return (Function<GraphType, IntrusiveEdgesSpecifics> & Serializable)type2 -> {
            if (type2.isWeighted()) {
                return new WeightedIntrusiveEdgesSpecifics(new LinkedHashMap());
            }
            return new UniformIntrusiveEdgesSpecifics(new LinkedHashMap());
        };
    }

    @Override
    public BiFunction<Graph<V, E>, GraphType, Specifics<V, E>> getSpecificsFactory() {
        return (BiFunction<Graph, GraphType, Specifics> & Serializable)(graph, type2) -> {
            if (type2.isDirected()) {
                return new FastLookupDirectedSpecifics(graph, new LinkedHashMap(), new HashMap(), this.getEdgeSetFactory());
            }
            return new FastLookupUndirectedSpecifics(graph, new LinkedHashMap(), new HashMap(), this.getEdgeSetFactory());
        };
    }
}

