/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.batik.anim.dom;

import sqldelight.org.apache.batik.anim.dom.AbstractElement;
import sqldelight.org.apache.batik.anim.dom.AbstractSVGAnimatedValue;
import sqldelight.org.apache.batik.anim.dom.AnimationTarget;
import sqldelight.org.apache.batik.anim.values.AnimatableStringValue;
import sqldelight.org.apache.batik.anim.values.AnimatableValue;
import sqldelight.org.w3c.dom.Attr;
import sqldelight.org.w3c.dom.DOMException;
import sqldelight.org.w3c.dom.svg.SVGAnimatedString;

public class SVGOMAnimatedString
extends AbstractSVGAnimatedValue
implements SVGAnimatedString {
    protected String animVal;

    public SVGOMAnimatedString(AbstractElement elt, String ns, String ln) {
        super(elt, ns, ln);
    }

    @Override
    public String getBaseVal() {
        return this.element.getAttributeNS(this.namespaceURI, this.localName);
    }

    @Override
    public void setBaseVal(String baseVal) throws DOMException {
        this.element.setAttributeNS(this.namespaceURI, this.localName, baseVal);
    }

    @Override
    public String getAnimVal() {
        if (this.hasAnimVal) {
            return this.animVal;
        }
        return this.element.getAttributeNS(this.namespaceURI, this.localName);
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget target) {
        return new AnimatableStringValue(target, this.getBaseVal());
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue val) {
        if (val == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            this.animVal = ((AnimatableStringValue)val).getString();
        }
        this.fireAnimatedAttributeListeners();
    }

    @Override
    public void attrAdded(Attr node, String newv) {
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrModified(Attr node, String oldv, String newv) {
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrRemoved(Attr node, String oldv) {
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }
}

