/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.dk.brics.automaton;

import java.io.Serializable;
import sqldelight.dk.brics.automaton.State;

public class Transition
implements Serializable,
Cloneable {
    static final long serialVersionUID = 40001L;
    char min;
    char max;
    State to;

    public Transition(char c, State to) {
        this.min = this.max = c;
        this.to = to;
    }

    public Transition(char min, char max, State to) {
        if (max < min) {
            char t = max;
            max = min;
            min = t;
        }
        this.min = min;
        this.max = max;
        this.to = to;
    }

    public char getMin() {
        return this.min;
    }

    public char getMax() {
        return this.max;
    }

    public State getDest() {
        return this.to;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Transition) {
            Transition t = (Transition)obj;
            return t.min == this.min && t.max == this.max && t.to == this.to;
        }
        return false;
    }

    public int hashCode() {
        return this.min * 2 + this.max * 3;
    }

    public Transition clone() {
        try {
            return (Transition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static void appendCharString(char c, StringBuilder b) {
        if (c >= '!' && c <= '~' && c != '\\' && c != '\"') {
            b.append(c);
        } else {
            b.append("\\u");
            String s = Integer.toHexString(c);
            if (c < '\u0010') {
                b.append("000").append(s);
            } else if (c < '\u0100') {
                b.append("00").append(s);
            } else if (c < '\u1000') {
                b.append("0").append(s);
            } else {
                b.append(s);
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        Transition.appendCharString(this.min, b);
        if (this.min != this.max) {
            b.append("-");
            Transition.appendCharString(this.max, b);
        }
        b.append(" -> ").append(this.to.number);
        return b.toString();
    }

    void appendDot(StringBuilder b) {
        b.append(" -> ").append(this.to.number).append(" [label=\"");
        Transition.appendCharString(this.min, b);
        if (this.min != this.max) {
            b.append("-");
            Transition.appendCharString(this.max, b);
        }
        b.append("\"]\n");
    }
}

