/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.squareup.kotlinpoet;

import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import sqldelight.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB!\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\u0006\u0010\u001d\u001a\u00020\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lsqldelight/com/squareup/kotlinpoet/LineWrapper;", "Ljava/io/Closeable;", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "indent", "", "columnLimit", "", "(Ljava/lang/Appendable;Ljava/lang/String;I)V", "closed", "", "hasPendingSegments", "getHasPendingSegments", "()Z", "indentLevel", "linePrefix", "segments", "", "append", "", "s", "appendNonWrapping", "close", "emitCurrentLine", "emitSegmentRange", "startIndex", "endIndex", "foldUnsafeBreaks", "newline", "Companion", "kotlinpoet"})
public final class LineWrapper
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Appendable out;
    @NotNull
    private final String indent;
    private final int columnLimit;
    private boolean closed;
    @NotNull
    private final List<String> segments;
    private int indentLevel;
    @NotNull
    private String linePrefix;
    @NotNull
    private static final Regex UNSAFE_LINE_START = new Regex("\\s*[-+].*");
    @NotNull
    private static final char[] SPECIAL_CHARACTERS;

    public LineWrapper(@NotNull Appendable out, @NotNull String indent, int columnLimit) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        this.out = out;
        this.indent = indent;
        this.columnLimit = columnLimit;
        Object[] objectArray = new String[]{""};
        this.segments = CollectionsKt.mutableListOf((Object[])objectArray);
        this.indentLevel = -1;
        this.linePrefix = "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getHasPendingSegments() {
        if (this.segments.size() != 1) return true;
        CharSequence charSequence = this.segments.get(0);
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        return true;
    }

    public final void append(@NotNull String s, int indentLevel, @NotNull String linePrefix) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)linePrefix, (String)"linePrefix");
        boolean bl = !this.closed;
        char c = '\u0000';
        int n = 0;
        if (!bl) {
            boolean bl2 = false;
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int pos = 0;
        while (pos < s.length()) {
            c = s.charAt(pos);
            if (c == ' ') {
                this.indentLevel = indentLevel;
                this.linePrefix = linePrefix;
                LineWrapper lineWrapper = this;
                Collection collection = lineWrapper.segments;
                String string = "";
                boolean bl3 = false;
                collection.add(string);
                n = pos;
                pos = n + 1;
                continue;
            }
            if (c == '\n') {
                this.newline();
                n = pos;
                pos = n + 1;
                continue;
            }
            if (c == '\u00b7') {
                List<String> list = this.segments;
                int n2 = this.segments.size() - 1;
                list.set(n2, Intrinsics.stringPlus((String)list.get(n2), (Object)" "));
                n = pos;
                pos = n + 1;
                continue;
            }
            int next = StringsKt.indexOfAny$default((CharSequence)s, (char[])SPECIAL_CHARACTERS, (int)pos, (boolean)false, (int)4, null);
            if (next == -1) {
                next = s.length();
            }
            List<String> list = this.segments;
            int n3 = this.segments.size() - 1;
            String string = s;
            boolean bl4 = false;
            String string2 = string.substring(pos, next);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            list.set(n3, Intrinsics.stringPlus((String)list.get(n3), (Object)string2));
            pos = next;
        }
    }

    public static /* synthetic */ void append$default(LineWrapper lineWrapper, String string, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        lineWrapper.append(string, n, string2);
    }

    public final void appendNonWrapping(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        boolean bl = !this.closed;
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = !StringsKt.contains$default((CharSequence)s, (CharSequence)"\n", (boolean)false, (int)2, null);
        n = 0;
        bl2 = false;
        bl2 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List<String> list = this.segments;
        n = this.segments.size() - 1;
        list.set(n, Intrinsics.stringPlus((String)list.get(n), (Object)s));
    }

    public final void newline() {
        boolean bl = !this.closed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.emitCurrentLine();
        this.out.append("\n");
        this.indentLevel = -1;
    }

    @Override
    public void close() {
        this.emitCurrentLine();
        this.closed = true;
    }

    private final void emitCurrentLine() {
        this.foldUnsafeBreaks();
        int start = 0;
        int columnCount = this.segments.get(0).length();
        int n = 1;
        int n2 = this.segments.size();
        if (n < n2) {
            do {
                int i;
                String segment;
                int newColumnCount;
                if ((newColumnCount = columnCount + 1 + (segment = this.segments.get(i = n++)).length()) > this.columnLimit) {
                    this.emitSegmentRange(start, i);
                    start = i;
                    columnCount = segment.length() + this.indent.length() * this.indentLevel;
                    continue;
                }
                columnCount = newColumnCount;
            } while (n < n2);
        }
        this.emitSegmentRange(start, this.segments.size());
        this.segments.clear();
        LineWrapper lineWrapper = this;
        Collection collection = lineWrapper.segments;
        String string = "";
        boolean bl = false;
        collection.add(string);
    }

    private final void emitSegmentRange(int startIndex, int endIndex) {
        int n;
        if (startIndex > 0) {
            this.out.append("\n");
            n = 0;
            int n2 = this.indentLevel;
            if (n < n2) {
                do {
                    int i = n++;
                    this.out.append(this.indent);
                } while (n < n2);
            }
            this.out.append(this.linePrefix);
        }
        this.out.append(this.segments.get(startIndex));
        n = startIndex + 1;
        if (n < endIndex) {
            do {
                int i = n++;
                this.out.append(" ");
                this.out.append(this.segments.get(i));
            } while (n < endIndex);
        }
    }

    private final void foldUnsafeBreaks() {
        int i = 1;
        while (i < this.segments.size()) {
            int n;
            String segment = this.segments.get(i);
            if (UNSAFE_LINE_START.matches((CharSequence)segment)) {
                this.segments.set(i - 1, this.segments.get(i - 1) + ' ' + this.segments.get(i));
                this.segments.remove(i);
                if (i <= 1) continue;
                n = i;
                i = n + -1;
                continue;
            }
            n = i;
            i = n + 1;
        }
    }

    static {
        String string = " \n\u00b7";
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        SPECIAL_CHARACTERS = cArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lsqldelight/com/squareup/kotlinpoet/LineWrapper$Companion;", "", "()V", "SPECIAL_CHARACTERS", "", "UNSAFE_LINE_START", "Lkotlin/text/Regex;", "kotlinpoet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

