/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import sqldelight.com.intellij.diagnostic.StartUpMeasurer;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.io.FileUtil;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.ui.icons.IconLoadMeasurer;
import sqldelight.com.intellij.util.ImageLoader;
import sqldelight.com.intellij.util.SVGLoaderCacheIO;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class SVGLoaderCache {
    private static final long MAX_IMAGE_SIZE = 0x1000000L;

    @NotNull
    protected abstract Path getCachesHome();

    protected abstract void forkIOTask(@NotNull Runnable var1);

    @NotNull
    private Path cacheFile(byte @NotNull [] theme, byte @NotNull [] imageBytes, double scale) {
        Path path;
        if (theme == null) {
            SVGLoaderCache.$$$reportNull$$$0(0);
        }
        if (imageBytes == null) {
            SVGLoaderCache.$$$reportNull$$$0(1);
        }
        try {
            MessageDigest d = MessageDigest.getInstance("SHA-256");
            d.update(theme);
            d.update(imageBytes);
            String hex = StringUtil.toHexString(d.digest());
            path = this.getCachesHome().resolve(hex + ".x" + scale);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA1 is not supported!", e);
        }
        if (path == null) {
            SVGLoaderCache.$$$reportNull$$$0(2);
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BufferedImage loadFromCache(byte @NotNull [] theme, byte @NotNull [] imageBytes, double scale, @NotNull ImageLoader.Dimension2DDouble dimension2DDouble) {
        Path file;
        if (dimension2DDouble == null) {
            SVGLoaderCache.$$$reportNull$$$0(3);
        }
        if (theme == null) {
            SVGLoaderCache.$$$reportNull$$$0(4);
        }
        if (imageBytes == null) {
            SVGLoaderCache.$$$reportNull$$$0(5);
        }
        if (!Files.isRegularFile(file = this.cacheFile(theme, imageBytes, scale), new LinkOption[0])) {
            return null;
        }
        try {
            long size = Files.size(file);
            if (size > 0x1000000L) {
                this.forkIOTask(() -> {
                    try {
                        FileUtil.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        try {
            void docSize;
            long start = StartUpMeasurer.isEnabled() ? StartUpMeasurer.getCurrentTime() : -1L;
            byte[] bytes = Files.readAllBytes(file);
            BufferedImage image = SVGLoaderCacheIO.readImageFile(bytes, (ImageLoader.Dimension2DDouble)docSize);
            IconLoadMeasurer.svgCacheRead.addDurationStartedAt(start);
            return image;
        }
        catch (Exception e) {
            Logger.getInstance(this.getClass()).warn("Failed to read SVG cache from: " + file + ". " + e.getMessage(), e);
            this.forkIOTask(() -> {
                try {
                    FileUtil.delete(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void storeLoadedImage(byte @NotNull [] theme, byte @NotNull [] imageBytes, double scale, @NotNull BufferedImage image, @NotNull ImageLoader.Dimension2DDouble dimension2DDouble) {
        void size;
        if (image == null) {
            SVGLoaderCache.$$$reportNull$$$0(6);
        }
        if (dimension2DDouble == null) {
            SVGLoaderCache.$$$reportNull$$$0(7);
        }
        if (theme == null) {
            SVGLoaderCache.$$$reportNull$$$0(8);
        }
        if (imageBytes == null) {
            SVGLoaderCache.$$$reportNull$$$0(9);
        }
        if (image.getType() != 2) {
            Logger.getInstance(this.getClass()).warn("Unsupported image type for SVGLoader cache: " + image.getType());
            return;
        }
        this.forkIOTask(() -> this.lambda$storeLoadedImage$2(theme, imageBytes, scale, image, (ImageLoader.Dimension2DDouble)size));
    }

    private /* synthetic */ void lambda$storeLoadedImage$2(byte[] theme, byte[] imageBytes, double scale, BufferedImage image, ImageLoader.Dimension2DDouble size) {
        long start = StartUpMeasurer.isEnabled() ? StartUpMeasurer.getCurrentTime() : -1L;
        Path file = this.cacheFile(theme, imageBytes, scale);
        try {
            SVGLoaderCacheIO.writeImageFile(file, image, size);
        }
        catch (Exception e) {
            Logger.getInstance(SVGLoaderCache.class).warn("Failed to write SVG cache to: " + file + ". " + e.getMessage(), e);
        }
        IconLoadMeasurer.svgCacheWrite.addDurationStartedAt(start);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageBytes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/SVGLoaderCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docSize";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/SVGLoaderCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cacheFile";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadFromCache";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "storeLoadedImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

