/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.stubs;

import java.util.List;
import sqldelight.com.intellij.lang.ASTNode;
import sqldelight.com.intellij.lang.FileASTNode;
import sqldelight.com.intellij.lang.LighterAST;
import sqldelight.com.intellij.lang.LighterASTNode;
import sqldelight.com.intellij.lang.TreeBackedLighterAST;
import sqldelight.com.intellij.openapi.diagnostic.LogUtil;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.fileTypes.LanguageFileType;
import sqldelight.com.intellij.openapi.progress.ProgressManager;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.StubBuilder;
import sqldelight.com.intellij.psi.impl.source.PsiFileImpl;
import sqldelight.com.intellij.psi.stubs.ILightStubElementType;
import sqldelight.com.intellij.psi.stubs.IStubElementType;
import sqldelight.com.intellij.psi.stubs.ObjectStubBase;
import sqldelight.com.intellij.psi.stubs.PsiFileStubImpl;
import sqldelight.com.intellij.psi.stubs.StubElement;
import sqldelight.com.intellij.psi.tree.IElementType;
import sqldelight.com.intellij.psi.tree.ILightStubFileElementType;
import sqldelight.com.intellij.util.containers.BooleanStack;
import sqldelight.com.intellij.util.containers.Stack;
import sqldelight.gnu.trove.TIntStack;
import sqldelight.org.jetbrains.annotations.NotNull;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance(LightStubBuilder.class);
    public static final ThreadLocal<LighterAST> FORCED_AST = new ThreadLocal();

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file) {
        LighterAST tree;
        if (file == null) {
            LightStubBuilder.$$$reportNull$$$0(0);
        }
        if ((tree = FORCED_AST.get()) == null) {
            FileType fileType = file.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                LOG.error("File is not of LanguageFileType: " + file + ", " + fileType);
                return null;
            }
            if (!(file instanceof PsiFileImpl)) {
                LOG.error("Unexpected PsiFile instance: " + file + ", " + file.getClass());
                return null;
            }
            if (((PsiFileImpl)file).getElementTypeForStubBuilder() == null) {
                LOG.error("File is not of IStubFileElementType: " + file);
                return null;
            }
            FileASTNode node = file.getNode();
            tree = node.getElementType() instanceof ILightStubFileElementType ? node.getLighterAST() : new TreeBackedLighterAST(node);
        } else {
            FORCED_AST.set(null);
        }
        StubElement rootStub = this.createStubForFile(file, tree);
        this.buildStubTree(tree, tree.getRoot(), rootStub);
        return rootStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file, @NotNull LighterAST tree) {
        if (file == null) {
            LightStubBuilder.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(2);
        }
        return new PsiFileStubImpl<PsiFile>(file);
    }

    protected void buildStubTree(@NotNull LighterAST tree, @NotNull LighterASTNode root, @NotNull StubElement rootStub) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(3);
        }
        if (root == null) {
            LightStubBuilder.$$$reportNull$$$0(4);
        }
        if (rootStub == null) {
            LightStubBuilder.$$$reportNull$$$0(5);
        }
        Stack<LighterASTNode> parents = new Stack<LighterASTNode>();
        TIntStack childNumbers = new TIntStack();
        BooleanStack parentsStubbed = new BooleanStack();
        Stack<List> kinderGarden = new Stack<List>();
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        LighterASTNode parent = null;
        LighterASTNode element = root;
        List children2 = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        boolean immediateParentStubbed = true;
        block0: while (element != null) {
            List kids;
            boolean hasStub;
            ProgressManager.checkCanceled();
            StubElement stub = LightStubBuilder.createStub(tree, element, parentStub);
            boolean bl = hasStub = stub != parentStub || parent == null;
            if (hasStub && !immediateParentStubbed) {
                ((ObjectStubBase)((Object)stub)).markDangling();
            }
            if (!(parent != null && this.skipNode(tree, parent, element) || (kids = tree.getChildren(element)).isEmpty())) {
                if (parent != null) {
                    parents.push(parent);
                    childNumbers.push(childNumber);
                    kinderGarden.push(children2);
                    parentStubs.push(parentStub);
                    parentsStubbed.push(immediateParentStubbed);
                }
                parent = element;
                immediateParentStubbed = hasStub;
                children2 = kids;
                childNumber = 0;
                element = children2.get(0);
                parentStub = stub;
                if (!this.skipNode(tree, parent, element)) continue;
            }
            while (children2 != null && ++childNumber < children2.size()) {
                element = (LighterASTNode)children2.get(childNumber);
                if (this.skipNode(tree, parent, element)) continue;
                continue block0;
            }
            element = null;
            while (!parents.isEmpty()) {
                parent = (LighterASTNode)parents.pop();
                childNumber = childNumbers.pop();
                children2 = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                immediateParentStubbed = parentsStubbed.pop();
                while (++childNumber < children2.size()) {
                    element = (LighterASTNode)children2.get(childNumber);
                    if (this.skipNode(tree, parent, element)) continue;
                    continue block0;
                }
                element = null;
            }
        }
    }

    @NotNull
    private static StubElement createStub(@NotNull LighterAST tree, @NotNull LighterASTNode element, @NotNull StubElement parentStub) {
        IElementType elementType;
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(6);
        }
        if (element == null) {
            LightStubBuilder.$$$reportNull$$$0(7);
        }
        if (parentStub == null) {
            LightStubBuilder.$$$reportNull$$$0(8);
        }
        if ((elementType = element.getTokenType()) instanceof IStubElementType) {
            if (elementType instanceof ILightStubElementType) {
                ILightStubElementType lightElementType = (ILightStubElementType)elementType;
                if (lightElementType.shouldCreateStub(tree, element, parentStub)) {
                    Object StubT = lightElementType.createStub(tree, element, parentStub);
                    if (StubT == null) {
                        LightStubBuilder.$$$reportNull$$$0(9);
                    }
                    return StubT;
                }
            } else {
                LOG.error("Element is not of ILightStubElementType: " + LogUtil.objectAndClass(elementType) + ", " + element);
            }
        }
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            LightStubBuilder.$$$reportNull$$$0(10);
        }
        return stubElement;
    }

    private boolean skipNode(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            LightStubBuilder.$$$reportNull$$$0(12);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(13);
        }
        if (tree instanceof TreeBackedLighterAST) {
            return this.skipChildProcessingWhenBuildingStubs(((TreeBackedLighterAST)tree).unwrap(parent), ((TreeBackedLighterAST)tree).unwrap(node));
        }
        return this.skipChildProcessingWhenBuildingStubs(tree, parent, node);
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            LightStubBuilder.$$$reportNull$$$0(14);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(15);
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            LightStubBuilder.$$$reportNull$$$0(17);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(18);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/stubs/LightStubBuilder";
                break;
            }
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/stubs/LightStubBuilder";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "skipNode";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "skipChildProcessingWhenBuildingStubs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

