/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.util.registry;

import java.awt.Color;
import java.util.List;
import java.util.MissingResourceException;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.Disposer;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import sqldelight.com.intellij.openapi.util.registry.RegistryValueListener;
import sqldelight.com.intellij.ui.ColorHexUtil;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class RegistryValue {
    private final Registry myRegistry;
    private final String myKey;
    @Nullable
    private final RegistryKeyDescriptor myKeyDescriptor;
    private final List<RegistryValueListener> myListeners;
    private boolean myChangedSinceStart;
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private double myDoubleCachedValue;
    private Boolean myBooleanCachedValue;
    private static final Logger LOG = Logger.getInstance(RegistryValue.class);

    RegistryValue(@NotNull Registry registry, @NonNls @NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) {
        if (registry == null) {
            RegistryValue.$$$reportNull$$$0(0);
        }
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(1);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDoubleCachedValue = Double.NaN;
        this.myRegistry = registry;
        this.myKey = key;
        this.myKeyDescriptor = keyDescriptor;
    }

    @NotNull
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            RegistryValue.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String asString() {
        String value = this.get(this.myKey, null, true);
        assert (value != null) : this.myKey;
        String string = value;
        if (string == null) {
            RegistryValue.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean asBoolean() {
        Boolean result = this.myBooleanCachedValue;
        if (result == null) {
            this.myBooleanCachedValue = result = this.calcBoolean();
        }
        return result;
    }

    @NotNull
    private Boolean calcBoolean() {
        Boolean bl = Boolean.valueOf(this.get(this.myKey, "false", true));
        if (bl == null) {
            RegistryValue.$$$reportNull$$$0(4);
        }
        return bl;
    }

    public int asInteger() {
        Integer result = this.myIntCachedValue;
        if (result == null) {
            this.myIntCachedValue = result = this.calcInt();
        }
        return result;
    }

    @NotNull
    private Integer calcInt() {
        Integer n;
        try {
            n = Integer.valueOf(this.get(this.myKey, "0", true));
        }
        catch (NumberFormatException e) {
            String bundleValue = Registry.getInstance().getBundleValue(this.myKey, true);
            assert (bundleValue != null);
            Integer n2 = Integer.valueOf(bundleValue);
            if (n2 == null) {
                RegistryValue.$$$reportNull$$$0(6);
            }
            return n2;
        }
        if (n == null) {
            RegistryValue.$$$reportNull$$$0(5);
        }
        return n;
    }

    public double asDouble() {
        double result = this.myDoubleCachedValue;
        if (Double.isNaN(result)) {
            this.myDoubleCachedValue = result = this.calcDouble();
        }
        return result;
    }

    private double calcDouble() {
        try {
            return Double.parseDouble(this.get(this.myKey, "0.0", true));
        }
        catch (NumberFormatException e) {
            String bundleValue = Registry.getInstance().getBundleValue(this.myKey, true);
            assert (bundleValue != null);
            return Double.parseDouble(bundleValue);
        }
    }

    Color asColor(Color defaultValue) {
        String s = this.get(this.myKey, null, true);
        if (s != null) {
            Color color = ColorHexUtil.fromHex(s, null);
            if (color != null && this.myKey.contains("color")) {
                return color;
            }
            String[] rgb = s.split(",");
            if (rgb.length == 3) {
                try {
                    return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    @NotNull
    public String getDescription() {
        if (this.myKeyDescriptor != null) {
            String string = this.myKeyDescriptor.getDescription();
            if (string == null) {
                RegistryValue.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = this.get(this.myKey + ".description", "", false);
        if (string == null) {
            RegistryValue.$$$reportNull$$$0(8);
        }
        return string;
    }

    boolean isRestartRequired() {
        if (this.myKeyDescriptor != null) {
            return this.myKeyDescriptor.isRestartRequired();
        }
        return Boolean.parseBoolean(this.get(this.myKey + ".restartRequired", "false", false));
    }

    public boolean isChangedFromDefault() {
        return this.isChangedFromDefault(this.asString(), Registry.getInstance());
    }

    @Nullable
    public String getPluginId() {
        return this.myKeyDescriptor != null ? this.myKeyDescriptor.getPluginId() : null;
    }

    final boolean isChangedFromDefault(@NotNull String newValue, @NotNull Registry registry) {
        if (newValue == null) {
            RegistryValue.$$$reportNull$$$0(9);
        }
        if (registry == null) {
            RegistryValue.$$$reportNull$$$0(10);
        }
        return !newValue.equals(registry.getBundleValue(this.myKey, false));
    }

    protected String get(@NonNls @NotNull String key, String defaultValue, boolean isValue) throws MissingResourceException {
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(11);
        }
        if (isValue) {
            if (this.myStringCachedValue == null) {
                this.myStringCachedValue = this._get(key, defaultValue, true);
            }
            return this.myStringCachedValue;
        }
        return this._get(key, defaultValue, false);
    }

    @Nullable
    private String _get(@NonNls @NotNull String key, @Nullable String defaultValue, boolean mustExistInBundle) throws MissingResourceException {
        String bundleValue;
        String userValue;
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(12);
        }
        if ((userValue = this.myRegistry.getUserProperties().get(key)) != null) {
            return userValue;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        if (!this.myRegistry.isLoaded()) {
            LOG.warn("The registry key '" + key + "' accessed, but not loaded yet");
        }
        return (bundleValue = Registry.getInstance().getBundleValue(key, mustExistInBundle)) == null ? defaultValue : bundleValue;
    }

    public void setValue(boolean value) {
        this.setValue(Boolean.toString(value));
    }

    public void setValue(int value) {
        this.setValue(Integer.toString(value));
    }

    public void setValue(String value) {
        this.resetCache();
        for (RegistryValueListener each : this.myListeners) {
            each.beforeValueChanged(this);
        }
        this.myRegistry.getUserProperties().put(this.myKey, value);
        for (RegistryValueListener each : this.myListeners) {
            each.afterValueChanged(this);
        }
        if (!this.isChangedFromDefault() && !this.isRestartRequired()) {
            this.myRegistry.getUserProperties().remove(this.myKey);
        }
        this.myChangedSinceStart = true;
        LOG.info("Registry value '" + this.myKey + "' has changed to '" + value + '\'');
    }

    public void setValue(boolean value, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RegistryValue.$$$reportNull$$$0(13);
        }
        boolean prev = this.asBoolean();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> this.setValue(prev));
    }

    public void setValue(int value, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RegistryValue.$$$reportNull$$$0(14);
        }
        int prev = this.asInteger();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> this.setValue(prev));
    }

    public void setValue(String value, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RegistryValue.$$$reportNull$$$0(15);
        }
        String prev = this.asString();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> this.setValue(prev));
    }

    boolean isChangedSinceAppStart() {
        return this.myChangedSinceStart;
    }

    public void resetToDefault() {
        this.setValue(Registry.getInstance().getBundleValue(this.myKey, true));
    }

    public void addListener(@NotNull RegistryValueListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            RegistryValue.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            RegistryValue.$$$reportNull$$$0(17);
        }
        this.myListeners.add(listener);
        Disposer.register(parent, () -> this.myListeners.remove(listener));
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    void resetCache() {
        this.myStringCachedValue = null;
        this.myIntCachedValue = null;
        this.myDoubleCachedValue = Double.NaN;
        this.myBooleanCachedValue = null;
    }

    public boolean isBoolean() {
        return RegistryValue.isBoolean(this.asString());
    }

    private static boolean isBoolean(String s) {
        return "true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 1: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBoolean";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isChangedFromDefault";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "_get";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

