/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import sqldelight.com.intellij.injected.editor.VirtualFileWindow;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.roots.SourceFolder;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import sqldelight.com.intellij.openapi.util.Condition;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

class DirectoryInfoWithExcludePatterns
extends DirectoryInfoImpl {
    private static final Logger LOG = Logger.getInstance(DirectoryInfoWithExcludePatterns.class);
    @Nullable
    private final FileTypeAssocTable<Boolean> myContentExcludePatterns;
    @Nullable
    private final Condition<? super VirtualFile> myLibraryExcludeCondition;

    DirectoryInfoWithExcludePatterns(@NotNull VirtualFile root, Module module, VirtualFile contentRoot, VirtualFile sourceRoot, @Nullable SourceFolder sourceFolder, VirtualFile libraryClassRoot, boolean inModuleSource, boolean inLibrarySource, boolean isExcluded, @Nullable FileTypeAssocTable<Boolean> contentExcludePatterns, @Nullable Condition<? super VirtualFile> libraryExcludeCondition, @Nullable String unloadedModuleName) {
        if (root == null) {
            DirectoryInfoWithExcludePatterns.$$$reportNull$$$0(0);
        }
        super(root, module, contentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSource, inLibrarySource, isExcluded, unloadedModuleName);
        this.myContentExcludePatterns = contentExcludePatterns;
        this.myLibraryExcludeCondition = libraryExcludeCondition;
        LOG.assertTrue(this.myContentExcludePatterns != null || this.myLibraryExcludeCondition != null, "Directory info of '" + root + "' with exclude patterns have no any exclude patterns: " + this);
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file) {
        if (file == null) {
            DirectoryInfoWithExcludePatterns.$$$reportNull$$$0(1);
        }
        return super.isInLibrarySource(file) && !this.isExcludedByCondition(file, this.myLibraryExcludeCondition);
    }

    private boolean isExcludedByCondition(@NotNull VirtualFile file, @Nullable Condition<? super VirtualFile> condition) {
        VirtualFile current;
        if (file == null) {
            DirectoryInfoWithExcludePatterns.$$$reportNull$$$0(2);
        }
        if (condition == null) {
            return false;
        }
        for (current = DirectoryInfoWithExcludePatterns.getPhysicalFile(file); current != null && !this.myRoot.equals(current); current = current.getParent()) {
            if (!condition.value(current)) continue;
            return true;
        }
        if (current == null) {
            LOG.error("File " + file + " is not under this directory (" + this.myRoot + ")");
        }
        return false;
    }

    private boolean isExcludedByPatterns(@NotNull VirtualFile file, @Nullable FileTypeAssocTable<Boolean> patterns) {
        if (file == null) {
            DirectoryInfoWithExcludePatterns.$$$reportNull$$$0(3);
        }
        return patterns != null && this.isExcludedByCondition(file, f -> patterns.findAssociatedFileType(f.getNameSequence()) != null);
    }

    private static VirtualFile getPhysicalFile(VirtualFile file) {
        return file instanceof VirtualFileWindow ? ((VirtualFileWindow)((Object)file)).getDelegate() : file;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file) {
        VirtualFile current;
        boolean inContent;
        if (file == null) {
            DirectoryInfoWithExcludePatterns.$$$reportNull$$$0(4);
        }
        if (this.isExcluded()) {
            return true;
        }
        if (this.myLibraryExcludeCondition == null && this.myContentExcludePatterns == null) {
            LOG.error("Directory info of '" + this.getRoot() + "' with exclude patterns have no any exclude patterns: " + this);
            return false;
        }
        boolean bl = inContent = this.getContentRoot() != null;
        if (!inContent && !super.isInLibrarySource(file)) {
            return false;
        }
        for (current = DirectoryInfoWithExcludePatterns.getPhysicalFile(file); current != null && !this.myRoot.equals(current); current = current.getParent()) {
            boolean excludedFromLibrary;
            CharSequence name = current.getNameSequence();
            boolean excludedFromModule = this.myContentExcludePatterns != null && this.myContentExcludePatterns.findAssociatedFileType(name) != null;
            boolean bl2 = excludedFromLibrary = this.myLibraryExcludeCondition != null && this.myLibraryExcludeCondition.value(current);
            if (inContent && !excludedFromModule || super.isInLibrarySource(file) && !excludedFromLibrary) continue;
            return true;
        }
        if (current == null) {
            IllegalArgumentException e = new IllegalArgumentException("File " + file + " is not under this directory (" + this.myRoot + ")");
            LOG.warn(e);
            throw e;
        }
        return false;
    }

    @Override
    public boolean isInModuleSource(@NotNull VirtualFile file) {
        if (file == null) {
            DirectoryInfoWithExcludePatterns.$$$reportNull$$$0(5);
        }
        return super.isInModuleSource(file) && !this.isExcludedByPatterns(file, this.myContentExcludePatterns);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInLibrarySource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isExcludedByCondition";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isExcludedByPatterns";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isExcluded";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isInModuleSource";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

