/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.mock;

import java.util.function.Predicate;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.fileEditor.FileDocumentManager;
import sqldelight.com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import sqldelight.com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.util.Function;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class MockFileDocumentManagerImpl
extends FileDocumentManager {
    private static final Key<VirtualFile> MOCK_VIRTUAL_FILE_KEY = Key.create("MockVirtualFile");
    private final Function<? super CharSequence, ? extends Document> myFactory;
    @Nullable
    private final Key<Document> myCachedDocumentKey;
    private static final Key<Document> MOCK_DOC_KEY = Key.create("MOCK_DOC_KEY");

    public MockFileDocumentManagerImpl(Function<? super CharSequence, ? extends Document> factory, @Nullable Key<Document> cachedDocumentKey) {
        this.myFactory = factory;
        this.myCachedDocumentKey = cachedDocumentKey;
    }

    private static boolean isBinaryWithoutDecompiler(VirtualFile file) {
        FileType ft = file.getFileType();
        return ft.isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(ft) == null;
    }

    @Override
    public Document getDocument(@NotNull VirtualFile file) {
        Document document;
        if (file == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(0);
        }
        if ((document = file.getUserData(MOCK_DOC_KEY)) == null) {
            if (file.isDirectory() || MockFileDocumentManagerImpl.isBinaryWithoutDecompiler(file)) {
                return null;
            }
            CharSequence text = LoadTextUtil.loadText(file);
            document = this.myFactory.fun(text);
            document.putUserData(MOCK_VIRTUAL_FILE_KEY, file);
            document = file.putUserDataIfAbsent(MOCK_DOC_KEY, document);
        }
        return document;
    }

    @Override
    public Document getCachedDocument(@NotNull VirtualFile file) {
        if (file == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.myCachedDocumentKey != null) {
            return file.getUserData(this.myCachedDocumentKey);
        }
        return null;
    }

    @Override
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(2);
        }
        return document.getUserData(MOCK_VIRTUAL_FILE_KEY);
    }

    @Override
    public void saveAllDocuments() {
    }

    @Override
    public void saveDocuments(@NotNull Predicate<Document> filter) {
        if (filter == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(3);
        }
    }

    @Override
    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(5);
        }
    }

    @Override
    public Document @NotNull [] getUnsavedDocuments() {
        if (Document.EMPTY_ARRAY == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(6);
        }
        return Document.EMPTY_ARRAY;
    }

    @Override
    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(7);
        }
        return false;
    }

    @Override
    public boolean isFileModified(@NotNull VirtualFile file) {
        if (file == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(8);
        }
        return false;
    }

    @Override
    public boolean isPartialPreviewOfALargeFile(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(9);
        }
        return false;
    }

    @Override
    public void reloadFromDisk(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(10);
        }
    }

    @Override
    public void reloadFiles(VirtualFile ... files) {
        if (files == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(11);
        }
    }

    @Override
    @NotNull
    public String getLineSeparator(VirtualFile file, Project project) {
        return "";
    }

    @Override
    public boolean requestWriting(@NotNull Document document, @Nullable Project project) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(12);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/mock/MockFileDocumentManagerImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/mock/MockFileDocumentManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveDocuments";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveDocument";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveDocumentAsIs";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentUnsaved";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFileModified";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPartialPreviewOfALargeFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reloadFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

