/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ide.ui;

import java.awt.image.ImageFilter;
import java.util.EnumMap;
import sqldelight.com.intellij.ide.ui.ColorBlindness;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.extensions.Extensions;
import sqldelight.org.jetbrains.annotations.Nullable;

public class ColorBlindnessSupport {
    @Nullable
    public static ColorBlindnessSupport get(@Nullable ColorBlindness blindness) {
        return blindness == null ? null : (ColorBlindnessSupport)Lazy.MAP.get((Object)blindness);
    }

    @Nullable
    public ImageFilter getFilter() {
        return null;
    }

    private static final class Lazy {
        private static final EnumMap<ColorBlindness, ColorBlindnessSupport> MAP = Lazy.create();

        private Lazy() {
        }

        private static EnumMap<ColorBlindness, ColorBlindnessSupport> create() {
            EnumMap<ColorBlindness, ColorBlindnessSupport> map = new EnumMap<ColorBlindness, ColorBlindnessSupport>(ColorBlindness.class);
            Lazy.init(map, ColorBlindness.protanopia, "sqldelight.com.intellij.protanopiaSupport");
            Lazy.init(map, ColorBlindness.deuteranopia, "sqldelight.com.intellij.deuteranopiaSupport");
            Lazy.init(map, ColorBlindness.tritanopia, "sqldelight.com.intellij.tritanopiaSupport");
            Lazy.init(map, ColorBlindness.achromatopsia, "sqldelight.com.intellij.achromatopsiaSupport");
            if (map.isEmpty()) {
                map.put(ColorBlindness.deuteranopia, new ColorBlindnessSupport());
            }
            return map;
        }

        private static void init(EnumMap<ColorBlindness, ColorBlindnessSupport> map, ColorBlindness blindness, String extensionName) {
            ColorBlindnessSupport[] extensions = (ColorBlindnessSupport[])Extensions.getRootArea().getExtensionPoint(extensionName).getExtensions();
            ColorBlindnessSupport support = null;
            for (ColorBlindnessSupport ext : extensions) {
                if (support != null) continue;
                support = ext;
            }
            if (support != null) {
                map.put(blindness, support);
                Logger logger2 = Logger.getInstance(ColorBlindnessSupport.class);
                if (logger2.isDebugEnabled()) {
                    logger2.debug(Lazy.toString("use", blindness, support));
                }
                for (ColorBlindnessSupport ext : extensions) {
                    if (support == ext) continue;
                    logger2.warn(Lazy.toString("ignore", blindness, ext));
                }
            }
        }

        private static String toString(String prefix, ColorBlindness blindness, ColorBlindnessSupport support) {
            return prefix + " " + blindness.name() + " from " + support.getClass();
        }
    }
}

