/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.configurationStore;

import java.io.DataOutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import sqldelight.com.intellij.configurationStore.BinaryXmlWriterKt;
import sqldelight.com.intellij.configurationStore.TypeMarker;
import sqldelight.com.intellij.util.io.IOUtil;
import sqldelight.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import sqldelight.org.jdom.Attribute;
import sqldelight.org.jdom.CDATA;
import sqldelight.org.jdom.Content;
import sqldelight.org.jdom.Element;
import sqldelight.org.jdom.Text;
import sqldelight.org.jdom.Verifier;
import sqldelight.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\t2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lsqldelight/com/intellij/configurationStore/BinaryXmlWriter;", "", "out", "Ljava/io/DataOutputStream;", "(Ljava/io/DataOutputStream;)V", "strings", "Lsqldelight/it/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "", "write", "", "element", "Lsqldelight/org/jdom/Element;", "writeAttributes", "attributes", "", "Lsqldelight/org/jdom/Attribute;", "writeElement", "writeString", "string", "writeUInt29", "v", "", "intellij.platform.projectModel.impl"})
public final class BinaryXmlWriter {
    private final Object2IntOpenHashMap<String> strings;
    private final DataOutputStream out;

    public final void write(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.writeElement(element);
    }

    private final void writeString(String string) {
        if (BinaryXmlWriterKt.access$isEmptySafe(string)) {
            this.out.write(1);
            return;
        }
        int reference = this.strings.getInt(string);
        if (reference != -1) {
            this.writeUInt29(reference << 1);
            return;
        }
        this.strings.put(string, this.strings.size());
        this.out.write(3);
        IOUtil.writeUTF(this.out, string);
    }

    private final void writeElement(Element element) {
        String string = element.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.name");
        this.writeString(string);
        this.writeAttributes(element.hasAttributes() ? element.getAttributes() : CollectionsKt.emptyList());
        List<Content> content = element.getContent();
        for (Content item : content) {
            String text;
            Content content2 = item;
            if (content2 instanceof Element) {
                this.out.writeByte(TypeMarker.ELEMENT.ordinal());
                this.writeElement((Element)item);
                continue;
            }
            if (content2 instanceof CDATA) {
                this.out.writeByte(TypeMarker.CDATA.ordinal());
                String string2 = ((CDATA)item).getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"item.text");
                this.writeString(string2);
                continue;
            }
            if (!(content2 instanceof Text) || (text = ((Text)item).getText()) == null || Verifier.isAllXMLWhitespace(text)) continue;
            this.out.writeByte(TypeMarker.TEXT.ordinal());
            this.writeString(text);
        }
        this.out.writeByte(TypeMarker.ELEMENT_END.ordinal());
    }

    private final void writeAttributes(List<? extends Attribute> attributes) {
        List<? extends Attribute> list = attributes;
        int size = list != null ? list.size() : 0;
        this.out.write(size);
        if (size == 0) {
            return;
        }
        if (size > 255) {
            throw (Throwable)new UnsupportedOperationException("attributes size > 255");
        }
        List<? extends Attribute> list2 = attributes;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        for (Attribute attribute : list2) {
            String string = attribute.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attribute.name");
            this.writeString(string);
            String string2 = attribute.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"attribute.value");
            this.writeString(string2);
        }
    }

    private final void writeUInt29(int v) {
        if (v < 128) {
            this.out.write(v);
        } else if (v < 16384) {
            this.out.write(v >> 7 & 0x7F | 0x80);
            this.out.write(v & 0x7F);
        } else if (v < 0x200000) {
            this.out.write(v >> 14 & 0x7F | 0x80);
            this.out.write(v >> 7 & 0x7F | 0x80);
            this.out.write(v & 0x7F);
        } else if (v < 0x40000000) {
            this.out.write(v >> 22 & 0x7F | 0x80);
            this.out.write(v >> 15 & 0x7F | 0x80);
            this.out.write(v >> 8 & 0x7F | 0x80);
            this.out.write(v & 0xFF);
        } else {
            throw (Throwable)new IllegalArgumentException("Integer out of range: " + v);
        }
    }

    public BinaryXmlWriter(@NotNull DataOutputStream out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        this.out = out;
        this.strings = new Object2IntOpenHashMap();
        this.strings.defaultReturnValue(-1);
    }
}

