/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.codeInsight.lookup;

import javax.swing.Icon;
import sqldelight.com.intellij.codeInsight.lookup.LookupElement;
import sqldelight.com.intellij.codeInsight.lookup.LookupElementPresentation;
import sqldelight.com.intellij.codeInsight.lookup.LookupElementRenderer;
import sqldelight.com.intellij.codeInsight.lookup.LookupItem;
import sqldelight.com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import sqldelight.com.intellij.codeInsight.lookup.PresentableLookupValue;
import sqldelight.com.intellij.openapi.util.Iconable;
import sqldelight.com.intellij.openapi.util.ScalableIcon;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.meta.PsiMetaData;
import sqldelight.com.intellij.psi.util.PsiUtilCore;
import sqldelight.com.intellij.ui.SizedIcon;
import sqldelight.com.intellij.util.PlatformIcons;
import sqldelight.org.jetbrains.annotations.Nullable;

public class DefaultLookupItemRenderer
extends LookupElementRenderer<LookupItem<?>> {
    public static final DefaultLookupItemRenderer INSTANCE = new DefaultLookupItemRenderer();

    @Override
    public void renderElement(LookupItem<?> item, LookupElementPresentation presentation) {
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon(item));
        presentation.setItemText(DefaultLookupItemRenderer.getName(item));
        presentation.setItemTextBold(item.getAttribute(LookupItem.HIGHLIGHTED_ATTR) != null);
        presentation.setTailText(DefaultLookupItemRenderer.getText2(item), item.getAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR) != null);
        presentation.setTypeText(DefaultLookupItemRenderer.getText3(item), null);
    }

    @Deprecated
    @Nullable
    public static Icon getRawIcon(LookupElement item, boolean real) {
        return DefaultLookupItemRenderer.getRawIcon(item);
    }

    @Nullable
    public static Icon getRawIcon(LookupElement item) {
        Icon icon = DefaultLookupItemRenderer._getRawIcon(item);
        if (icon instanceof ScalableIcon) {
            icon = ((ScalableIcon)icon).scale(1.0f);
        }
        if (icon != null && icon.getIconHeight() > PlatformIcons.CLASS_ICON.getIconHeight()) {
            return new SizedIcon(icon, icon.getIconWidth(), PlatformIcons.CLASS_ICON.getIconHeight());
        }
        return icon;
    }

    @Nullable
    private static Icon _getRawIcon(LookupElement item) {
        Icon icon;
        if (item instanceof LookupItem && (icon = (Icon)((LookupItem)item).getAttribute(LookupItem.ICON_ATTR)) != null) {
            return icon;
        }
        Object o = item.getObject();
        if (o instanceof Iconable && !(o instanceof PsiElement)) {
            return ((Iconable)o).getIcon(Registry.is("ide.completion.show.visibility.icon") ? 1 : 0);
        }
        PsiElement element = item.getPsiElement();
        if (element != null && element.isValid()) {
            return element.getIcon(Registry.is("ide.completion.show.visibility.icon") ? 1 : 0);
        }
        return null;
    }

    @Nullable
    private static String getText3(LookupItem<?> item) {
        Object o = item.getObject();
        String text = o instanceof LookupValueWithUIHint ? ((LookupValueWithUIHint)o).getTypeHint() : (String)item.getAttribute(LookupItem.TYPE_TEXT_ATTR);
        return text;
    }

    private static String getText2(LookupItem<?> item) {
        return (String)item.getAttribute(LookupItem.TAIL_TEXT_ATTR);
    }

    private static String getName(LookupItem<?> item) {
        String presentableText = item.getPresentableText();
        if (presentableText != null) {
            return presentableText;
        }
        Object o = item.getObject();
        String name = null;
        if (o instanceof PsiElement) {
            PsiElement element = (PsiElement)o;
            if (element.isValid()) {
                name = PsiUtilCore.getName(element);
            }
        } else {
            name = o instanceof PsiMetaData ? ((PsiMetaData)o).getName() : (o instanceof PresentableLookupValue ? ((PresentableLookupValue)o).getPresentation() : String.valueOf(o));
        }
        if (name == null) {
            name = "";
        }
        return name;
    }
}

