/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.codeHighlighting;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import sqldelight.com.intellij.icons.AllIcons;
import sqldelight.com.intellij.lang.annotation.HighlightSeverity;
import sqldelight.com.intellij.openapi.editor.colors.CodeInsightColors;
import sqldelight.com.intellij.openapi.editor.colors.EditorColorsManager;
import sqldelight.com.intellij.openapi.editor.colors.TextAttributesKey;
import sqldelight.com.intellij.openapi.editor.markup.TextAttributes;
import sqldelight.com.intellij.openapi.util.Comparing;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.ui.IconManager;
import sqldelight.com.intellij.ui.JBColor;
import sqldelight.com.intellij.ui.scale.JBUIScale;
import sqldelight.com.intellij.util.ObjectUtils;
import sqldelight.com.intellij.util.ui.ColorIcon;
import sqldelight.com.intellij.util.ui.EmptyIcon;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class HighlightDisplayLevel {
    private static final Map<HighlightSeverity, HighlightDisplayLevel> ourMap = new HashMap<HighlightSeverity, HighlightDisplayLevel>();
    public static final HighlightDisplayLevel GENERIC_SERVER_ERROR_OR_WARNING = new HighlightDisplayLevel(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, new ColorizedIcon(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING, AllIcons.General.InspectionsWarning));
    public static final HighlightDisplayLevel ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR, new ColorizedIcon(CodeInsightColors.ERRORS_ATTRIBUTES, AllIcons.General.InspectionsError));
    public static final HighlightDisplayLevel WARNING = new HighlightDisplayLevel(HighlightSeverity.WARNING, new ColorizedIcon(CodeInsightColors.WARNINGS_ATTRIBUTES, AllIcons.General.InspectionsWarning));
    private static final TextAttributesKey DO_NOT_SHOW_KEY = TextAttributesKey.createTextAttributesKey("DO_NOT_SHOW");
    public static final HighlightDisplayLevel DO_NOT_SHOW = new HighlightDisplayLevel(HighlightSeverity.INFORMATION, EmptyIcon.ICON_0);
    @Deprecated
    public static final HighlightDisplayLevel INFO = new HighlightDisplayLevel(HighlightSeverity.INFO, HighlightDisplayLevel.createIconByKey(DO_NOT_SHOW_KEY));
    public static final HighlightDisplayLevel WEAK_WARNING = new HighlightDisplayLevel(HighlightSeverity.WEAK_WARNING, new ColorizedIcon(CodeInsightColors.WEAK_WARNING_ATTRIBUTES, AllIcons.General.InspectionsWarning));
    public static final HighlightDisplayLevel NON_SWITCHABLE_ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR){

        @Override
        public boolean isNonSwitchable() {
            return true;
        }
    };
    public static final HighlightDisplayLevel NON_SWITCHABLE_WARNING = new HighlightDisplayLevel(HighlightSeverity.WARNING){

        @Override
        public boolean isNonSwitchable() {
            return true;
        }
    };
    private Icon myIcon;
    private final HighlightSeverity mySeverity;

    @Nullable
    public static HighlightDisplayLevel find(String name) {
        if ("NON_SWITCHABLE_ERROR".equals(name)) {
            return NON_SWITCHABLE_ERROR;
        }
        if ("NON_SWITCHABLE_WARNING".equals(name)) {
            return NON_SWITCHABLE_WARNING;
        }
        for (Map.Entry<HighlightSeverity, HighlightDisplayLevel> entry : ourMap.entrySet()) {
            HighlightSeverity severity = entry.getKey();
            HighlightDisplayLevel displayLevel = entry.getValue();
            if (!Comparing.strEqual(severity.getName(), name)) continue;
            return displayLevel;
        }
        return null;
    }

    public static HighlightDisplayLevel find(HighlightSeverity severity) {
        return ourMap.get(severity);
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity, @NotNull Icon icon) {
        if (severity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(1);
        }
        this(severity);
        this.myIcon = icon;
        ourMap.put(this.mySeverity, this);
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(2);
        }
        this.mySeverity = severity;
    }

    public String toString() {
        return this.mySeverity.toString();
    }

    @NotNull
    public String getName() {
        String string = this.mySeverity.getName();
        if (string == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(4);
        }
        return highlightSeverity;
    }

    public boolean isNonSwitchable() {
        return false;
    }

    public static void registerSeverity(@NotNull HighlightSeverity severity, @NotNull TextAttributesKey key, @Nullable Icon icon) {
        if (severity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(5);
        }
        if (key == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(6);
        }
        Icon severityIcon = icon != null ? icon : HighlightDisplayLevel.createIconByKey(key);
        HighlightDisplayLevel level = ourMap.get(severity);
        if (level == null) {
            new HighlightDisplayLevel(severity, severityIcon);
        } else {
            level.myIcon = severityIcon;
        }
    }

    public static int getEmptyIconDim() {
        return JBUIScale.scale(14);
    }

    public static Icon createIconByKey(@NotNull TextAttributesKey key) {
        if (key == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(7);
        }
        return StringUtil.containsIgnoreCase(key.getExternalName(), "error") ? new ColorizedIcon(key, AllIcons.General.InspectionsError) : new ColorizedIcon(key, AllIcons.General.InspectionsWarning);
    }

    @NotNull
    public static Icon createIconByMask(Color renderColor) {
        return new MyColorIcon(HighlightDisplayLevel.getEmptyIconDim(), renderColor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/codeHighlighting/HighlightDisplayLevel";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/codeHighlighting/HighlightDisplayLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerSeverity";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createIconByKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ColorizedIcon
    extends SingleColorIcon {
        private final Icon baseIcon;

        private ColorizedIcon(@NotNull TextAttributesKey key, @NotNull Icon baseIcon) {
            if (key == null) {
                ColorizedIcon.$$$reportNull$$$0(0);
            }
            if (baseIcon == null) {
                ColorizedIcon.$$$reportNull$$$0(1);
            }
            super(key);
            this.baseIcon = baseIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            IconManager.getInstance().colorize((Graphics2D)g, this.baseIcon, this.getColor()).paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.baseIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.baseIcon.getIconHeight();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseIcon";
                    break;
                }
            }
            objectArray[1] = "sqldelight/com/intellij/codeHighlighting/HighlightDisplayLevel$ColorizedIcon";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SingleColorIcon
    implements Icon,
    ColoredIcon {
        private final TextAttributesKey myKey;

        private SingleColorIcon(@NotNull TextAttributesKey key) {
            if (key == null) {
                SingleColorIcon.$$$reportNull$$$0(0);
            }
            this.myKey = key;
        }

        @Override
        @NotNull
        public Color getColor() {
            Color color = ObjectUtils.notNull(this.getColorInner(), JBColor.GRAY);
            if (color == null) {
                SingleColorIcon.$$$reportNull$$$0(1);
            }
            return color;
        }

        @Nullable
        private Color getColorInner() {
            EditorColorsManager manager = EditorColorsManager.getInstance();
            if (manager != null) {
                Color stripe;
                TextAttributes attributes = manager.getGlobalScheme().getAttributes(this.myKey);
                Color color = stripe = attributes == null ? null : attributes.getErrorStripeColor();
                if (stripe != null) {
                    return stripe;
                }
                if (attributes != null) {
                    Color effectColor = attributes.getEffectColor();
                    if (effectColor != null) {
                        return effectColor;
                    }
                    Color foregroundColor = attributes.getForegroundColor();
                    if (foregroundColor != null) {
                        return foregroundColor;
                    }
                    return attributes.getBackgroundColor();
                }
                return null;
            }
            TextAttributes defaultAttributes = this.myKey.getDefaultAttributes();
            if (defaultAttributes == null) {
                defaultAttributes = TextAttributes.ERASE_MARKER;
            }
            return defaultAttributes.getErrorStripeColor();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.getColor());
            int shift = JBUIScale.scale(2);
            int size = JBUIScale.scale(10);
            g.fillRect(x + shift, y + shift, size, size);
        }

        @Override
        public int getIconWidth() {
            return HighlightDisplayLevel.getEmptyIconDim();
        }

        @Override
        public int getIconHeight() {
            return HighlightDisplayLevel.getEmptyIconDim();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/codeHighlighting/HighlightDisplayLevel$SingleColorIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/codeHighlighting/HighlightDisplayLevel$SingleColorIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ColoredIcon {
        public Color getColor();
    }

    private static class MyColorIcon
    extends ColorIcon
    implements ColoredIcon {
        MyColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                MyColorIcon.$$$reportNull$$$0(0);
            }
            super(size, color);
        }

        @Override
        public Color getColor() {
            return this.getIconColor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "sqldelight/com/intellij/codeHighlighting/HighlightDisplayLevel$MyColorIcon", "<init>"));
        }
    }
}

