/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.jps.model.serialization.facet;

import java.util.List;
import sqldelight.com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import sqldelight.com.intellij.util.xmlb.XmlSerializer;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.jps.model.JpsElement;
import sqldelight.org.jetbrains.jps.model.JpsElementFactory;
import sqldelight.org.jetbrains.jps.model.module.JpsModule;
import sqldelight.org.jetbrains.jps.model.module.JpsModuleReference;
import sqldelight.org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import sqldelight.org.jetbrains.jps.model.serialization.facet.FacetManagerState;
import sqldelight.org.jetbrains.jps.model.serialization.facet.FacetState;
import sqldelight.org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;

public final class JpsFacetSerializer {
    @NonNls
    public static final String FACET_TAG = "facet";
    @NonNls
    public static final String TYPE_ATTRIBUTE = "type";
    @NonNls
    public static final String CONFIGURATION_TAG = "configuration";
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";
    @NonNls
    public static final String FACET_MANAGER_COMPONENT_NAME = "FacetManager";

    public static void loadFacets(JpsModule module, @Nullable Element facetManagerElement) {
        if (facetManagerElement == null) {
            return;
        }
        FacetManagerState state = XmlSerializer.deserialize(facetManagerElement, FacetManagerState.class);
        JpsFacetSerializer.addFacets(module, state.facets, null);
    }

    public static void saveFacets(JpsModule module, @NotNull Element facetManagerElement) {
        if (facetManagerElement == null) {
            JpsFacetSerializer.$$$reportNull$$$0(0);
        }
        FacetManagerState managerState = new FacetManagerState();
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsFacetConfigurationSerializer<?> serializer : extension.getFacetConfigurationSerializers()) {
                if (!serializer.hasExtension(module)) continue;
                serializer.saveExtension(module, managerState.facets);
            }
        }
        XmlSerializer.serializeInto(managerState, facetManagerElement, new SkipDefaultValuesSerializationFilters());
    }

    private static void addFacets(JpsModule module, List<FacetState> facets, @Nullable JpsElement parentFacet) {
        for (FacetState facetState : facets) {
            JpsFacetConfigurationSerializer<?> serializer = JpsFacetSerializer.getModuleExtensionSerializer(facetState.getFacetType());
            if (serializer == null) continue;
            Object element = JpsFacetSerializer.addExtension(module, serializer, facetState, parentFacet);
            JpsFacetSerializer.addFacets(module, facetState.subFacets, element);
        }
    }

    private static <E extends JpsElement> E addExtension(JpsModule module, JpsFacetConfigurationSerializer<E> serializer, FacetState facet, JpsElement parentFacet) {
        Element facetConfiguration = facet.getConfiguration();
        return serializer.loadExtension(facetConfiguration != null ? facetConfiguration : new Element(CONFIGURATION_TAG), facet.getName(), module, parentFacet);
    }

    @Nullable
    private static JpsFacetConfigurationSerializer<?> getModuleExtensionSerializer(@NotNull String typeId) {
        if (typeId == null) {
            JpsFacetSerializer.$$$reportNull$$$0(1);
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsFacetConfigurationSerializer<?> serializer : extension.getFacetConfigurationSerializers()) {
                if (!serializer.getFacetTypeId().equals(typeId)) continue;
                return serializer;
            }
        }
        return null;
    }

    public static JpsModuleReference createModuleReference(String facetId) {
        String moduleName = facetId.substring(0, facetId.indexOf(47));
        return JpsElementFactory.getInstance().createModuleReference(moduleName);
    }

    public static String getFacetId(JpsModuleReference moduleReference, String facetTypeId, String facetName) {
        return moduleReference.getModuleName() + "/" + facetTypeId + "/" + facetName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetManagerElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
        }
        objectArray2[1] = "sqldelight/org/jetbrains/jps/model/serialization/facet/JpsFacetSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "saveFacets";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleExtensionSerializer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

