/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.jps.model.serialization.facet;

import java.util.List;
import sqldelight.com.intellij.openapi.util.JDOMUtil;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.jps.model.JpsElement;
import sqldelight.org.jetbrains.jps.model.JpsElementChildRole;
import sqldelight.org.jetbrains.jps.model.module.JpsModule;
import sqldelight.org.jetbrains.jps.model.serialization.facet.FacetState;

public abstract class JpsFacetConfigurationSerializer<E extends JpsElement> {
    private final JpsElementChildRole<E> myRole;
    private final String myFacetTypeId;
    private final String myFacetName;

    public JpsFacetConfigurationSerializer(JpsElementChildRole<E> role, String facetTypeId, @Nullable String facetName) {
        this.myRole = role;
        this.myFacetTypeId = facetTypeId;
        this.myFacetName = facetName;
    }

    public String getFacetTypeId() {
        return this.myFacetTypeId;
    }

    public E loadExtension(Element configurationElement, String facetName, JpsModule module, JpsElement parentFacet) {
        E e = this.loadExtension(configurationElement, facetName, parentFacet, module);
        return module.getContainer().setChild(this.myRole, e);
    }

    protected abstract E loadExtension(@NotNull Element var1, String var2, JpsElement var3, JpsModule var4);

    public boolean hasExtension(JpsModule module) {
        return module.getContainer().getChild(this.myRole) != null;
    }

    public void saveExtension(JpsModule module, @NotNull List<? super FacetState> states) {
        E extension;
        if (states == null) {
            JpsFacetConfigurationSerializer.$$$reportNull$$$0(0);
        }
        if ((extension = module.getContainer().getChild(this.myRole)) != null) {
            FacetState state = new FacetState();
            state.setFacetType(this.myFacetTypeId);
            state.setName(this.myFacetName);
            Element tag = new Element("configuration");
            this.saveExtension(extension, tag, module);
            if (!JDOMUtil.isEmpty(tag)) {
                state.setConfiguration(tag);
            }
            states.add(state);
        }
    }

    protected abstract void saveExtension(E var1, Element var2, JpsModule var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "sqldelight/org/jetbrains/jps/model/serialization/facet/JpsFacetConfigurationSerializer", "saveExtension"));
    }
}

