/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import sqldelight.org.apache.batik.bridge.AnimatableGenericSVGBridge;
import sqldelight.org.apache.batik.bridge.BridgeContext;
import sqldelight.org.apache.batik.bridge.GVTBuilder;
import sqldelight.org.apache.batik.bridge.MaskBridge;
import sqldelight.org.apache.batik.bridge.SVGUtilities;
import sqldelight.org.apache.batik.ext.awt.image.renderable.Filter;
import sqldelight.org.apache.batik.gvt.CompositeGraphicsNode;
import sqldelight.org.apache.batik.gvt.GraphicsNode;
import sqldelight.org.apache.batik.gvt.filter.Mask;
import sqldelight.org.apache.batik.gvt.filter.MaskRable8Bit;
import sqldelight.org.w3c.dom.Element;
import sqldelight.org.w3c.dom.Node;

public class SVGMaskElementBridge
extends AnimatableGenericSVGBridge
implements MaskBridge {
    @Override
    public String getLocalName() {
        return "mask";
    }

    @Override
    public Mask createMask(BridgeContext ctx, Element maskElement, Element maskedElement, GraphicsNode maskedNode) {
        Rectangle2D maskRegion = SVGUtilities.convertMaskRegion(maskElement, maskedElement, maskedNode, ctx);
        GVTBuilder builder = ctx.getGVTBuilder();
        CompositeGraphicsNode maskNode = new CompositeGraphicsNode();
        CompositeGraphicsNode maskNodeContent = new CompositeGraphicsNode();
        maskNode.getChildren().add(maskNodeContent);
        boolean hasChildren = false;
        for (Node node = maskElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element child;
            GraphicsNode gn;
            if (node.getNodeType() != 1 || (gn = builder.build(ctx, child = (Element)node)) == null) continue;
            hasChildren = true;
            maskNodeContent.getChildren().add(gn);
        }
        if (!hasChildren) {
            return null;
        }
        String s = maskElement.getAttributeNS(null, "transform");
        AffineTransform Tx = s.length() != 0 ? SVGUtilities.convertTransform(maskElement, "transform", s, ctx) : new AffineTransform();
        s = maskElement.getAttributeNS(null, "maskContentUnits");
        int coordSystemType = s.length() == 0 ? 1 : (int)SVGUtilities.parseCoordinateSystem(maskElement, "maskContentUnits", s, ctx);
        if (coordSystemType == 2) {
            Tx = SVGUtilities.toObjectBBox(Tx, maskedNode);
        }
        maskNodeContent.setTransform(Tx);
        Filter filter = maskedNode.getFilter();
        if (filter == null) {
            filter = maskedNode.getGraphicsNodeRable(true);
        }
        return new MaskRable8Bit(filter, maskNode, maskRegion);
    }
}

