/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.ui;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TempMethodInvocator<R> {
    private Method myMethod;
    private Constructor<?> myCtor;

    public TempMethodInvocator(String clsFQN, String method, Class<?> ... parameterTypes) {
        try {
            Class<?> cls = Class.forName(clsFQN);
            this.myMethod = cls.getDeclaredMethod(method, parameterTypes);
            if (!this.myMethod.isAccessible()) {
                this.myMethod.setAccessible(true);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    public TempMethodInvocator(String clsFQN, Class<?> ... parameterTypes) {
        try {
            Class<?> cls = Class.forName(clsFQN);
            this.myCtor = cls.getDeclaredConstructor(parameterTypes);
            if (!this.myCtor.isAccessible()) {
                this.myCtor.setAccessible(true);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    public R invoke(Object object, Object ... arguments2) {
        if (this.myMethod == null) {
            throw new IllegalStateException("Method is not available");
        }
        try {
            Object res = this.myMethod.invoke(object, arguments2);
            return (R)(res != null ? res : null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public R staticInvoke(Object ... arguments2) {
        return this.invoke(null, arguments2);
    }

    public R create(Object ... args) {
        if (this.myCtor == null) {
            throw new IllegalStateException("Ctor is not available");
        }
        try {
            return (R)this.myCtor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

