/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.loader;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import sqldelight.com.intellij.openapi.application.PathManager;
import sqldelight.com.intellij.openapi.util.SystemInfoRt;
import sqldelight.com.intellij.openapi.util.io.win32.IdeaWin32;
import sqldelight.org.jetbrains.annotations.NotNull;

public final class NativeLibraryLoader {
    public static void loadPlatformLibrary(@NotNull String libName) {
        String libPath;
        String libFileName;
        Path libFile;
        if (libName == null) {
            NativeLibraryLoader.$$$reportNull$$$0(0);
        }
        if ((libFile = PathManager.findBinFile(libFileName = NativeLibraryLoader.mapLibraryName(libName))) != null) {
            libPath = libFile.toAbsolutePath().toString();
        } else {
            libPath = PathManager.getHomePathFor(IdeaWin32.class) + "/bin/" + libFileName;
            if (!Files.exists(Paths.get(libPath, new String[0]), new LinkOption[0])) {
                File libDir = new File(PathManager.getBinPath());
                throw new UnsatisfiedLinkError("'" + libFileName + "' not found in '" + libDir + "' among " + Arrays.toString(libDir.list()));
            }
        }
        System.load(libPath);
    }

    @NotNull
    private static String mapLibraryName(@NotNull String libName) {
        if (libName == null) {
            NativeLibraryLoader.$$$reportNull$$$0(1);
        }
        String baseName = libName;
        if (SystemInfoRt.is64Bit) {
            baseName = baseName.replace("32", "") + "64";
        }
        String fileName = System.mapLibraryName(baseName);
        if (SystemInfoRt.isMac) {
            fileName = fileName.replace(".jnilib", ".dylib");
        }
        String string = fileName;
        if (string == null) {
            NativeLibraryLoader.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/loader/NativeLibraryLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/loader/NativeLibraryLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "mapLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadPlatformLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mapLibraryName";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

