/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import sqldelight.com.intellij.openapi.diagnostic.LoggerRt;
import sqldelight.com.intellij.openapi.util.io.FileUtilRt;
import sqldelight.com.intellij.util.PathUtilRt;
import sqldelight.com.intellij.util.lang.CachePoolImpl;
import sqldelight.com.intellij.util.lang.ClassLoadingLocks;
import sqldelight.com.intellij.util.lang.ClassPath;
import sqldelight.com.intellij.util.lang.Resource;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class UrlClassLoader
extends ClassLoader {
    static final String CLASS_EXTENSION = ".class";
    private static final Set<Class<?>> ourParallelCapableLoaders;
    private static final boolean ourClassPathIndexEnabled;
    private final List<URL> myURLs;
    private final ClassPath myClassPath;
    private final ClassLoadingLocks myClassLoadingLocks;
    private final boolean myAllowBootstrapResources;
    private static final ThreadLocal<Boolean> ourSkipFindingResource;

    protected static void markParallelCapable(@NotNull Class<? extends UrlClassLoader> loaderClass) {
        if (loaderClass == null) {
            UrlClassLoader.$$$reportNull$$$0(0);
        }
        assert (ourParallelCapableLoaders != null);
        ourParallelCapableLoaders.add(loaderClass);
    }

    private static boolean isUrlNeedsProtectionDomain(@NotNull URL url) {
        String name;
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(1);
        }
        return (name = PathUtilRt.getFileName(url.getPath())).endsWith(".jar") && (name.startsWith("bcprov-") || name.startsWith("bcpkix-"));
    }

    void appendToClassPathForInstrumentation(@NotNull String jar) {
        if (jar == null) {
            UrlClassLoader.$$$reportNull$$$0(2);
        }
        try {
            URL url = new File(jar).toURI().toURL();
            this.getClassPath().addURL(UrlClassLoader.internProtocol(url));
            this.myURLs.add(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @NotNull
    protected ClassPath getClassPath() {
        ClassPath classPath = this.myClassPath;
        if (classPath == null) {
            UrlClassLoader.$$$reportNull$$$0(3);
        }
        return classPath;
    }

    @NotNull
    public List<URL> getBaseUrls() {
        List<URL> list = this.myClassPath.getBaseUrls();
        if (list == null) {
            UrlClassLoader.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Collection<String> getJarAccessLog() {
        Collection<String> collection = this.myClassPath.getJarAccessLog();
        if (collection == null) {
            UrlClassLoader.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public static Builder build() {
        return new Builder();
    }

    @Deprecated
    public UrlClassLoader(@NotNull ClassLoader parent) {
        if (parent == null) {
            UrlClassLoader.$$$reportNull$$$0(6);
        }
        this(UrlClassLoader.build().urlsFromAppClassLoader(parent).parent(parent.getParent()).allowLock().useCache().usePersistentClasspathIndexForLocalClassDirectories().useLazyClassloadingCaches(Boolean.parseBoolean(System.getProperty("idea.lazy.classloading.caches", "false"))).autoAssignUrlsWithProtectionDomain());
        try {
            Field f = ClassLoader.class.getDeclaredField("classLoaderValueMap");
            f.setAccessible(true);
            f.set(this, f.get(parent));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected UrlClassLoader(@NotNull Builder builder) {
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(7);
        }
        super(builder.myParent);
        if (builder.myUrlsInterned) {
            this.myURLs = builder.myURLs;
        } else {
            this.myURLs = new ArrayList<URL>(builder.myURLs.size());
            for (URL url : builder.myURLs) {
                URL internedUrl = UrlClassLoader.internProtocol(url);
                if (internedUrl == null) continue;
                this.myURLs.add(internedUrl);
            }
        }
        this.myClassPath = this.createClassPath(builder);
        this.myAllowBootstrapResources = builder.myAllowBootstrapResources;
        this.myClassLoadingLocks = ourParallelCapableLoaders != null && ourParallelCapableLoaders.contains(this.getClass()) ? new ClassLoadingLocks() : null;
    }

    @NotNull
    protected final ClassPath createClassPath(@NotNull Builder builder) {
        Set<URL> urlsWithProtectionDomain;
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(8);
        }
        if ((urlsWithProtectionDomain = builder.myURLsWithProtectionDomain) == null) {
            urlsWithProtectionDomain = Collections.emptySet();
        }
        return new ClassPath(this.myURLs, builder.myLockJars, builder.myUseCache, builder.myAcceptUnescaped, builder.myPreload, builder.myUsePersistentClasspathIndex, builder.myCachePool, builder.myCachingCondition, builder.myErrorOnMissingJar, builder.myLazyClassloadingCaches, urlsWithProtectionDomain, builder.myLogJarAccess);
    }

    @Nullable
    public static URL internProtocol(@NotNull URL url) {
        String host;
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(9);
        }
        String protocol = url.getProtocol();
        boolean interned = false;
        if ("file".equals(protocol) || "jar".equals(protocol)) {
            protocol = protocol.intern();
            interned = true;
        }
        if ((host = url.getHost()) != null && host.isEmpty()) {
            host = "";
            interned = true;
        }
        try {
            if (interned) {
                url = new URL(protocol, host, url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            LoggerRt.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    @Deprecated
    public void addURL(@NotNull URL url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(10);
        }
        this.getClassPath().addURL(UrlClassLoader.internProtocol(url));
        this.myURLs.add(url);
    }

    @NotNull
    public List<URL> getUrls() {
        List<URL> list = Collections.unmodifiableList(this.myURLs);
        if (list == null) {
            UrlClassLoader.$$$reportNull$$$0(11);
        }
        return list;
    }

    public boolean hasLoadedClass(String name) {
        Class<?> aClass = this.findLoadedClass(name);
        return aClass != null && aClass.getClassLoader() == this;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this._findClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    @Nullable
    protected final Class<?> _findClass(@NotNull String name) {
        Resource res;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(12);
        }
        if ((res = this.getClassPath().getResource(name.replace('.', '/') + CLASS_EXTENSION)) == null) {
            return null;
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            LoggerRt.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    private Class<?> defineClass(@NotNull String name, @NotNull Resource res) throws IOException {
        String pkgName;
        Package pkg;
        int i;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(13);
        }
        if (res == null) {
            UrlClassLoader.$$$reportNull$$$0(14);
        }
        if ((i = name.lastIndexOf(46)) != -1 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, res.getValue(Resource.Attribute.SPEC_TITLE), res.getValue(Resource.Attribute.SPEC_VERSION), res.getValue(Resource.Attribute.SPEC_VENDOR), res.getValue(Resource.Attribute.IMPL_TITLE), res.getValue(Resource.Attribute.IMPL_VERSION), res.getValue(Resource.Attribute.IMPL_VENDOR), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        byte[] b = res.getBytes();
        ProtectionDomain protectionDomain = res.getProtectionDomain();
        if (protectionDomain != null) {
            return this._defineClass(name, b, protectionDomain);
        }
        protectionDomain = this.getProtectionDomain(res.getURL());
        if (protectionDomain != null) {
            return this._defineClass(name, b, protectionDomain);
        }
        return this._defineClass(name, b);
    }

    protected ProtectionDomain getProtectionDomain(URL url) {
        return null;
    }

    protected Class<?> _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    protected Class<?> _defineClass(String name, byte[] b, @Nullable ProtectionDomain protectionDomain) {
        return this.defineClass(name, b, 0, b.length, protectionDomain);
    }

    @Override
    public URL findResource(String name) {
        if (ourSkipFindingResource.get() != null) {
            return null;
        }
        Resource res = this.findResourceImpl(name);
        return res != null ? res.getURL() : null;
    }

    @Nullable
    private Resource findResourceImpl(String name) {
        String n = FileUtilRt.toCanonicalPath(name, '/', false);
        Resource resource = this.getClassPath().getResource(n);
        if (resource == null && n.startsWith("/")) {
            resource = this.getClassPath().getResource(n.substring(1));
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        if (this.myAllowBootstrapResources) {
            ourSkipFindingResource.set(Boolean.TRUE);
            try {
                InputStream stream = super.getResourceAsStream(name);
                if (stream != null) {
                    InputStream inputStream = stream;
                    return inputStream;
                }
            }
            finally {
                ourSkipFindingResource.set(null);
            }
        }
        try {
            Resource res = this.findResourceImpl(name);
            return res != null ? res.getInputStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.getClassPath().getResources(name);
    }

    @Override
    @NotNull
    protected Object getClassLoadingLock(String className) {
        Object object = this.myClassLoadingLocks != null ? this.myClassLoadingLocks.getOrCreateLock(className) : this;
        if (object == null) {
            UrlClassLoader.$$$reportNull$$$0(15);
        }
        return object;
    }

    @NotNull
    public static CachePool createCachePool() {
        return new CachePoolImpl();
    }

    static {
        boolean capable;
        boolean isAtLeastJava7 = !System.getProperty("java.runtime.version", "unknown").startsWith("1.6.");
        boolean ibmJvm = System.getProperty("java.vm.vendor", "unknown").toLowerCase(Locale.ENGLISH).contains("ibm");
        boolean bl = capable = isAtLeastJava7 && !ibmJvm && Boolean.parseBoolean(System.getProperty("use.parallel.class.loading", "true"));
        if (capable) {
            ourParallelCapableLoaders = Collections.synchronizedSet(new HashSet());
            try {
                Method registerAsParallelCapable = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerAsParallelCapable.setAccessible(true);
                if (Boolean.TRUE.equals(registerAsParallelCapable.invoke(null, new Object[0]))) {
                    ourParallelCapableLoaders.add(UrlClassLoader.class);
                }
            }
            catch (Exception exception) {}
        } else {
            ourParallelCapableLoaders = null;
        }
        ourClassPathIndexEnabled = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
        ourSkipFindingResource = new ThreadLocal();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaderClass";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrls";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarAccessLog";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoadingLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "markParallelCapable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUrlNeedsProtectionDomain";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendToClassPathForInstrumentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 15: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createClassPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "internProtocol";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "_findClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "defineClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface CachingCondition {
        public boolean shouldCacheData(@NotNull URL var1);
    }

    public static interface CachePool {
    }

    public static final class Builder {
        private List<URL> myURLs = Collections.emptyList();
        private Set<URL> myURLsWithProtectionDomain;
        private ClassLoader myParent;
        private boolean myLockJars;
        private boolean myUseCache;
        private boolean myUsePersistentClasspathIndex;
        private boolean myAcceptUnescaped;
        private boolean myPreload = true;
        private boolean myAllowBootstrapResources;
        private boolean myErrorOnMissingJar = true;
        private boolean myLazyClassloadingCaches;
        private boolean myLogJarAccess;
        @Nullable
        private CachePoolImpl myCachePool;
        @Nullable
        private CachingCondition myCachingCondition;
        private boolean myUrlsInterned;

        Builder() {
        }

        @NotNull
        public Builder urls(@NotNull List<URL> urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myURLs = urls;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder urls(URL ... urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myURLs = Arrays.asList(urls);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        private Builder urlsFromAppClassLoader(ClassLoader classLoader) {
            if (classLoader instanceof URLClassLoader) {
                return this.urls(((URLClassLoader)classLoader).getURLs());
            }
            String[] parts = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
            this.myURLs = new ArrayList<URL>(parts.length);
            for (String s : parts) {
                try {
                    this.myURLs.add(new File(s).toURI().toURL());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this;
        }

        @NotNull
        Builder urlsWithProtectionDomain(@NotNull Set<URL> urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myURLsWithProtectionDomain = urls;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder parent(ClassLoader parent) {
            this.myParent = parent;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder allowLock() {
            this.myLockJars = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder allowLock(boolean lockJars) {
            this.myLockJars = lockJars;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder useCache() {
            this.myUseCache = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public Builder useCache(boolean useCache) {
            this.myUseCache = useCache;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder usePersistentClasspathIndexForLocalClassDirectories() {
            this.myUsePersistentClasspathIndex = ourClassPathIndexEnabled;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        public Builder logJarAccess(boolean logJarAccess) {
            this.myLogJarAccess = logJarAccess;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder urlsInterned() {
            this.myUrlsInterned = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public Builder useCache(@NotNull CachePool pool, @NotNull CachingCondition condition) {
            if (pool == null) {
                Builder.$$$reportNull$$$0(14);
            }
            if (condition == null) {
                Builder.$$$reportNull$$$0(15);
            }
            this.myUseCache = true;
            this.myCachePool = (CachePoolImpl)pool;
            this.myCachingCondition = condition;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder;
        }

        @NotNull
        public Builder allowUnescaped() {
            this.myAcceptUnescaped = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(17);
            }
            return builder;
        }

        @NotNull
        public Builder noPreload() {
            this.myPreload = false;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(18);
            }
            return builder;
        }

        @NotNull
        public Builder allowBootstrapResources() {
            this.myAllowBootstrapResources = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(19);
            }
            return builder;
        }

        @NotNull
        public Builder setLogErrorOnMissingJar(boolean log) {
            this.myErrorOnMissingJar = log;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(20);
            }
            return builder;
        }

        @NotNull
        public Builder useLazyClassloadingCaches(boolean pleaseBeLazy) {
            this.myLazyClassloadingCaches = pleaseBeLazy;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(21);
            }
            return builder;
        }

        @NotNull
        public Builder autoAssignUrlsWithProtectionDomain() {
            HashSet<URL> result = new HashSet<URL>();
            for (URL url : this.myURLs) {
                if (!UrlClassLoader.isUrlNeedsProtectionDomain(url)) continue;
                result.add(url);
            }
            Builder builder = this.urlsWithProtectionDomain(result);
            if (builder == null) {
                Builder.$$$reportNull$$$0(22);
            }
            return builder;
        }

        @NotNull
        public UrlClassLoader get() {
            return new UrlClassLoader(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pool";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "urls";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "urlsWithProtectionDomain";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parent";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowLock";
                    break;
                }
                case 9: 
                case 10: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useCache";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "usePersistentClasspathIndexForLocalClassDirectories";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "logJarAccess";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "urlsInterned";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowUnescaped";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "noPreload";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowBootstrapResources";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLogErrorOnMissingJar";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useLazyClassloadingCaches";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "autoAssignUrlsWithProtectionDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "urlsWithProtectionDomain";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "useCache";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

