/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import sqldelight.gnu.trove.TObjectIntHashMap;
import sqldelight.gnu.trove.TObjectIntProcedure;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SimpleStringPersistentEnumerator {
    public static final int MAX_NUMBER_OF_INDICES = Short.MAX_VALUE;
    @NotNull
    private final Path myFile;
    @NotNull
    private final TObjectIntHashMap<String> myState;

    public SimpleStringPersistentEnumerator(@NotNull Path file) {
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(0);
        }
        this.myFile = file;
        this.myState = new TObjectIntHashMap();
        this.readStorageFromDisk();
    }

    public synchronized short enumerate(@Nullable String value) {
        if (this.myState.containsKey(value)) {
            return (short)this.myState.get(value);
        }
        int n = this.myState.size() + 1;
        assert (n <= Short.MAX_VALUE) : "Number of indices exceeded: " + n;
        this.myState.put(value, n);
        this.writeStorageToDisk();
        return (short)n;
    }

    @Nullable
    public synchronized String valueOf(final short idx) {
        final String[] result = new String[]{null};
        this.myState.forEachEntry(new TObjectIntProcedure<String>(){

            @Override
            public boolean execute(String data, int dataId) {
                if (dataId == idx) {
                    result[0] = data;
                    return false;
                }
                return true;
            }
        });
        return result[0];
    }

    public synchronized void forceDiskSync() {
        this.writeStorageToDisk();
    }

    private synchronized void readStorageFromDisk() {
        try {
            TObjectIntHashMap<String> nameToIdRegistry = new TObjectIntHashMap<String>();
            List<String> lines = Files.readAllLines(this.myFile, Charset.defaultCharset());
            for (int i = 0; i < lines.size(); ++i) {
                String name2 = lines.get(i);
                nameToIdRegistry.put(name2, i + 1);
            }
            this.myState.ensureCapacity(nameToIdRegistry.size());
            nameToIdRegistry.forEachEntry((name, index) -> {
                this.myState.put((String)name, index);
                return true;
            });
        }
        catch (IOException e) {
            this.myState.clear();
            this.writeStorageToDisk();
        }
    }

    private void writeStorageToDisk() {
        try {
            String[] names = new String[this.myState.size()];
            this.myState.forEachEntry((key, value) -> {
                names[value - 1] = key;
                return true;
            });
            Files.createDirectories(this.myFile.getParent(), new FileAttribute[0]);
            Files.write(this.myFile, Arrays.asList(names), Charset.defaultCharset(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "sqldelight/com/intellij/util/io/SimpleStringPersistentEnumerator", "<init>"));
    }
}

