/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import sqldelight.com.intellij.lang.ASTNode;
import sqldelight.com.intellij.openapi.application.Application;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Condition;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.util.UserDataHolder;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.util.CachedValueProvider;
import sqldelight.com.intellij.psi.util.PsiTreeUtil;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.ref.DebugReflectionUtil;
import sqldelight.org.jetbrains.annotations.NotNull;

final class CachedValueLeakChecker {
    private static final Logger LOG = Logger.getInstance(CachedValueLeakChecker.class);
    private static final boolean DO_CHECKS = ApplicationManager.getApplication().isUnitTestMode();
    private static final Set<String> ourCheckedKeys = ContainerUtil.newConcurrentSet();

    CachedValueLeakChecker() {
    }

    static void checkProvider(@NotNull CachedValueProvider<?> provider, @NotNull Key<?> key, @NotNull UserDataHolder userDataHolder) {
        if (provider == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(0);
        }
        if (key == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(1);
        }
        if (userDataHolder == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(2);
        }
        if (!DO_CHECKS || ApplicationInfoImpl.isInStressTest()) {
            return;
        }
        if (!ourCheckedKeys.add(key.toString())) {
            return;
        }
        CachedValueLeakChecker.findReferencedPsi(provider, key, userDataHolder);
    }

    private static synchronized void findReferencedPsi(@NotNull Object root, @NotNull Key<?> key, @NotNull UserDataHolder toIgnore) {
        if (root == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(3);
        }
        if (key == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(4);
        }
        if (toIgnore == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(5);
        }
        Condition<Object> shouldExamineValue = value -> {
            if (value == toIgnore) {
                return false;
            }
            if (value instanceof ASTNode && (value = ((ASTNode)value).getPsi()) == toIgnore) {
                return false;
            }
            if (value instanceof Project || value instanceof Module || value instanceof Application) {
                return false;
            }
            return !(value instanceof PsiElement) || !(toIgnore instanceof PsiElement) || ((PsiElement)toIgnore).getContainingFile() == null || !PsiTreeUtil.isAncestor((PsiElement)value, (PsiElement)toIgnore, true);
        };
        Map<Object, String> roots = Collections.singletonMap(root, "CachedValueProvider " + key);
        DebugReflectionUtil.walkObjects(5, roots, PsiElement.class, shouldExamineValue, (value, backLink) -> {
            if (value instanceof PsiElement) {
                LOG.error("Incorrect CachedValue use. Provider references PSI, causing memory leaks and possible invalid element access, provider=" + root + "\n" + backLink);
                return false;
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDataHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/util/CachedValueLeakChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferencedPsi";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

