/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.impl.source.resolve.reference.impl.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import sqldelight.com.intellij.analysis.AnalysisBundle;
import sqldelight.com.intellij.lang.injection.InjectedLanguageManager;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.module.ModuleUtilCore;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Condition;
import sqldelight.com.intellij.openapi.util.Conditions;
import sqldelight.com.intellij.openapi.util.TextRange;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.ElementManipulators;
import sqldelight.com.intellij.psi.FileContextProvider;
import sqldelight.com.intellij.psi.LiteralTextEscaper;
import sqldelight.com.intellij.psi.PsiDirectory;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiFileSystemItem;
import sqldelight.com.intellij.psi.PsiLanguageInjectionHost;
import sqldelight.com.intellij.psi.PsiManager;
import sqldelight.com.intellij.psi.PsiReferenceProvider;
import sqldelight.com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import sqldelight.com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import sqldelight.com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import sqldelight.com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import sqldelight.com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import sqldelight.com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import sqldelight.com.intellij.util.Function;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class FileReferenceSet {
    private static final Logger LOG = Logger.getInstance(FileReferenceSet.class);
    private static final FileType[] EMPTY_FILE_TYPES = new FileType[0];
    public static final CustomizableReferenceProvider.CustomizationKey<Function<PsiFile, Collection<PsiFileSystemItem>>> DEFAULT_PATH_EVALUATOR_OPTION = new CustomizableReferenceProvider.CustomizationKey(AnalysisBundle.message("default.path.evaluator.option", new Object[0]));
    public static final Function<PsiFile, Collection<PsiFileSystemItem>> ABSOLUTE_TOP_LEVEL = new AbsoluteTopLevelEvaluator();
    public static final Condition<PsiFileSystemItem> FILE_FILTER = item -> item instanceof PsiFile;
    public static final Condition<PsiFileSystemItem> DIRECTORY_FILTER = item -> item instanceof PsiDirectory;
    protected FileReference[] myReferences;
    private PsiElement myElement;
    private final int myStartInElement;
    private final boolean myCaseSensitive;
    private final String myPathStringNonTrimmed;
    private final String myPathString;
    private volatile Collection<PsiFileSystemItem> myDefaultContexts;
    private final boolean myEndingSlashNotAllowed;
    private boolean myEmptyPathAllowed;
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;
    private FileType @Nullable [] mySuitableFileTypes;

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, FileType @Nullable [] suitableFileTypes) {
        if (str == null) {
            FileReferenceSet.$$$reportNull$$$0(0);
        }
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(1);
        }
        this(str, element, startInElement, provider, caseSensitive, endingSlashNotAllowed, suitableFileTypes, true);
    }

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, FileType @Nullable [] suitableFileTypes, boolean init) {
        if (str == null) {
            FileReferenceSet.$$$reportNull$$$0(2);
        }
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(3);
        }
        this.myElement = element;
        this.myStartInElement = startInElement;
        this.myCaseSensitive = caseSensitive;
        this.myPathStringNonTrimmed = str;
        this.myPathString = str.trim();
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
        this.myEmptyPathAllowed = !endingSlashNotAllowed;
        this.myOptions = provider instanceof CustomizableReferenceProvider ? ((CustomizableReferenceProvider)((Object)provider)).getOptions() : null;
        this.mySuitableFileTypes = suitableFileTypes;
        if (init) {
            this.reparse();
        }
    }

    protected String getNewAbsolutePath(PsiFileSystemItem root, String relativePath) {
        return this.absoluteUrlNeedsStartSlash() ? "/" + relativePath : relativePath;
    }

    public String getSeparatorString() {
        return "/";
    }

    protected int findSeparatorLength(@NotNull CharSequence sequence, int atOffset) {
        if (sequence == null) {
            FileReferenceSet.$$$reportNull$$$0(4);
        }
        return StringUtil.startsWith(sequence, atOffset, this.getSeparatorString()) ? this.getSeparatorString().length() : 0;
    }

    protected int findSeparatorOffset(@NotNull CharSequence sequence, int startingFrom) {
        if (sequence == null) {
            FileReferenceSet.$$$reportNull$$$0(5);
        }
        return StringUtil.indexOf(sequence, this.getSeparatorString(), startingFrom);
    }

    @Deprecated
    protected Collection<PsiFileSystemItem> getExtraContexts() {
        return Collections.emptyList();
    }

    public static FileReferenceSet createSet(@NotNull PsiElement element, final boolean soft, boolean endingSlashNotAllowed, final boolean urlEncoded) {
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(6);
        }
        TextRange range = ElementManipulators.getValueTextRange(element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            text = helper.trimUrl(text);
        }
        return new FileReferenceSet(text, element, offset, null, true, endingSlashNotAllowed){

            @Override
            protected boolean isUrlEncoded() {
                return urlEncoded;
            }

            @Override
            protected boolean isSoft() {
                return soft;
            }
        };
    }

    public FileReferenceSet(String str, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider, boolean isCaseSensitive) {
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(7);
        }
        this(str, element, startInElement, provider, isCaseSensitive, true);
    }

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
        if (str == null) {
            FileReferenceSet.$$$reportNull$$$0(8);
        }
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(9);
        }
        this(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, null);
    }

    public FileReferenceSet(@NotNull PsiElement element) {
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(10);
        }
        this.myElement = element;
        TextRange range = ElementManipulators.getValueTextRange(element);
        this.myStartInElement = range.getStartOffset();
        this.myPathStringNonTrimmed = range.substring(element.getText());
        this.myPathString = this.myPathStringNonTrimmed.trim();
        this.myEndingSlashNotAllowed = true;
        this.myCaseSensitive = false;
        this.reparse();
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            FileReferenceSet.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    void setElement(@NotNull PsiElement element) {
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(12);
        }
        this.myElement = element;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isEndingSlashNotAllowed() {
        return this.myEndingSlashNotAllowed;
    }

    public int getStartInElement() {
        return this.myStartInElement;
    }

    @Nullable
    public FileReference createFileReference(TextRange range, int index, String text) {
        return new FileReference(this, range, index, text);
    }

    protected void reparse() {
        List<FileReference> referencesList = this.reparse(this.myPathStringNonTrimmed, this.myStartInElement);
        this.myReferences = referencesList.toArray(FileReference.EMPTY);
    }

    protected List<FileReference> reparse(String str, int startInElement) {
        TextRange r;
        FileReference reference;
        int sepLen;
        int i;
        CharSequence decoded;
        TextRange valueRange;
        LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper;
        int wsHead = 0;
        int wsTail = 0;
        if (this.myElement instanceof PsiLanguageInjectionHost && !StringUtil.startsWith(this.myElement.getText(), startInElement, str)) {
            escaper = ((PsiLanguageInjectionHost)this.myElement).createLiteralTextEscaper();
            valueRange = ElementManipulators.getValueTextRange(this.myElement);
            StringBuilder sb = new StringBuilder();
            escaper.decode(valueRange, sb);
            decoded = sb;
            wsHead += Math.max(0, startInElement - valueRange.getStartOffset());
        } else {
            escaper = null;
            decoded = str;
            valueRange = TextRange.from(startInElement, decoded.length());
        }
        ArrayList<FileReference> referencesList = new ArrayList<FileReference>();
        for (i = wsHead; i < decoded.length() && Character.isWhitespace(decoded.charAt(i)); ++i) {
            ++wsHead;
        }
        for (i = decoded.length() - 1; i >= 0 && Character.isWhitespace(decoded.charAt(i)); --i) {
            ++wsTail;
        }
        int index = 0;
        int curSep = this.findSeparatorOffset(decoded, wsHead);
        int n = sepLen = curSep >= wsHead ? this.findSeparatorLength(decoded, curSep) : 0;
        if (curSep >= 0 && decoded.length() == wsHead + sepLen + wsTail && (reference = this.createFileReference(r = TextRange.create(startInElement, FileReferenceSet.offset(curSep + Math.max(0, sepLen - 1), escaper, valueRange) + 1), index++, decoded.subSequence(curSep, curSep + sepLen).toString())) != null) {
            referencesList.add(reference);
        }
        curSep = curSep == wsHead ? curSep + sepLen : wsHead;
        sepLen = 0;
        while (curSep >= 0) {
            FileReference reference2;
            int refEnd;
            int nextSep = this.findSeparatorOffset(decoded, curSep + sepLen);
            int start = curSep + sepLen;
            int endTrimmed = nextSep > 0 ? nextSep : Math.max(start, decoded.length() - wsTail);
            String refText = index == 0 && nextSep < 0 && !StringUtil.contains(decoded, str) ? str : decoded.subSequence(start, endTrimmed).toString();
            int refStart = FileReferenceSet.offset(start, escaper, valueRange);
            if (refStart > (refEnd = FileReferenceSet.offset(endTrimmed, escaper, valueRange)) || refStart < 0) {
                LOG.error("Invalid range: (" + refText + ", " + refEnd + "), escaper=" + escaper + "\ntext=" + refText + ", start=" + startInElement);
            }
            if ((reference2 = this.createFileReference(new TextRange(refStart, refEnd), index++, refText)) != null) {
                referencesList.add(reference2);
            }
            sepLen = (curSep = nextSep) > 0 ? this.findSeparatorLength(decoded, curSep) : 0;
        }
        return referencesList;
    }

    private static int offset(int offset, LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper, TextRange valueRange) {
        return escaper == null ? offset + valueRange.getStartOffset() : escaper.getOffsetInHost(offset, valueRange);
    }

    public FileReference getReference(int index) {
        return this.myReferences[index];
    }

    public FileReference @NotNull [] getAllReferences() {
        if (this.myReferences == null) {
            FileReferenceSet.$$$reportNull$$$0(13);
        }
        return this.myReferences;
    }

    protected boolean isSoft() {
        return false;
    }

    protected boolean isUrlEncoded() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getDefaultContexts() {
        Collection<PsiFileSystemItem> result = this.myDefaultContexts;
        if (result == null) {
            this.myDefaultContexts = result = this.computeDefaultContexts();
        }
        Collection<PsiFileSystemItem> collection = result;
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(15);
            }
            return list;
        }
        Collection<PsiFileSystemItem> contexts = this.getCustomizationContexts(file);
        if (contexts != null) {
            Collection<PsiFileSystemItem> collection = contexts;
            if (collection == null) {
                FileReferenceSet.$$$reportNull$$$0(16);
            }
            return collection;
        }
        if (this.isAbsolutePathReference()) {
            return FileReferenceSet.getAbsoluteTopLevelDirLocations(file);
        }
        return this.getContextByFile(file);
    }

    @Nullable
    protected PsiFile getContainingFile() {
        PsiFile cf = this.myElement.getContainingFile();
        PsiFile file = InjectedLanguageManager.getInstance(cf.getProject()).getTopLevelFile(cf);
        if (file != null) {
            return file.getOriginalFile();
        }
        LOG.error("Invalid element: " + this.myElement);
        return null;
    }

    @NotNull
    private Collection<PsiFileSystemItem> getContextByFile(@NotNull PsiFile file) {
        Collection<PsiFileSystemItem> folders;
        PsiElement context;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(17);
        }
        if ((context = file.getContext()) != null) {
            file = context.getContainingFile();
        }
        if ((folders = this.getIncludingFileContexts(file)) != null) {
            Collection<PsiFileSystemItem> collection = folders;
            if (collection == null) {
                FileReferenceSet.$$$reportNull$$$0(18);
            }
            return collection;
        }
        Collection<PsiFileSystemItem> collection = this.getContextByFileSystemItem(file.getOriginalFile());
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getContextByFileSystemItem(@NotNull PsiFileSystemItem file) {
        VirtualFile virtualFile;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(20);
        }
        if ((virtualFile = file.getVirtualFile()) != null) {
            FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
            ArrayList<PsiFileSystemItem> list = new ArrayList<PsiFileSystemItem>();
            Project project = file.getProject();
            boolean hasRealContexts = false;
            for (FileReferenceHelper helper : helpers) {
                if (!helper.isMine(project, virtualFile) || !list.isEmpty() && helper.isFallback()) continue;
                Collection<PsiFileSystemItem> contexts = helper.getContexts(project, virtualFile);
                for (PsiFileSystemItem context : contexts) {
                    list.add(context);
                    hasRealContexts |= !(context instanceof FileReferenceResolver);
                }
            }
            if (!list.isEmpty()) {
                if (!hasRealContexts) {
                    list.addAll(this.getParentDirectoryContext());
                }
                ArrayList<PsiFileSystemItem> arrayList = list;
                if (arrayList == null) {
                    FileReferenceSet.$$$reportNull$$$0(21);
                }
                return arrayList;
            }
            Collection<PsiFileSystemItem> collection = this.getParentDirectoryContext();
            if (collection == null) {
                FileReferenceSet.$$$reportNull$$$0(22);
            }
            return collection;
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            FileReferenceSet.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Nullable
    private Collection<PsiFileSystemItem> getIncludingFileContexts(@NotNull PsiFile file) {
        FileContextProvider contextProvider;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(24);
        }
        if (this.useIncludingFileAsContext() && (contextProvider = FileContextProvider.getProvider(file)) != null) {
            Collection<PsiFileSystemItem> folders = contextProvider.getContextFolders(file);
            if (!folders.isEmpty()) {
                return folders;
            }
            PsiFile contextFile = contextProvider.getContextFile(file);
            if (contextFile != null && contextFile.getParent() != null) {
                return Collections.singletonList(contextFile.getParent());
            }
        }
        return null;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getParentDirectoryContext() {
        PsiFile file = this.getContainingFile();
        VirtualFile virtualFile = file == null ? null : file.getOriginalFile().getVirtualFile();
        VirtualFile parent = virtualFile == null ? null : virtualFile.getParent();
        PsiDirectory directory = parent == null ? null : file.getManager().findDirectory(parent);
        Collection<Object> collection = directory != null ? Collections.singleton(directory) : Collections.emptyList();
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(25);
        }
        return collection;
    }

    public Collection<FileTargetContext> getTargetContexts() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            return Collections.emptyList();
        }
        Collection<FileTargetContext> customizationContexts = this.getTargetCustomizationContexts(file);
        Collection<FileTargetContext> targetContexts = customizationContexts != null ? customizationContexts : this.getTargetContextByFile(file);
        return FileReferenceSet.filterLocalFsContexts(targetContexts);
    }

    private static Collection<FileTargetContext> filterLocalFsContexts(Collection<FileTargetContext> contexts) {
        return ContainerUtil.filter(contexts, c -> {
            VirtualFile file = c.getFileSystemItem().getVirtualFile();
            return file != null && c.getFileSystemItem().isDirectory() && file.isInLocalFileSystem();
        });
    }

    @Nullable
    private Collection<PsiFileSystemItem> getCustomizationContexts(PsiFile file) {
        Collection<PsiFileSystemItem> roots;
        Function<PsiFile, Collection<PsiFileSystemItem>> value;
        if (this.myOptions != null && (value = DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.myOptions)) != null && (roots = value.fun(file)) != null) {
            for (PsiFileSystemItem root : roots) {
                if (root != null) continue;
                LOG.error("Default path evaluator " + value + " produced a null root for " + file);
            }
            return roots;
        }
        return null;
    }

    @Nullable
    private Collection<FileTargetContext> getTargetCustomizationContexts(@NotNull PsiFile file) {
        Function<PsiFile, Collection<PsiFileSystemItem>> value;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(26);
        }
        if (this.myOptions != null && (value = DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.myOptions)) != null) {
            Collection<PsiFileSystemItem> items;
            Collection<FileTargetContext> roots = value instanceof TargetContextEvaluator ? ((TargetContextEvaluator)((Object)value)).getTargetContexts(file) : ((items = value.fun(file)) != null ? FileTargetContext.toTargetContexts(items) : Collections.emptyList());
            return roots;
        }
        return null;
    }

    @NotNull
    private Collection<FileTargetContext> getTargetContextByFile(@NotNull PsiFile file) {
        PsiDirectory parent;
        boolean absolutePathReference;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(27);
        }
        if (!(absolutePathReference = this.isAbsolutePathReference())) {
            Collection<PsiFileSystemItem> folders;
            PsiElement context = file.getContext();
            if (context != null) {
                file = context.getContainingFile();
            }
            if ((folders = this.getIncludingFileContexts(file)) != null) {
                Collection<FileTargetContext> collection = FileTargetContext.toTargetContexts(folders);
                if (collection == null) {
                    FileReferenceSet.$$$reportNull$$$0(28);
                }
                return collection;
            }
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((parent = file.getParent()) == null ? file : parent);
        if (absolutePathReference && module == null) {
            List<FileTargetContext> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(29);
            }
            return list;
        }
        PsiFile originalFile = file.getOriginalFile();
        VirtualFile virtualFile = originalFile.getVirtualFile();
        if (virtualFile == null) {
            List<FileTargetContext> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(30);
            }
            return list;
        }
        LinkedHashSet<FileTargetContext> list = new LinkedHashSet<FileTargetContext>();
        Project project = originalFile.getProject();
        boolean hasRealContexts = false;
        FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
        for (FileReferenceHelper helper : helpers) {
            if (!helper.isMine(project, virtualFile) || !list.isEmpty() && helper.isFallback()) continue;
            Collection<FileTargetContext> contexts = helper.getTargetContexts(project, virtualFile, absolutePathReference);
            for (FileTargetContext context : contexts) {
                list.add(context);
                hasRealContexts |= !(context.getFileSystemItem() instanceof FileReferenceResolver);
            }
        }
        if (!list.isEmpty()) {
            if (!hasRealContexts) {
                for (PsiFileSystemItem item : this.getParentDirectoryContext()) {
                    list.add(new FileTargetContext(item));
                }
            }
            LinkedHashSet<FileTargetContext> linkedHashSet = list;
            if (linkedHashSet == null) {
                FileReferenceSet.$$$reportNull$$$0(31);
            }
            return linkedHashSet;
        }
        Collection<FileTargetContext> collection = FileTargetContext.toTargetContexts(this.getParentDirectoryContext());
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(32);
        }
        return collection;
    }

    public String getPathString() {
        return this.myPathString;
    }

    public boolean isAbsolutePathReference() {
        return this.myPathString.startsWith(this.getSeparatorString());
    }

    protected boolean useIncludingFileAsContext() {
        return true;
    }

    @Nullable
    public PsiFileSystemItem resolve() {
        FileReference lastReference = this.getLastReference();
        return lastReference == null ? null : lastReference.resolve();
    }

    @Nullable
    public FileReference getLastReference() {
        return this.myReferences == null || this.myReferences.length == 0 ? null : this.myReferences[this.myReferences.length - 1];
    }

    @NotNull
    public static Collection<PsiFileSystemItem> getAbsoluteTopLevelDirLocations(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(33);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(34);
            }
            return list;
        }
        PsiDirectory parent = file.getParent();
        Module module = ModuleUtilCore.findModuleForPsiElement(parent == null ? file : parent);
        if (module == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(35);
            }
            return list;
        }
        LinkedHashSet<PsiFileSystemItem> result = new LinkedHashSet<PsiFileSystemItem>();
        Project project = file.getProject();
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            if (!helper.isMine(project, virtualFile) || helper.isFallback() && !result.isEmpty()) continue;
            Collection<PsiFileSystemItem> roots = helper.getRoots(module, virtualFile);
            for (PsiFileSystemItem root : roots) {
                if (root != null) continue;
                LOG.error("Helper " + helper + " produced a null root for " + file);
            }
            result.addAll(roots);
        }
        return new ArrayList<PsiFileSystemItem>(result);
    }

    @NotNull
    private static Collection<FileTargetContext> getTargetAbsoluteTopLevelContexts(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(36);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            List<FileTargetContext> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(37);
            }
            return list;
        }
        PsiDirectory parent = file.getParent();
        Module module = ModuleUtilCore.findModuleForPsiElement(parent == null ? file : parent);
        if (module == null) {
            List<FileTargetContext> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(38);
            }
            return list;
        }
        LinkedHashSet<FileTargetContext> result = new LinkedHashSet<FileTargetContext>();
        Project project = file.getProject();
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            if (!helper.isMine(project, virtualFile) || helper.isFallback() && !result.isEmpty()) continue;
            Collection<FileTargetContext> roots = helper.getTargetContexts(project, virtualFile, true);
            result.addAll(roots);
        }
        return new ArrayList<FileTargetContext>(result);
    }

    @NotNull
    protected Collection<PsiFileSystemItem> toFileSystemItems(VirtualFile ... files) {
        Collection<PsiFileSystemItem> collection = this.toFileSystemItems(Arrays.asList(files));
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(39);
        }
        return collection;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> toFileSystemItems(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            FileReferenceSet.$$$reportNull$$$0(40);
        }
        PsiManager manager = this.getElement().getManager();
        List<PsiFileSystemItem> list = ContainerUtil.mapNotNull(files, file -> file != null && file.isValid() ? manager.findDirectory((VirtualFile)file) : null);
        if (list == null) {
            FileReferenceSet.$$$reportNull$$$0(41);
        }
        return list;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return Conditions.alwaysTrue();
    }

    public <Option> void addCustomization(CustomizableReferenceProvider.CustomizationKey<Option> key, Option value) {
        if (this.myOptions == null) {
            this.myOptions = new HashMap<CustomizableReferenceProvider.CustomizationKey, Object>(5);
        }
        this.myOptions.put(key, value);
    }

    public boolean couldBeConvertedTo(boolean relative) {
        return true;
    }

    public boolean absoluteUrlNeedsStartSlash() {
        return true;
    }

    public FileType @NotNull [] getSuitableFileTypes() {
        FileType[] fileTypeArray = this.mySuitableFileTypes == null ? EMPTY_FILE_TYPES : this.mySuitableFileTypes;
        if (fileTypeArray == null) {
            FileReferenceSet.$$$reportNull$$$0(42);
        }
        return fileTypeArray;
    }

    public boolean isEmptyPathAllowed() {
        return this.myEmptyPathAllowed;
    }

    public void setEmptyPathAllowed(boolean emptyPathAllowed) {
        this.myEmptyPathAllowed = emptyPathAllowed;
    }

    public boolean supportsExtendedCompletion() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet";
                break;
            }
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 27: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllReferences";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultContexts";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextByFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextByFileSystemItem";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDirectoryContext";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetContextByFile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteTopLevelDirLocations";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetAbsoluteTopLevelContexts";
                break;
            }
            case 39: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "toFileSystemItems";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSeparatorLength";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSeparatorOffset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSet";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContextByFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContextByFileSystemItem";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIncludingFileContexts";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTargetCustomizationContexts";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTargetContextByFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getAbsoluteTopLevelDirLocations";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTargetAbsoluteTopLevelContexts";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "toFileSystemItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AbsoluteTopLevelEvaluator
    implements Function<PsiFile, Collection<PsiFileSystemItem>>,
    TargetContextEvaluator {
        private AbsoluteTopLevelEvaluator() {
        }

        @Override
        @NotNull
        public Collection<FileTargetContext> getTargetContexts(@NotNull PsiFile file) {
            if (file == null) {
                AbsoluteTopLevelEvaluator.$$$reportNull$$$0(0);
            }
            Collection collection = FileReferenceSet.getTargetAbsoluteTopLevelContexts(file);
            if (collection == null) {
                AbsoluteTopLevelEvaluator.$$$reportNull$$$0(1);
            }
            return collection;
        }

        @Override
        public Collection<PsiFileSystemItem> fun(PsiFile file) {
            return FileReferenceSet.getAbsoluteTopLevelDirLocations(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet$AbsoluteTopLevelEvaluator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet$AbsoluteTopLevelEvaluator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetContexts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTargetContexts";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface TargetContextEvaluator {
        @NotNull
        public Collection<FileTargetContext> getTargetContexts(@NotNull PsiFile var1);
    }
}

