/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.impl;

import java.util.function.Function;
import javax.swing.Icon;
import sqldelight.com.intellij.icons.AllIcons;
import sqldelight.com.intellij.navigation.ItemPresentation;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.fileTypes.INativeFileType;
import sqldelight.com.intellij.openapi.fileTypes.UnknownFileType;
import sqldelight.com.intellij.openapi.progress.ProcessCanceledException;
import sqldelight.com.intellij.openapi.project.IndexNotReadyException;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Iconable;
import sqldelight.com.intellij.openapi.util.NotNullLazyValue;
import sqldelight.com.intellij.openapi.util.UserDataHolderBase;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.SmartPointerManager;
import sqldelight.com.intellij.psi.SmartPsiElementPointer;
import sqldelight.com.intellij.ui.IconManager;
import sqldelight.com.intellij.ui.LayeredIcon;
import sqldelight.com.intellij.ui.icons.RowIcon;
import sqldelight.com.intellij.util.AstLoadingFilter;
import sqldelight.com.intellij.util.BitUtil;
import sqldelight.com.intellij.util.IconUtil;
import sqldelight.com.intellij.util.PlatformIcons;
import sqldelight.com.intellij.util.PsiIconUtil;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance(ElementBase.class);
    public static final int FLAGS_LOCKED = 2048;
    private static final Function<ElementIconRequest, Icon> ICON_COMPUTE = request -> {
        Object element = ((ElementIconRequest)request).myPointer.getElement();
        if (element == null) {
            return null;
        }
        Icon icon = ElementBase.computeIconNow(element, ((ElementIconRequest)request).myFlags);
        Iconable.LastComputedIcon.put(element, icon, ((ElementIconRequest)request).myFlags);
        return icon;
    };
    private static final NotNullLazyValue<Icon> VISIBILITY_ICON_PLACEHOLDER = new NotNullLazyValue<Icon>(){

        @Override
        @NotNull
        protected Icon compute() {
            Icon icon = IconManager.getInstance().createEmptyIcon(PlatformIcons.PUBLIC_ICON);
            if (icon == null) {
                1.$$$reportNull$$$0(0);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/psi/impl/ElementBase$1", "compute"));
        }
    };
    public static final NotNullLazyValue<Icon> ICON_PLACEHOLDER = new NotNullLazyValue<Icon>(){

        @Override
        @NotNull
        protected Icon compute() {
            Icon icon = AllIcons.Nodes.NodePlaceholder;
            if (icon == null) {
                2.$$$reportNull$$$0(0);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/psi/impl/ElementBase$2", "compute"));
        }
    };

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            return this.computeIcon(flags);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    private Icon computeIcon(@Iconable.IconFlags int flags) {
        PsiElement psiElement = (PsiElement)((Object)this);
        if (!psiElement.isValid()) {
            return null;
        }
        if (Registry.is("psi.deferIconLoading")) {
            Icon baseIcon = Iconable.LastComputedIcon.get(psiElement, flags);
            if (baseIcon == null) {
                baseIcon = AstLoadingFilter.disallowTreeLoading(() -> this.computeBaseIcon(flags));
            }
            return IconManager.getInstance().createDeferredIcon(baseIcon, new ElementIconRequest(psiElement, psiElement.getProject(), flags), ICON_COMPUTE);
        }
        return ElementBase.computeIconNow(psiElement, flags);
    }

    @Nullable
    private static Icon computeIconNow(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            ElementBase.$$$reportNull$$$0(0);
        }
        return AstLoadingFilter.disallowTreeLoading(() -> ElementBase.doComputeIconNow(element, flags));
    }

    private static Icon doComputeIconNow(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        Icon providersIcon;
        if (element == null) {
            ElementBase.$$$reportNull$$$0(1);
        }
        if ((providersIcon = PsiIconUtil.getProvidersIcon(element, flags)) != null) {
            if (providersIcon instanceof RowIcon) {
                return providersIcon;
            }
            return IconManager.getInstance().createLayeredIcon(element, providersIcon, flags);
        }
        return ((ElementBase)((Object)element)).getElementIcon(flags);
    }

    protected Icon computeBaseIcon(@Iconable.IconFlags int flags) {
        PsiFile file;
        Icon baseIcon;
        Icon icon = baseIcon = this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
        if (this instanceof PsiElement && (file = ((PsiElement)((Object)this)).getContainingFile()) != null) {
            return IconManager.getInstance().createLayeredIcon(file, baseIcon, flags);
        }
        return baseIcon;
    }

    protected Icon getBaseIcon() {
        PsiFile file;
        if (this instanceof PsiElement && (file = ((PsiElement)((Object)this)).getContainingFile()) != null && !ElementBase.isNativeFileType(file.getFileType())) {
            return file.getFileType().getIcon();
        }
        return ICON_PLACEHOLDER.getValue();
    }

    public static boolean isNativeFileType(FileType fileType) {
        return fileType instanceof INativeFileType && ((INativeFileType)fileType).useNativeIcon() || fileType instanceof UnknownFileType;
    }

    protected Icon getAdjustedBaseIcon(Icon icon, @Iconable.IconFlags int flags) {
        if (BitUtil.isSet(flags, 1)) {
            return IconManager.getInstance().createRowIcon(icon, VISIBILITY_ICON_PLACEHOLDER.getValue());
        }
        return icon;
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    @NotNull
    public static Icon overlayIcons(Icon ... icons) {
        if (icons == null) {
            ElementBase.$$$reportNull$$$0(2);
        }
        LayeredIcon icon = new LayeredIcon(icons.length);
        int i = 0;
        for (Icon ic : icons) {
            icon.setIcon(ic, i++);
        }
        LayeredIcon layeredIcon = icon;
        if (layeredIcon == null) {
            ElementBase.$$$reportNull$$$0(3);
        }
        return layeredIcon;
    }

    @NotNull
    public static RowIcon buildRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon rowIcon = IconManager.getInstance().createRowIcon(baseIcon, visibilityIcon);
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(4);
        }
        return rowIcon;
    }

    public static Icon iconWithVisibilityIfNeeded(@Iconable.IconFlags int flags, Icon baseIcon, Icon visibility) {
        return BitUtil.isSet(flags, 1) ? ElementBase.buildRowIcon(baseIcon, visibility) : baseIcon;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon baseIcon;
        int elementFlags;
        PsiElement element = (PsiElement)((Object)this);
        if (!element.isValid()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet(flags, 2) && !element.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (element instanceof ItemPresentation && (baseIcon = ((ItemPresentation)((Object)element)).getIcon(false)) != null) {
            return IconManager.getInstance().createLayeredIcon(this, baseIcon, elementFlags);
        }
        if (element instanceof PsiFile) {
            PsiFile psiFile = (PsiFile)element;
            VirtualFile vFile = psiFile.getVirtualFile();
            Icon baseIcon2 = vFile != null ? IconUtil.getIcon(vFile, flags & 0xFFFFFFFD, psiFile.getProject()) : psiFile.getFileType().getIcon();
            return IconManager.getInstance().createLayeredIcon(this, baseIcon2, elementFlags);
        }
        return null;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval
    public static sqldelight.com.intellij.ui.RowIcon createLayeredIcon(@NotNull Iconable instance, Icon icon, int flags) {
        if (instance == null) {
            ElementBase.$$$reportNull$$$0(5);
        }
        sqldelight.com.intellij.ui.RowIcon rowIcon = (sqldelight.com.intellij.ui.RowIcon)IconManager.getInstance().createLayeredIcon(instance, icon, flags);
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(6);
        }
        return rowIcon;
    }

    public static int transformFlags(PsiElement element, @Iconable.IconFlags int _flags) {
        boolean isLocked;
        int flags = BitUtil.clear(_flags, 2);
        boolean bl = isLocked = BitUtil.isSet(_flags, 2) && !element.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    @Deprecated
    public static void registerIconLayer(int flagMask, @NotNull Icon icon) {
        if (icon == null) {
            ElementBase.$$$reportNull$$$0(7);
        }
        IconManager.getInstance().registerIconLayer(flagMask, icon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight.icons";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/impl/ElementBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/impl/ElementBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "overlayIcons";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRowIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLayeredIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeIconNow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIconNow";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "overlayIcons";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLayeredIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerIconLayer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ElementIconRequest {
        private final SmartPsiElementPointer<?> myPointer;
        @Iconable.IconFlags
        private final int myFlags;

        private ElementIconRequest(@NotNull PsiElement element, @NotNull Project project, @Iconable.IconFlags int flags) {
            if (element == null) {
                ElementIconRequest.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ElementIconRequest.$$$reportNull$$$0(1);
            }
            this.myPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(element);
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementIconRequest)) {
                return false;
            }
            ElementIconRequest request = (ElementIconRequest)o;
            if (this.myFlags != request.myFlags) {
                return false;
            }
            return this.myPointer.equals(request.myPointer);
        }

        public int hashCode() {
            int result = this.myPointer.hashCode();
            result = 31 * result + this.myFlags;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "sqldelight/com/intellij/psi/impl/ElementBase$ElementIconRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

