/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.projectRoots.Sdk;
import sqldelight.com.intellij.openapi.roots.ContentEntry;
import sqldelight.com.intellij.openapi.roots.DependencyScope;
import sqldelight.com.intellij.openapi.roots.InheritedJdkOrderEntry;
import sqldelight.com.intellij.openapi.roots.JdkOrderEntry;
import sqldelight.com.intellij.openapi.roots.ModuleOrderEntry;
import sqldelight.com.intellij.openapi.roots.ModuleRootModel;
import sqldelight.com.intellij.openapi.roots.OrderEntry;
import sqldelight.com.intellij.openapi.roots.OrderEnumerator;
import sqldelight.com.intellij.openapi.roots.RootPolicy;
import sqldelight.com.intellij.openapi.roots.SourceFolder;
import sqldelight.com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import sqldelight.com.intellij.openapi.vfs.VfsUtilCore;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.util.ArrayUtilRt;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public abstract class RootModelBase
implements ModuleRootModel {
    @Override
    public VirtualFile @NotNull [] getContentRoots() {
        Collection<ContentEntry> content = this.getContent();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(content.size());
        for (ContentEntry contentEntry : content) {
            VirtualFile file = contentEntry.getFile();
            if (file == null) continue;
            result.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(0);
        }
        return virtualFileArray;
    }

    @Override
    public String @NotNull [] getContentRootUrls() {
        Collection<ContentEntry> content = this.getContent();
        if (content.isEmpty()) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                RootModelBase.$$$reportNull$$$0(1);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>(content.size());
        for (ContentEntry contentEntry : content) {
            result.add(contentEntry.getUrl());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    public String @NotNull [] getExcludeRootUrls() {
        SmartList<String> result = new SmartList<String>();
        for (ContentEntry contentEntry : this.getContent()) {
            result.addAll(contentEntry.getExcludeFolderUrls());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @Override
    public VirtualFile @NotNull [] getExcludeRoots() {
        SmartList result = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            Collections.addAll(result, contentEntry.getExcludeFolderFiles());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    @Override
    public String @NotNull [] getSourceRootUrls() {
        String[] stringArray = this.getSourceRootUrls(true);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Override
    public String @NotNull [] getSourceRootUrls(boolean includingTests) {
        SmartList<String> result = new SmartList<String>();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                if (!includingTests && sourceFolder.isTestSource()) continue;
                result.add(sourceFolder.getUrl());
            }
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Override
    public VirtualFile @NotNull [] getSourceRoots() {
        VirtualFile[] virtualFileArray = this.getSourceRoots(true);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getSourceRoots(boolean includingTests) {
        SmartList<VirtualFile> result = new SmartList<VirtualFile>();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                VirtualFile file = sourceFolder.getFile();
                if (file == null || !includingTests && sourceFolder.isTestSource()) continue;
                result.add(file);
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(8);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            RootModelBase.$$$reportNull$$$0(9);
        }
        List<VirtualFile> list = this.getSourceRoots(Collections.singleton(rootType));
        if (list == null) {
            RootModelBase.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            RootModelBase.$$$reportNull$$$0(11);
        }
        SmartList<VirtualFile> result = new SmartList<VirtualFile>();
        for (ContentEntry contentEntry : this.getContent()) {
            List<SourceFolder> sourceFolders = contentEntry.getSourceFolders(rootTypes);
            for (SourceFolder sourceFolder : sourceFolders) {
                VirtualFile file = sourceFolder.getFile();
                if (file == null) continue;
                result.add(file);
            }
        }
        SmartList<VirtualFile> smartList = result;
        if (smartList == null) {
            RootModelBase.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    @Override
    public ContentEntry @NotNull [] getContentEntries() {
        Collection<ContentEntry> content = this.getContent();
        ContentEntry[] contentEntryArray = content.toArray(new ContentEntry[0]);
        if (contentEntryArray == null) {
            RootModelBase.$$$reportNull$$$0(13);
        }
        return contentEntryArray;
    }

    protected abstract Collection<ContentEntry> getContent();

    @Override
    public Sdk getSdk() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry).getJdk();
        }
        return null;
    }

    @Override
    public boolean isSdkInherited() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof InheritedJdkOrderEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public OrderEnumerator orderEntries() {
        return new ModuleOrderEnumerator(this, null);
    }

    @Override
    public <R> R processOrder(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            RootModelBase.$$$reportNull$$$0(14);
        }
        R result = initialValue;
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            result = orderEntry.accept(policy, result);
        }
        return result;
    }

    @Override
    public String @NotNull [] getDependencyModuleNames() {
        List result = this.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries().process(new CollectDependentModules(), new ArrayList());
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    @Override
    public Module @NotNull [] getModuleDependencies() {
        Module[] moduleArray = this.getModuleDependencies(true);
        if (moduleArray == null) {
            RootModelBase.$$$reportNull$$$0(16);
        }
        return moduleArray;
    }

    @Override
    public Module @NotNull [] getModuleDependencies(boolean includeTests) {
        OrderEntry[] entries = this.getOrderEntries();
        SmartList<Module> result = null;
        for (OrderEntry entry : entries) {
            Module module;
            if (!(entry instanceof ModuleOrderEntry)) continue;
            DependencyScope scope = ((ModuleOrderEntry)entry).getScope();
            if (!includeTests && !scope.isForProductionCompile() && !scope.isForProductionRuntime() || (module = ((ModuleOrderEntry)entry).getModule()) == null) continue;
            if (result == null) {
                result = new SmartList<Module>();
            }
            result.add(module);
        }
        Module[] moduleArray = result == null ? Module.EMPTY_ARRAY : result.toArray(Module.EMPTY_ARRAY);
        if (moduleArray == null) {
            RootModelBase.$$$reportNull$$$0(17);
        }
        return moduleArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/RootModelBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootUrls";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRootUrls";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRoots";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootUrls";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/RootModelBase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentEntries";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyModuleNames";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processOrder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollectDependentModules
    extends RootPolicy<List<String>> {
        private CollectDependentModules() {
        }

        @Override
        @NotNull
        public List<String> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, @NotNull List<String> arrayList) {
            if (moduleOrderEntry == null) {
                CollectDependentModules.$$$reportNull$$$0(0);
            }
            if (arrayList == null) {
                CollectDependentModules.$$$reportNull$$$0(1);
            }
            arrayList.add(moduleOrderEntry.getModuleName());
            List<String> list = arrayList;
            if (list == null) {
                CollectDependentModules.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleOrderEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/RootModelBase$CollectDependentModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/RootModelBase$CollectDependentModules";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitModuleOrderEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitModuleOrderEntry";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

