/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.fileTypes.FileTypeRegistry;
import sqldelight.com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.module.ModuleManager;
import sqldelight.com.intellij.openapi.module.UnloadedModuleDescription;
import sqldelight.com.intellij.openapi.module.impl.ModuleManagerImpl;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.projectRoots.Sdk;
import sqldelight.com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import sqldelight.com.intellij.openapi.roots.ContentEntry;
import sqldelight.com.intellij.openapi.roots.JavaSyntheticLibrary;
import sqldelight.com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import sqldelight.com.intellij.openapi.roots.LibraryOrderEntry;
import sqldelight.com.intellij.openapi.roots.ModuleOrderEntry;
import sqldelight.com.intellij.openapi.roots.ModuleRootManager;
import sqldelight.com.intellij.openapi.roots.ModuleSourceOrderEntry;
import sqldelight.com.intellij.openapi.roots.OrderEntry;
import sqldelight.com.intellij.openapi.roots.OrderEnumerationHandler;
import sqldelight.com.intellij.openapi.roots.OrderEnumerator;
import sqldelight.com.intellij.openapi.roots.OrderRootType;
import sqldelight.com.intellij.openapi.roots.SourceFolder;
import sqldelight.com.intellij.openapi.roots.SyntheticLibrary;
import sqldelight.com.intellij.openapi.roots.impl.ContentEntryImpl;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryInfo;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryInfoWithExcludePatterns;
import sqldelight.com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import sqldelight.com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import sqldelight.com.intellij.openapi.roots.impl.PackageDirectoryCache;
import sqldelight.com.intellij.openapi.roots.impl.libraries.LibraryEx;
import sqldelight.com.intellij.openapi.roots.libraries.Library;
import sqldelight.com.intellij.openapi.util.Condition;
import sqldelight.com.intellij.openapi.util.Conditions;
import sqldelight.com.intellij.openapi.util.Pair;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.openapi.vfs.VfsUtilCore;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileManager;
import sqldelight.com.intellij.openapi.vfs.VirtualFileWithId;
import sqldelight.com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import sqldelight.com.intellij.util.CollectionQuery;
import sqldelight.com.intellij.util.Function;
import sqldelight.com.intellij.util.ObjectUtils;
import sqldelight.com.intellij.util.Query;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.com.intellij.util.containers.ConcurrentBitSet;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.containers.ImmutableList;
import sqldelight.com.intellij.util.containers.MultiMap;
import sqldelight.com.intellij.util.containers.SLRUMap;
import sqldelight.com.intellij.util.containers.Stack;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

class RootIndex {
    static final Comparator<OrderEntry> BY_OWNER_MODULE = (o1, o2) -> {
        String name1 = o1.getOwnerModule().getName();
        String name2 = o2.getOwnerModule().getName();
        return name1.compareTo(name2);
    };
    private static final Logger LOG = Logger.getInstance(RootIndex.class);
    private static final FileTypeRegistry ourFileTypes = FileTypeRegistry.getInstance();
    private final Map<VirtualFile, String> myPackagePrefixByRoot;
    private final Map<VirtualFile, DirectoryInfo> myRootInfos;
    private final ConcurrentBitSet myNonInterestingIds;
    @NotNull
    private final Project myProject;
    final PackageDirectoryCache myPackageDirectoryCache;
    private OrderEntryGraph myOrderEntryGraph;

    RootIndex(@NotNull Project project) {
        ModuleManager manager;
        if (project == null) {
            RootIndex.$$$reportNull$$$0(0);
        }
        this.myNonInterestingIds = new ConcurrentBitSet();
        this.myProject = project;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (project.isDefault()) {
            LOG.error("Directory index may not be queried for default project");
        }
        if ((manager = ModuleManager.getInstance(project)) instanceof ModuleManagerImpl) {
            LOG.assertTrue(((ModuleManagerImpl)manager).areModulesLoaded(), "Directory index can only be queried after project initialization");
        }
        RootInfo info = this.buildRootInfo(project);
        Set<VirtualFile> allRoots = info.getAllRoots();
        MultiMap<String, VirtualFile> rootsByPackagePrefix = MultiMap.create(allRoots.size(), 0.75f);
        this.myRootInfos = new HashMap<VirtualFile, DirectoryInfo>(allRoots.size());
        this.myPackagePrefixByRoot = new HashMap<VirtualFile, String>(allRoots.size());
        ArrayList<List<VirtualFile>> hierarchies = new ArrayList<List<VirtualFile>>(allRoots.size());
        for (VirtualFile root : allRoots) {
            Pair<DirectoryInfo, String> pair;
            List<VirtualFile> hierarchy = RootIndex.getHierarchy(root, allRoots, info);
            hierarchies.add(hierarchy);
            if (hierarchy != null) {
                pair = RootIndex.calcDirectoryInfoAndPackagePrefix(root, hierarchy, info);
            } else {
                Pair<DirectoryInfo, String> pair2;
                pair = pair2;
                super(NonProjectDirectoryInfo.IGNORED, null);
            }
            Pair<DirectoryInfo, String> pair3 = pair;
            this.myRootInfos.put(root, (DirectoryInfo)pair3.first);
            String packagePrefix = (String)pair3.second;
            rootsByPackagePrefix.putValue(packagePrefix, root);
            this.myPackagePrefixByRoot.put(root, packagePrefix);
        }
        this.storeContentsBeneathExcluded(allRoots, hierarchies);
        this.myPackageDirectoryCache = new PackageDirectoryCache(rootsByPackagePrefix){

            @Override
            protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName2) {
                if (dir == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (packageName2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return RootIndex.this.getInfoForFile(dir).isInProject(dir) && packageName2.equals(RootIndex.this.getPackageName(dir));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dir";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packageName";
                        break;
                    }
                }
                objectArray[1] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex$1";
                objectArray[2] = "isPackageDirectory";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void storeContentsBeneathExcluded(@NotNull Set<? extends VirtualFile> allRoots, @NotNull List<? extends List<VirtualFile>> hierarchies) {
        if (allRoots == null) {
            RootIndex.$$$reportNull$$$0(1);
        }
        if (hierarchies == null) {
            RootIndex.$$$reportNull$$$0(2);
        }
        int i = 0;
        for (VirtualFile virtualFile : allRoots) {
            DirectoryInfo parentInfo;
            VirtualFile parentRoot;
            List<VirtualFile> hierarchy;
            if ((hierarchy = hierarchies.get(i++)) == null) continue;
            DirectoryInfo dirInfo = this.myRootInfos.get(virtualFile);
            assert (dirInfo != null);
            boolean hasContent = !RootIndex.isExcluded(dirInfo) && dirInfo.getContentRoot() != null;
            if (!hasContent || (parentRoot = hierarchy.size() >= 2 ? hierarchy.get(1) : null) == null || !RootIndex.isExcluded(parentInfo = this.myRootInfos.get(parentRoot))) continue;
            this.addContentBeneathExcludedInfo(parentInfo, parentRoot, dirInfo);
        }
    }

    private void addContentBeneathExcludedInfo(@NotNull DirectoryInfo parentExcludedInfo, @NotNull VirtualFile parentFile, @NotNull DirectoryInfo childInfo) {
        List<DirectoryInfoImpl> beneathInfo;
        if (parentExcludedInfo == null) {
            RootIndex.$$$reportNull$$$0(3);
        }
        if (parentFile == null) {
            RootIndex.$$$reportNull$$$0(4);
        }
        if (childInfo == null) {
            RootIndex.$$$reportNull$$$0(5);
        }
        if (parentExcludedInfo instanceof NonProjectDirectoryInfo.WithBeneathInfo) {
            beneathInfo = ((NonProjectDirectoryInfo.WithBeneathInfo)parentExcludedInfo).myContentInfosBeneath;
        } else if (parentExcludedInfo instanceof NonProjectDirectoryInfo) {
            NonProjectDirectoryInfo.WithBeneathInfo newInfo = new NonProjectDirectoryInfo.WithBeneathInfo((NonProjectDirectoryInfo)parentExcludedInfo);
            this.myRootInfos.put(parentFile, newInfo);
            beneathInfo = newInfo.myContentInfosBeneath;
        } else if (parentExcludedInfo instanceof DirectoryInfoImpl) {
            beneathInfo = ((DirectoryInfoImpl)parentExcludedInfo).myContentInfosBeneath;
        } else {
            throw new RuntimeException("unknown info: " + parentExcludedInfo);
        }
        beneathInfo.add((DirectoryInfoImpl)childInfo);
    }

    private static boolean isExcluded(@NotNull DirectoryInfo info) {
        if (info == null) {
            RootIndex.$$$reportNull$$$0(6);
        }
        return info instanceof DirectoryInfoImpl && info.isExcluded(((DirectoryInfoImpl)info).getRoot()) || info instanceof NonProjectDirectoryInfo && ((NonProjectDirectoryInfo)info).isExcluded();
    }

    void onLowMemory() {
        this.myPackageDirectoryCache.onLowMemory();
    }

    @NotNull
    private RootInfo buildRootInfo(@NotNull Project project) {
        if (project == null) {
            RootIndex.$$$reportNull$$$0(7);
        }
        RootInfo info = new RootInfo();
        ModuleManager moduleManager = ModuleManager.getInstance(project);
        for (Module module : moduleManager.getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (VirtualFile contentRoot : moduleRootManager.getContentRoots()) {
                if (info.contentRootOf.containsKey(contentRoot) || !RootIndex.ensureValid(contentRoot, module)) continue;
                info.contentRootOf.put(contentRoot, module);
            }
            for (ContentEntry contentEntry : moduleRootManager.getContentEntries()) {
                Object patterns;
                int n;
                if (!(contentEntry instanceof ContentEntryImpl) || !((ContentEntryImpl)contentEntry).isDisposed()) {
                    VirtualFile[] virtualFileArray = contentEntry.getExcludeFolderFiles();
                    int n2 = virtualFileArray.length;
                    for (n = 0; n < n2; ++n) {
                        VirtualFile excludeRoot = virtualFileArray[n];
                        if (!RootIndex.ensureValid(excludeRoot, contentEntry)) continue;
                        info.excludedFromModule.put(excludeRoot, module);
                    }
                    patterns = contentEntry.getExcludePatterns();
                    if (!patterns.isEmpty()) {
                        FileTypeAssocTable<Boolean> table2 = new FileTypeAssocTable<Boolean>();
                        Iterator iterator = patterns.iterator();
                        while (iterator.hasNext()) {
                            String pattern = (String)iterator.next();
                            table2.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(pattern), Boolean.TRUE);
                        }
                        info.excludeFromContentRootTables.put(contentEntry.getFile(), table2);
                    }
                }
                patterns = contentEntry.getSourceFolders();
                int table2 = ((SourceFolder[])patterns).length;
                for (n = 0; n < table2; ++n) {
                    VirtualFile[] sourceFolder = patterns[n];
                    VirtualFile sourceFolderRoot = sourceFolder.getFile();
                    if (sourceFolderRoot == null || !RootIndex.ensureValid(sourceFolderRoot, sourceFolder)) continue;
                    info.sourceFolders.put(sourceFolderRoot, sourceFolder);
                    info.classAndSourceRoots.add(sourceFolderRoot);
                    info.sourceRootOf.putValue(sourceFolderRoot, module);
                    info.packagePrefix.put(sourceFolderRoot, sourceFolder.getPackagePrefix());
                }
            }
            for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                Library library;
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                VirtualFile[] sourceRoots = entry.getRootFiles(OrderRootType.SOURCES);
                VirtualFile[] classRoots = entry.getRootFiles(OrderRootType.CLASSES);
                for (VirtualFile sourceRoot : sourceRoots) {
                    if (!RootIndex.ensureValid(sourceRoot, entry)) continue;
                    info.classAndSourceRoots.add(sourceRoot);
                    info.libraryOrSdkSources.add(sourceRoot);
                    info.packagePrefix.put(sourceRoot, "");
                }
                for (VirtualFile classRoot : classRoots) {
                    if (!RootIndex.ensureValid(classRoot, entry)) continue;
                    info.classAndSourceRoots.add(classRoot);
                    info.libraryOrSdkClasses.add(classRoot);
                    info.packagePrefix.put(classRoot, "");
                }
                if (!(orderEntry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)orderEntry).getLibrary()) == null) continue;
                for (VirtualFile root : ((LibraryEx)library).getExcludedRoots()) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.excludedFromLibraries.putValue(root, library);
                }
                for (VirtualFile root : sourceRoots) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.sourceOfLibraries.putValue(root, library);
                }
                for (VirtualFile root : classRoots) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.classOfLibraries.putValue(root, library);
                }
            }
        }
        for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            Collection<SyntheticLibrary> libraries = provider.getAdditionalProjectLibraries(project);
            for (SyntheticLibrary library : libraries) {
                for (VirtualFile sourceRoot : library.getSourceRoots()) {
                    if (!RootIndex.ensureValid(sourceRoot, library, provider)) continue;
                    info.libraryOrSdkSources.add(sourceRoot);
                    info.classAndSourceRoots.add(sourceRoot);
                    if (library instanceof JavaSyntheticLibrary) {
                        info.packagePrefix.put(sourceRoot, "");
                    }
                    info.sourceOfLibraries.putValue(sourceRoot, library);
                }
                for (VirtualFile classRoot : library.getBinaryRoots()) {
                    if (!RootIndex.ensureValid(classRoot, project, provider)) continue;
                    info.libraryOrSdkClasses.add(classRoot);
                    info.classAndSourceRoots.add(classRoot);
                    if (library instanceof JavaSyntheticLibrary) {
                        info.packagePrefix.put(classRoot, "");
                    }
                    info.classOfLibraries.putValue(classRoot, library);
                }
                for (VirtualFile file2 : library.getExcludedRoots()) {
                    if (!RootIndex.ensureValid(file2, project, provider)) continue;
                    info.excludedFromLibraries.putValue(file2, library);
                }
            }
        }
        for (DirectoryIndexExcludePolicy policy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions(project)) {
            List<VirtualFile> files = ContainerUtil.mapNotNull(policy.getExcludeUrlsForProject(), url -> VirtualFileManager.getInstance().findFileByUrl((String)url));
            info.excludedFromProject.addAll(ContainerUtil.filter(files, file -> RootIndex.ensureValid(file, project, policy)));
            Function<Sdk, List<VirtualFile>> fun = policy.getExcludeSdkRootsStrategy();
            if (fun == null) continue;
            HashSet<Sdk> sdks = new HashSet<Sdk>();
            for (Module m : ModuleManager.getInstance(this.myProject).getModules()) {
                Sdk sdk = ModuleRootManager.getInstance(m).getSdk();
                if (sdk == null) continue;
                sdks.add(sdk);
            }
            HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
            for (Sdk sdk : sdks) {
                roots.addAll(Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)));
            }
            for (Sdk sdk : sdks) {
                info.excludedFromSdkRoots.addAll(ContainerUtil.filter((Collection)fun.fun(sdk), file -> RootIndex.ensureValid(file, sdk, policy) && !roots.contains(file)));
            }
        }
        for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
            for (VirtualFilePointer pointer : description.getContentRoots()) {
                VirtualFile contentRoot = pointer.getFile();
                if (contentRoot == null || !RootIndex.ensureValid(contentRoot, description)) continue;
                info.contentRootOfUnloaded.put(contentRoot, description.getName());
            }
        }
        RootInfo rootInfo = info;
        if (rootInfo == null) {
            RootIndex.$$$reportNull$$$0(8);
        }
        return rootInfo;
    }

    private static boolean ensureValid(@NotNull VirtualFile file, @NotNull Object container) {
        if (file == null) {
            RootIndex.$$$reportNull$$$0(9);
        }
        if (container == null) {
            RootIndex.$$$reportNull$$$0(10);
        }
        return RootIndex.ensureValid(file, container, null);
    }

    private static boolean ensureValid(@NotNull VirtualFile file, @NotNull Object container, @Nullable Object containerProvider) {
        if (file == null) {
            RootIndex.$$$reportNull$$$0(11);
        }
        if (container == null) {
            RootIndex.$$$reportNull$$$0(12);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return false;
        }
        if (!file.isValid()) {
            if (containerProvider != null) {
                LOG.error("Invalid root " + file + " in " + container + " provided by " + containerProvider.getClass());
            } else {
                LOG.error("Invalid root " + file + " in " + container);
            }
            return false;
        }
        return true;
    }

    @NotNull
    private synchronized OrderEntryGraph getOrderEntryGraph() {
        if (this.myOrderEntryGraph == null) {
            RootInfo rootInfo = this.buildRootInfo(this.myProject);
            this.myOrderEntryGraph = new OrderEntryGraph(this.myProject, rootInfo);
        }
        OrderEntryGraph orderEntryGraph = this.myOrderEntryGraph;
        if (orderEntryGraph == null) {
            RootIndex.$$$reportNull$$$0(13);
        }
        return orderEntryGraph;
    }

    @NotNull
    DirectoryInfo getInfoForFile(@NotNull VirtualFile file) {
        if (file == null) {
            RootIndex.$$$reportNull$$$0(14);
        }
        if (!file.isValid() || !(file instanceof VirtualFileWithId)) {
            NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.INVALID;
            if (nonProjectDirectoryInfo == null) {
                RootIndex.$$$reportNull$$$0(15);
            }
            return nonProjectDirectoryInfo;
        }
        for (VirtualFile each = file; each != null; each = each.getParent()) {
            DirectoryInfo info;
            int id = ((VirtualFileWithId)((Object)each)).getId();
            if (this.myNonInterestingIds.get(id) || (info = this.handleInterestingId(id, each)) == null) continue;
            DirectoryInfo directoryInfo = info;
            if (directoryInfo == null) {
                RootIndex.$$$reportNull$$$0(16);
            }
            return directoryInfo;
        }
        NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.NOT_UNDER_PROJECT_ROOTS;
        if (nonProjectDirectoryInfo == null) {
            RootIndex.$$$reportNull$$$0(17);
        }
        return nonProjectDirectoryInfo;
    }

    @Nullable
    private DirectoryInfo handleInterestingId(int id, @NotNull VirtualFile file) {
        DirectoryInfo info;
        if (file == null) {
            RootIndex.$$$reportNull$$$0(18);
        }
        if ((info = this.myRootInfos.get(file)) != null) {
            return info;
        }
        if (ourFileTypes.isFileIgnored(file)) {
            return NonProjectDirectoryInfo.IGNORED;
        }
        if ((id > 500000000 || id < 0) && LOG.isDebugEnabled()) {
            LOG.error("Invalid id: " + id + " for " + file + " of " + file.getClass());
        }
        this.myNonInterestingIds.set(id);
        return null;
    }

    @NotNull
    Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName2, boolean includeLibrarySources) {
        if (packageName2 == null) {
            RootIndex.$$$reportNull$$$0(19);
        }
        List<VirtualFile> result = this.myPackageDirectoryCache.getDirectoriesByPackageName(packageName2);
        if (!includeLibrarySources) {
            result = ContainerUtil.filter(result, file -> {
                DirectoryInfo info = this.getInfoForFile((VirtualFile)file);
                return info.isInProject((VirtualFile)file) && (!info.isInLibrarySource((VirtualFile)file) || info.isInModuleSource((VirtualFile)file) || info.hasLibraryClassRoot());
            });
        }
        return new CollectionQuery<VirtualFile>(result);
    }

    @Nullable
    String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            RootIndex.$$$reportNull$$$0(20);
        }
        if (dir.isDirectory()) {
            if (ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (this.myPackagePrefixByRoot.containsKey(dir)) {
                return this.myPackagePrefixByRoot.get(dir);
            }
            VirtualFile parent = dir.getParent();
            if (parent != null) {
                return RootIndex.getPackageNameForSubdir(this.getPackageName(parent), dir.getName());
            }
        }
        return null;
    }

    private static String getPackageNameForSubdir(@Nullable String parentPackageName, @NotNull String subdirName) {
        if (subdirName == null) {
            RootIndex.$$$reportNull$$$0(21);
        }
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName.isEmpty() ? subdirName : parentPackageName + "." + subdirName;
    }

    @Nullable(value="returns null only if dir is under ignored folder")
    private static @Nullable(value="returns null only if dir is under ignored folder") List<VirtualFile> getHierarchy(@NotNull VirtualFile deepDir, @NotNull Set<? extends VirtualFile> allRoots, @NotNull RootInfo info) {
        if (deepDir == null) {
            RootIndex.$$$reportNull$$$0(22);
        }
        if (allRoots == null) {
            RootIndex.$$$reportNull$$$0(23);
        }
        if (info == null) {
            RootIndex.$$$reportNull$$$0(24);
        }
        ArrayList<VirtualFile> hierarchy = new ArrayList<VirtualFile>();
        boolean hasContentRoots = false;
        for (VirtualFile dir = deepDir; dir != null; dir = dir.getParent()) {
            if (!(hasContentRoots |= info.contentRootOf.get(dir) != null) && ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (!allRoots.contains(dir)) continue;
            hierarchy.add(dir);
        }
        return hierarchy;
    }

    @NotNull
    private static Pair<DirectoryInfo, String> calcDirectoryInfoAndPackagePrefix(@NotNull VirtualFile root, @NotNull List<? extends VirtualFile> hierarchy, @NotNull RootInfo info) {
        VirtualFile nearestContentRoot;
        boolean inProject;
        if (root == null) {
            RootIndex.$$$reportNull$$$0(25);
        }
        if (hierarchy == null) {
            RootIndex.$$$reportNull$$$0(26);
        }
        if (info == null) {
            RootIndex.$$$reportNull$$$0(27);
        }
        VirtualFile moduleContentRoot = info.findNearestContentRoot(hierarchy);
        Pair librarySourceRootInfo = info.findLibraryRootInfo(hierarchy, true);
        VirtualFile librarySourceRoot = (VirtualFile)Pair.getFirst(librarySourceRootInfo);
        Pair libraryClassRootInfo = info.findLibraryRootInfo(hierarchy, false);
        VirtualFile libraryClassRoot = (VirtualFile)Pair.getFirst(libraryClassRootInfo);
        boolean bl = inProject = moduleContentRoot != null || (libraryClassRoot != null || librarySourceRoot != null) && !info.excludedFromSdkRoots.contains(root);
        if (inProject) {
            nearestContentRoot = moduleContentRoot;
        } else {
            nearestContentRoot = info.findNearestContentRootForExcluded(hierarchy);
            if (nearestContentRoot == null) {
                return new Pair<NonProjectDirectoryInfo, Object>(NonProjectDirectoryInfo.EXCLUDED, null);
            }
        }
        VirtualFile sourceRoot = info.findPackageRootInfo(hierarchy, moduleContentRoot, null, librarySourceRoot);
        VirtualFile moduleSourceRoot = librarySourceRoot == null ? sourceRoot : info.findPackageRootInfo(hierarchy, moduleContentRoot, null, null);
        boolean inModuleSources = moduleSourceRoot != null;
        boolean inLibrarySource = librarySourceRoot != null;
        SourceFolder sourceFolder = moduleSourceRoot != null ? (SourceFolder)info.sourceFolders.get(moduleSourceRoot) : null;
        Module module = (Module)info.contentRootOf.get(nearestContentRoot);
        String unloadedModuleName = (String)info.contentRootOfUnloaded.get(nearestContentRoot);
        FileTypeAssocTable contentExcludePatterns = moduleContentRoot != null ? (FileTypeAssocTable)info.excludeFromContentRootTables.get(moduleContentRoot) : null;
        Condition<? super VirtualFile> libraryExclusionPredicate = RootIndex.getLibraryExclusionPredicate((List)Pair.getSecond(librarySourceRootInfo));
        DirectoryInfoImpl directoryInfo = contentExcludePatterns != null || libraryExclusionPredicate != null ? new DirectoryInfoWithExcludePatterns(root, module, nearestContentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, contentExcludePatterns, libraryExclusionPredicate, unloadedModuleName) : new DirectoryInfoImpl(root, module, nearestContentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, unloadedModuleName);
        VirtualFile packageRoot = libraryClassRoot == null ? sourceRoot : info.findPackageRootInfo(hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
        String packagePrefix = info.calcPackagePrefix(root, packageRoot);
        Pair<DirectoryInfo, String> pair = Pair.create(directoryInfo, packagePrefix);
        if (pair == null) {
            RootIndex.$$$reportNull$$$0(28);
        }
        return pair;
    }

    @Nullable
    private static Condition<? super VirtualFile> getLibraryExclusionPredicate(@Nullable List<? extends Condition<? super VirtualFile>> exclusions) {
        if (exclusions != null) {
            Condition<Object> result = Conditions.alwaysFalse();
            for (Condition<? super VirtualFile> condition : exclusions) {
                result = Conditions.or(result, condition);
            }
            return result == Conditions.alwaysFalse() ? null : result;
        }
        return null;
    }

    @NotNull
    List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        if (info == null) {
            RootIndex.$$$reportNull$$$0(29);
        }
        if (!(info instanceof DirectoryInfoImpl)) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                RootIndex.$$$reportNull$$$0(30);
            }
            return list;
        }
        List list = this.getOrderEntryGraph().getOrderEntries(((DirectoryInfoImpl)info).getRoot());
        if (list == null) {
            RootIndex.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    Set<String> getDependentUnloadedModules(@NotNull Module module) {
        if (module == null) {
            RootIndex.$$$reportNull$$$0(32);
        }
        Set<String> set = this.getOrderEntryGraph().getDependentUnloadedModules(module);
        if (set == null) {
            RootIndex.$$$reportNull$$$0(33);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 30: 
            case 31: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 30: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchies";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentExcludedInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childInfo";
                break;
            }
            case 6: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdirName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepDir";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchy";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRootInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntryGraph";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDirectoryInfoAndPackagePrefix";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "storeContentsBeneathExcluded";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addContentBeneathExcludedInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildRootInfo";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 30: 
            case 31: 
            case 33: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleInterestingId";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameForSubdir";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calcDirectoryInfoAndPackagePrefix";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDependentUnloadedModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 30: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class SynchronizedSLRUCache<K, V>
    extends SLRUMap<K, V> {
        private final Object myLock = ObjectUtils.sentinel("Root index lock");

        SynchronizedSLRUCache(int protectedQueueSize, int probationalQueueSize) {
            super(protectedQueueSize, probationalQueueSize);
        }

        @NotNull
        public abstract V createValue(@NotNull K var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public V get(K key) {
            Object value;
            Object object = this.myLock;
            synchronized (object) {
                value = super.get(key);
                if (value != null) {
                    Object v = value;
                    // MONITOREXIT @DISABLED, blocks:[3, 7] lbl6 : MonitorExitStatement: MONITOREXIT : var3_2
                    if (v == null) {
                        SynchronizedSLRUCache.$$$reportNull$$$0(0);
                    }
                    return v;
                }
            }
            value = this.createValue(key);
            object = this.myLock;
            synchronized (object) {
                this.put(key, value);
            }
            Object v = value;
            if (v == null) {
                SynchronizedSLRUCache.$$$reportNull$$$0(1);
            }
            return v;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/openapi/roots/impl/RootIndex$SynchronizedSLRUCache", "get"));
        }
    }

    private static class RootInfo {
        @NotNull
        private final Set<VirtualFile> classAndSourceRoots = new LinkedHashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> libraryOrSdkSources = new HashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> libraryOrSdkClasses = new HashSet<VirtualFile>();
        @NotNull
        private final Map<VirtualFile, Module> contentRootOf = new HashMap<VirtualFile, Module>();
        @NotNull
        private final Map<VirtualFile, String> contentRootOfUnloaded = new HashMap<VirtualFile, String>();
        @NotNull
        private final MultiMap<VirtualFile, Module> sourceRootOf = MultiMap.createSet();
        @NotNull
        private final Map<VirtualFile, SourceFolder> sourceFolders = new HashMap<VirtualFile, SourceFolder>();
        @NotNull
        private final MultiMap<VirtualFile, Object> excludedFromLibraries = MultiMap.createSet();
        @NotNull
        private final MultiMap<VirtualFile, Object> classOfLibraries = MultiMap.createSet();
        @NotNull
        private final MultiMap<VirtualFile, Object> sourceOfLibraries = MultiMap.createSet();
        @NotNull
        private final Set<VirtualFile> excludedFromProject = new HashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> excludedFromSdkRoots = new HashSet<VirtualFile>();
        @NotNull
        private final Map<VirtualFile, Module> excludedFromModule = new HashMap<VirtualFile, Module>();
        @NotNull
        private final Map<VirtualFile, FileTypeAssocTable<Boolean>> excludeFromContentRootTables = new HashMap<VirtualFile, FileTypeAssocTable<Boolean>>();
        @NotNull
        private final Map<VirtualFile, String> packagePrefix = new HashMap<VirtualFile, String>();

        private RootInfo() {
        }

        @NotNull
        Set<VirtualFile> getAllRoots() {
            LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
            result.addAll(this.classAndSourceRoots);
            result.addAll(this.contentRootOf.keySet());
            result.addAll(this.contentRootOfUnloaded.keySet());
            result.addAll(this.excludedFromLibraries.keySet());
            result.addAll(this.excludedFromModule.keySet());
            result.addAll(this.excludedFromProject);
            result.addAll(this.excludedFromSdkRoots);
            LinkedHashSet<VirtualFile> linkedHashSet = result;
            if (linkedHashSet == null) {
                RootInfo.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }

        @Nullable
        private VirtualFile findNearestContentRoot(@NotNull List<? extends VirtualFile> hierarchy) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(1);
            }
            Collection<Module> sourceRootOwners = null;
            boolean underExcludedSourceRoot = false;
            for (VirtualFile virtualFile : hierarchy) {
                Collection<Module> modulesForSourceRoot;
                FileTypeAssocTable<Boolean> table2;
                Module module = this.contentRootOf.get(virtualFile);
                Module excludedFrom = this.excludedFromModule.get(virtualFile);
                if (module != null && (table2 = this.excludeFromContentRootTables.get(virtualFile)) != null && RootInfo.isExcludedByPattern(virtualFile, hierarchy, table2)) {
                    excludedFrom = module;
                }
                if (module != null && (excludedFrom != module || underExcludedSourceRoot && sourceRootOwners.contains(module))) {
                    return virtualFile;
                }
                if (excludedFrom != null || this.excludedFromProject.contains(virtualFile) || this.contentRootOfUnloaded.containsKey(virtualFile)) {
                    if (sourceRootOwners == null) {
                        return null;
                    }
                    underExcludedSourceRoot = true;
                }
                if (underExcludedSourceRoot || !this.sourceRootOf.containsKey(virtualFile) || (modulesForSourceRoot = this.sourceRootOf.get(virtualFile)).isEmpty()) continue;
                sourceRootOwners = sourceRootOwners == null ? modulesForSourceRoot : ContainerUtil.union(sourceRootOwners, modulesForSourceRoot);
            }
            return null;
        }

        private static boolean isExcludedByPattern(@NotNull VirtualFile contentRoot, @NotNull List<? extends VirtualFile> hierarchy, @NotNull FileTypeAssocTable<Boolean> table2) {
            if (contentRoot == null) {
                RootInfo.$$$reportNull$$$0(2);
            }
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(3);
            }
            if (table2 == null) {
                RootInfo.$$$reportNull$$$0(4);
            }
            for (VirtualFile virtualFile : hierarchy) {
                if (table2.findAssociatedFileType(virtualFile.getNameSequence()) != null) {
                    return true;
                }
                if (!virtualFile.equals(contentRoot)) continue;
                break;
            }
            return false;
        }

        @Nullable
        private VirtualFile findNearestContentRootForExcluded(@NotNull List<? extends VirtualFile> hierarchy) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(5);
            }
            for (VirtualFile virtualFile : hierarchy) {
                if (!this.contentRootOf.containsKey(virtualFile) && !this.contentRootOfUnloaded.containsKey(virtualFile)) continue;
                return virtualFile;
            }
            return null;
        }

        @Nullable
        private Pair<VirtualFile, List<Condition<? super VirtualFile>>> findLibraryRootInfo(@NotNull List<? extends VirtualFile> hierarchy, boolean source) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(6);
            }
            HashSet<Object> librariesToIgnore = new HashSet<Object>();
            for (VirtualFile virtualFile : hierarchy) {
                List<Condition<? super VirtualFile>> found;
                librariesToIgnore.addAll(this.excludedFromLibraries.get(virtualFile));
                if (!(source && this.libraryOrSdkSources.contains(virtualFile) ? (found = RootInfo.findInLibraryProducers(virtualFile, this.sourceOfLibraries, librariesToIgnore)) != null : !source && this.libraryOrSdkClasses.contains(virtualFile) && (found = RootInfo.findInLibraryProducers(virtualFile, this.classOfLibraries, librariesToIgnore)) != null)) continue;
                return Pair.create(virtualFile, found);
            }
            return null;
        }

        private static List<Condition<? super VirtualFile>> findInLibraryProducers(@NotNull VirtualFile root, @NotNull MultiMap<VirtualFile, Object> libraryRoots, @NotNull Set<Object> librariesToIgnore) {
            if (root == null) {
                RootInfo.$$$reportNull$$$0(7);
            }
            if (libraryRoots == null) {
                RootInfo.$$$reportNull$$$0(8);
            }
            if (librariesToIgnore == null) {
                RootInfo.$$$reportNull$$$0(9);
            }
            if (!libraryRoots.containsKey(root)) {
                return Collections.emptyList();
            }
            Collection<Object> producers = libraryRoots.get(root);
            HashSet<Object> libraries = new HashSet<Object>(producers.size());
            SmartList<Condition<? super VirtualFile>> exclusions = new SmartList<Condition<? super VirtualFile>>();
            for (Object library : producers) {
                Condition<VirtualFile> exclusion;
                if (librariesToIgnore.contains(library)) continue;
                if (library instanceof SyntheticLibrary && (exclusion = ((SyntheticLibrary)library).getExcludeFileCondition()) != null) {
                    exclusions.add(exclusion);
                    if (exclusion.value(root)) continue;
                }
                libraries.add(library);
            }
            if (!libraries.isEmpty()) {
                return exclusions;
            }
            return null;
        }

        private String calcPackagePrefix(@NotNull VirtualFile root, VirtualFile packageRoot) {
            String prefix;
            if (root == null) {
                RootInfo.$$$reportNull$$$0(10);
            }
            if ((prefix = this.packagePrefix.get(packageRoot)) != null && !root.equals(packageRoot)) {
                assert (packageRoot != null);
                String relative = VfsUtilCore.getRelativePath(root, packageRoot, '.');
                prefix = StringUtil.isEmpty(prefix) ? relative : prefix + '.' + relative;
            }
            return prefix;
        }

        @Nullable
        private VirtualFile findPackageRootInfo(@NotNull List<? extends VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(11);
            }
            for (VirtualFile virtualFile : hierarchy) {
                if (moduleContentRoot != null && this.sourceRootOf.get(virtualFile).contains(this.contentRootOf.get(moduleContentRoot)) && librarySourceRoot == null) {
                    return virtualFile;
                }
                if (virtualFile.equals(libraryClassRoot) || virtualFile.equals(librarySourceRoot)) {
                    return virtualFile;
                }
                if (!virtualFile.equals(moduleContentRoot) || this.sourceRootOf.containsKey(virtualFile) || librarySourceRoot != null || libraryClassRoot != null) continue;
                return null;
            }
            return null;
        }

        @NotNull
        private Set<OrderEntry> getLibraryOrderEntries(@NotNull List<? extends VirtualFile> hierarchy, @Nullable VirtualFile libraryClassRoot, @Nullable VirtualFile librarySourceRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(12);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(13);
            }
            if (libSourceRootEntries == null) {
                RootInfo.$$$reportNull$$$0(14);
            }
            LinkedHashSet<OrderEntry> orderEntries = new LinkedHashSet<OrderEntry>();
            for (VirtualFile virtualFile : hierarchy) {
                if (virtualFile.equals(libraryClassRoot) && !this.sourceRootOf.containsKey(virtualFile)) {
                    orderEntries.addAll(libClassRootEntries.get(virtualFile));
                }
                if (virtualFile.equals(librarySourceRoot) && libraryClassRoot == null) {
                    orderEntries.addAll(libSourceRootEntries.get(virtualFile));
                }
                if (!libClassRootEntries.containsKey(virtualFile) && (!this.sourceRootOf.containsKey(virtualFile) || librarySourceRoot != null)) continue;
                break;
            }
            LinkedHashSet<OrderEntry> linkedHashSet = orderEntries;
            if (linkedHashSet == null) {
                RootInfo.$$$reportNull$$$0(15);
            }
            return linkedHashSet;
        }

        @Nullable
        private ModuleSourceOrderEntry getModuleSourceEntry(@NotNull List<? extends VirtualFile> hierarchy, @NotNull VirtualFile moduleContentRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(16);
            }
            if (moduleContentRoot == null) {
                RootInfo.$$$reportNull$$$0(17);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(18);
            }
            Module module = this.contentRootOf.get(moduleContentRoot);
            for (VirtualFile virtualFile : hierarchy) {
                if (this.sourceRootOf.get(virtualFile).contains(module)) {
                    return ContainerUtil.findInstance(ModuleRootManager.getInstance(module).getOrderEntries(), ModuleSourceOrderEntry.class);
                }
                if (!libClassRootEntries.containsKey(virtualFile)) continue;
                return null;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 11: 
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hierarchy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRoot";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryRoots";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "librariesToIgnore";
                    break;
                }
                case 13: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libClassRootEntries";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libSourceRootEntries";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleContentRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllRoots";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryOrderEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestContentRoot";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isExcludedByPattern";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestContentRootForExcluded";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findLibraryRootInfo";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "findInLibraryProducers";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "calcPackagePrefix";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "findPackageRootInfo";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryOrderEntries";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleSourceEntry";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OrderEntryGraph {
        private final Project myProject;
        private final RootInfo myRootInfo;
        private final Set<VirtualFile> myAllRoots;
        private final Graph myGraph;
        private final MultiMap<VirtualFile, Node> myRoots;
        private final SynchronizedSLRUCache<VirtualFile, List<OrderEntry>> myCache;
        private final SynchronizedSLRUCache<Module, Set<String>> myDependentUnloadedModulesCache;
        private final MultiMap<VirtualFile, OrderEntry> myLibClassRootEntries;
        private final MultiMap<VirtualFile, OrderEntry> myLibSourceRootEntries;

        OrderEntryGraph(@NotNull Project project, @NotNull RootInfo rootInfo) {
            if (project == null) {
                OrderEntryGraph.$$$reportNull$$$0(0);
            }
            if (rootInfo == null) {
                OrderEntryGraph.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myRootInfo = rootInfo;
            this.myAllRoots = this.myRootInfo.getAllRoots();
            int cacheSize = Math.max(25, this.myAllRoots.size() / 100 * 2);
            this.myCache = new SynchronizedSLRUCache<VirtualFile, List<OrderEntry>>(cacheSize, cacheSize){

                @Override
                @NotNull
                public List<OrderEntry> createValue(@NotNull VirtualFile key) {
                    if (key == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List list = this.collectOrderEntries(key);
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createValue";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            int dependentUnloadedModulesCacheSize = ModuleManager.getInstance(project).getModules().length / 2;
            this.myDependentUnloadedModulesCache = new SynchronizedSLRUCache<Module, Set<String>>(dependentUnloadedModulesCacheSize, dependentUnloadedModulesCacheSize){

                @Override
                @NotNull
                public Set<String> createValue(@NotNull Module key) {
                    if (key == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Set set = this.collectDependentUnloadedModules(key);
                    if (set == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return set;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createValue";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            Pair<Graph, MultiMap<VirtualFile, Node>> pair = this.initGraphRoots();
            this.myGraph = pair.getFirst();
            this.myRoots = pair.getSecond();
            Pair<MultiMap<VirtualFile, OrderEntry>, MultiMap<VirtualFile, OrderEntry>> lpair = this.initLibraryClassSourceRoots();
            this.myLibClassRootEntries = lpair.getFirst();
            this.myLibSourceRootEntries = lpair.getSecond();
        }

        @NotNull
        private Pair<Graph, MultiMap<VirtualFile, Node>> initGraphRoots() {
            ModuleManager moduleManager = ModuleManager.getInstance(this.myProject);
            Module[] modules = moduleManager.getModules();
            Graph graph = new Graph(modules.length);
            MultiMap<VirtualFile, Node> roots = new MultiMap<VirtualFile, Node>();
            for (Module module : modules) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
                List<OrderEnumerationHandler> handlers = OrderEnumeratorBase.getCustomHandlers(module);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    ModuleOrderEntry moduleOrderEntry;
                    Module depModule;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (depModule = (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    Node node = (Node)graph.myNodes.get(depModule);
                    OrderEnumerator en = OrderEnumerator.orderEntries(depModule).exportedOnly();
                    if (node == null) {
                        VirtualFile[] importedSourceRoots;
                        VirtualFile[] importedClassRoots;
                        node = new Node(depModule);
                        graph.myNodes.put(depModule, node);
                        for (VirtualFile importedClassRoot : importedClassRoots = en.classes().usingCache().getRoots()) {
                            roots.putValue(importedClassRoot, node);
                        }
                        for (VirtualFile sourceRoot : importedSourceRoots = en.sources().usingCache().getRoots()) {
                            roots.putValue(sourceRoot, node);
                        }
                    }
                    boolean shouldRecurse = en.recursively().shouldRecurse(moduleOrderEntry, handlers);
                    node.myEdges.add(new Edge(module, moduleOrderEntry, shouldRecurse));
                }
            }
            for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
                for (String depName : description.getDependencyModuleNames()) {
                    Module depModule = moduleManager.findModuleByName(depName);
                    if (depModule == null) continue;
                    Node node = (Node)graph.myNodes.get(depModule);
                    if (node == null) {
                        node = new Node(depModule);
                        graph.myNodes.put(depModule, node);
                    }
                    if (node.myUnloadedDependentModules == null) {
                        node.myUnloadedDependentModules = new LinkedHashSet();
                    }
                    node.myUnloadedDependentModules.add(description.getName());
                }
            }
            Pair<Graph, MultiMap<VirtualFile, Node>> pair = Pair.create(graph, roots);
            if (pair == null) {
                OrderEntryGraph.$$$reportNull$$$0(2);
            }
            return pair;
        }

        @NotNull
        private Pair<MultiMap<VirtualFile, OrderEntry>, MultiMap<VirtualFile, OrderEntry>> initLibraryClassSourceRoots() {
            MultiMap<VirtualFile, OrderEntry> libClassRootEntries = new MultiMap<VirtualFile, OrderEntry>();
            MultiMap<VirtualFile, OrderEntry> libSourceRootEntries = new MultiMap<VirtualFile, OrderEntry>();
            for (Module module : ModuleManager.getInstance(this.myProject).getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                    LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                    for (VirtualFile sourceRoot : entry.getRootFiles(OrderRootType.SOURCES)) {
                        libSourceRootEntries.putValue(sourceRoot, orderEntry);
                    }
                    for (VirtualFile classRoot : entry.getRootFiles(OrderRootType.CLASSES)) {
                        libClassRootEntries.putValue(classRoot, orderEntry);
                    }
                }
            }
            Pair<MultiMap<VirtualFile, OrderEntry>, MultiMap<VirtualFile, OrderEntry>> pair = Pair.create(libClassRootEntries, libSourceRootEntries);
            if (pair == null) {
                OrderEntryGraph.$$$reportNull$$$0(3);
            }
            return pair;
        }

        @NotNull
        private List<OrderEntry> getOrderEntries(@NotNull VirtualFile file) {
            if (file == null) {
                OrderEntryGraph.$$$reportNull$$$0(4);
            }
            List<OrderEntry> list = this.myCache.get(file);
            if (list == null) {
                OrderEntryGraph.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        private List<OrderEntry> collectOrderEntries(@NotNull VirtualFile file) {
            List roots;
            if (file == null) {
                OrderEntryGraph.$$$reportNull$$$0(6);
            }
            if ((roots = RootIndex.getHierarchy(file, this.myAllRoots, this.myRootInfo)) == null) {
                List<OrderEntry> list = Collections.emptyList();
                if (list == null) {
                    OrderEntryGraph.$$$reportNull$$$0(7);
                }
                return list;
            }
            Stack<Node> stack = new Stack<Node>(roots.size());
            for (VirtualFile root : roots) {
                Collection<Node> nodes = this.myRoots.get(root);
                for (Node node : nodes) {
                    stack.push(node);
                }
            }
            HashSet<Node> seen = new HashSet<Node>(stack.size());
            ArrayList<OrderEntry> result = new ArrayList<OrderEntry>(stack.size());
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (!seen.add(node)) continue;
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    result.add(edge.myOrderEntry);
                    if (!edge.myRecursive || (targetNode = (Node)this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            Pair libraryClassRootInfo = this.myRootInfo.findLibraryRootInfo(roots, false);
            Pair librarySourceRootInfo = this.myRootInfo.findLibraryRootInfo(roots, true);
            result.addAll(this.myRootInfo.getLibraryOrderEntries(roots, (VirtualFile)Pair.getFirst(libraryClassRootInfo), (VirtualFile)Pair.getFirst(librarySourceRootInfo), this.myLibClassRootEntries, this.myLibSourceRootEntries));
            VirtualFile moduleContentRoot = this.myRootInfo.findNearestContentRoot(roots);
            if (moduleContentRoot != null) {
                ContainerUtil.addIfNotNull(result, this.myRootInfo.getModuleSourceEntry(roots, moduleContentRoot, this.myLibClassRootEntries));
            }
            result.sort(BY_OWNER_MODULE);
            ImmutableList<OrderEntry> immutableList = ContainerUtil.immutableList(result);
            if (immutableList == null) {
                OrderEntryGraph.$$$reportNull$$$0(8);
            }
            return immutableList;
        }

        @NotNull
        Set<String> getDependentUnloadedModules(@NotNull Module module) {
            if (module == null) {
                OrderEntryGraph.$$$reportNull$$$0(9);
            }
            Set<String> set = this.myDependentUnloadedModulesCache.get(module);
            if (set == null) {
                OrderEntryGraph.$$$reportNull$$$0(10);
            }
            return set;
        }

        @NotNull
        private Set<String> collectDependentUnloadedModules(@NotNull Module module) {
            Node start;
            if (module == null) {
                OrderEntryGraph.$$$reportNull$$$0(11);
            }
            if ((start = (Node)this.myGraph.myNodes.get(module)) == null) {
                Set<String> set = Collections.emptySet();
                if (set == null) {
                    OrderEntryGraph.$$$reportNull$$$0(12);
                }
                return set;
            }
            ArrayDeque<Node> stack = new ArrayDeque<Node>();
            stack.push(start);
            HashSet<Node> seen = new HashSet<Node>();
            Set<String> result = null;
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (!seen.add(node)) continue;
                if (node.myUnloadedDependentModules != null) {
                    if (result == null) {
                        result = new LinkedHashSet<String>(node.myUnloadedDependentModules);
                    } else {
                        result.addAll(node.myUnloadedDependentModules);
                    }
                }
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    if (!edge.myRecursive || (targetNode = (Node)this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            Set<String> set = result != null ? result : Collections.emptySet();
            if (set == null) {
                OrderEntryGraph.$$$reportNull$$$0(13);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootInfo";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initGraphRoots";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initLibraryClassSourceRoots";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrderEntries";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectOrderEntries";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependentUnloadedModules";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectDependentUnloadedModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrderEntries";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectOrderEntries";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependentUnloadedModules";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDependentUnloadedModules";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Graph {
            private final Map<Module, Node> myNodes;

            Graph(int moduleCount) {
                this.myNodes = new HashMap<Module, Node>(moduleCount);
            }
        }

        private static class Node {
            private final Module myKey;
            private final List<Edge> myEdges;
            private Set<String> myUnloadedDependentModules;

            private Node(@NotNull Module key) {
                if (key == null) {
                    Node.$$$reportNull$$$0(0);
                }
                this.myEdges = new ArrayList<Edge>();
                this.myKey = key;
            }

            public String toString() {
                return this.myKey.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "sqldelight/com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$Node", "<init>"));
            }
        }

        private static class Edge {
            private final Module myKey;
            private final ModuleOrderEntry myOrderEntry;
            private final boolean myRecursive;

            Edge(@NotNull Module key, @NotNull ModuleOrderEntry orderEntry, boolean recursive) {
                if (key == null) {
                    Edge.$$$reportNull$$$0(0);
                }
                if (orderEntry == null) {
                    Edge.$$$reportNull$$$0(1);
                }
                this.myKey = key;
                this.myOrderEntry = orderEntry;
                this.myRecursive = recursive;
            }

            public String toString() {
                return this.myOrderEntry.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "orderEntry";
                        break;
                    }
                }
                objectArray[1] = "sqldelight/com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$Edge";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

