/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.progress.ProgressManager;
import sqldelight.com.intellij.openapi.util.NotNullLazyValue;
import sqldelight.com.intellij.openapi.util.VolatileNotNullLazyValue;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.search.GlobalSearchScope;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.containers.MultiMap;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class PackageDirectoryCache {
    private static final Logger LOG = Logger.getInstance(PackageDirectoryCache.class);
    private final MultiMap<String, VirtualFile> myRootsByPackagePrefix;
    private final Map<String, PackageInfo> myDirectoriesByPackageNameCache;
    private final Set<String> myNonExistentPackages;

    public PackageDirectoryCache(@NotNull MultiMap<String, VirtualFile> rootsByPackagePrefix) {
        if (rootsByPackagePrefix == null) {
            PackageDirectoryCache.$$$reportNull$$$0(0);
        }
        this.myRootsByPackagePrefix = MultiMap.create();
        this.myDirectoriesByPackageNameCache = new ConcurrentHashMap<String, PackageInfo>();
        this.myNonExistentPackages = ContainerUtil.newConcurrentSet();
        for (String prefix : rootsByPackagePrefix.keySet()) {
            for (VirtualFile file : rootsByPackagePrefix.get(prefix)) {
                if (!file.isValid()) {
                    LOG.error("Invalid root: " + file);
                    continue;
                }
                this.myRootsByPackagePrefix.putValue(prefix, file);
            }
        }
    }

    void clear() {
        this.myNonExistentPackages.clear();
        this.myDirectoriesByPackageNameCache.clear();
    }

    public void onLowMemory() {
        this.myNonExistentPackages.clear();
    }

    @NotNull
    public List<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName2) {
        PackageInfo info;
        if (packageName2 == null) {
            PackageDirectoryCache.$$$reportNull$$$0(1);
        }
        List<VirtualFile> list = (info = this.getPackageInfo(packageName2)) == null ? Collections.emptyList() : Collections.unmodifiableList(info.myPackageDirectories);
        if (list == null) {
            PackageDirectoryCache.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private PackageInfo getPackageInfo(@NotNull String packageName2) {
        PackageInfo info;
        if (packageName2 == null) {
            PackageDirectoryCache.$$$reportNull$$$0(3);
        }
        if ((info = this.myDirectoriesByPackageNameCache.get(packageName2)) == null && !this.myNonExistentPackages.contains(packageName2)) {
            if (packageName2.length() > Registry.intValue("java.max.package.name.length") || StringUtil.containsAnyChar(packageName2, ";[/")) {
                return null;
            }
            SmartList<VirtualFile> result = new SmartList<VirtualFile>();
            if (StringUtil.isNotEmpty(packageName2) && !StringUtil.startsWithChar(packageName2, '.')) {
                int i = packageName2.lastIndexOf(46);
                while (true) {
                    PackageInfo parentInfo;
                    if ((parentInfo = this.getPackageInfo(i > 0 ? packageName2.substring(0, i) : "")) != null) {
                        result.addAll(parentInfo.getSubPackageDirectories(packageName2.substring(i + 1)));
                    }
                    if (i < 0) break;
                    i = packageName2.lastIndexOf(46, i - 1);
                    ProgressManager.checkCanceled();
                }
            }
            for (VirtualFile file : this.myRootsByPackagePrefix.get(packageName2)) {
                if (!file.isDirectory() || !file.isValid()) continue;
                result.add(file);
            }
            if (!result.isEmpty()) {
                info = new PackageInfo(packageName2, result);
                this.myDirectoriesByPackageNameCache.put(packageName2, info);
            } else {
                this.myNonExistentPackages.add(packageName2);
            }
        }
        return info;
    }

    @NotNull
    public Set<String> getSubpackageNames(@NotNull String packageName2) {
        PackageInfo info;
        if (packageName2 == null) {
            PackageDirectoryCache.$$$reportNull$$$0(4);
        }
        Set<String> set = (info = this.getPackageInfo(packageName2)) == null ? Collections.emptySet() : Collections.unmodifiableSet(info.mySubPackages.getValue().keySet());
        if (set == null) {
            PackageDirectoryCache.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Set<String> getSubpackageNames(@NotNull String packageName2, @NotNull GlobalSearchScope scope) {
        PackageInfo info;
        if (packageName2 == null) {
            PackageDirectoryCache.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            PackageDirectoryCache.$$$reportNull$$$0(7);
        }
        if ((info = this.getPackageInfo(packageName2)) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PackageDirectoryCache.$$$reportNull$$$0(8);
            }
            return set;
        }
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, Collection<VirtualFile>> entry : info.mySubPackages.getValue().entrySet()) {
            String shortName = entry.getKey();
            Collection<VirtualFile> directories2 = entry.getValue();
            if (!ContainerUtil.exists(directories2, scope::contains)) continue;
            result.add(shortName);
        }
        Set<String> set = Collections.unmodifiableSet(result);
        if (set == null) {
            PackageDirectoryCache.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public static PackageDirectoryCache createCache(@NotNull List<? extends VirtualFile> roots) {
        if (roots == null) {
            PackageDirectoryCache.$$$reportNull$$$0(10);
        }
        MultiMap<String, VirtualFile> map = MultiMap.create();
        map.putValues("", roots);
        return new PackageDirectoryCache(map);
    }

    protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName2) {
        if (dir == null) {
            PackageDirectoryCache.$$$reportNull$$$0(11);
        }
        if (packageName2 == null) {
            PackageDirectoryCache.$$$reportNull$$$0(12);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsByPackagePrefix";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/PackageDirectoryCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/PackageDirectoryCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubpackageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageInfo";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSubpackageNames";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCache";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PackageInfo {
        @NotNull
        final String myQname;
        @NotNull
        final List<? extends VirtualFile> myPackageDirectories;
        final NotNullLazyValue<MultiMap<String, VirtualFile>> mySubPackages;

        PackageInfo(@NotNull String qname, List<? extends VirtualFile> packageDirectories) {
            if (qname == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            if (packageDirectories == null) {
                PackageInfo.$$$reportNull$$$0(1);
            }
            this.mySubPackages = new VolatileNotNullLazyValue<MultiMap<String, VirtualFile>>(){

                @Override
                @NotNull
                protected MultiMap<String, VirtualFile> compute() {
                    MultiMap<String, VirtualFile> result = MultiMap.createLinked();
                    for (VirtualFile virtualFile : PackageInfo.this.myPackageDirectories) {
                        ProgressManager.checkCanceled();
                        for (VirtualFile child : virtualFile.getChildren()) {
                            String packageName2;
                            String childName = child.getName();
                            String string = packageName2 = PackageInfo.this.myQname.isEmpty() ? childName : PackageInfo.this.myQname + "." + childName;
                            if (!child.isDirectory() || !PackageDirectoryCache.this.isPackageDirectory(child, packageName2)) continue;
                            result.putValue(childName, child);
                        }
                    }
                    MultiMap<String, VirtualFile> multiMap = result;
                    if (multiMap == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return multiMap;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo$1", "compute"));
                }
            };
            this.myQname = qname;
            this.myPackageDirectories = packageDirectories;
        }

        @NotNull
        Collection<VirtualFile> getSubPackageDirectories(String shortName) {
            Collection<VirtualFile> collection = this.mySubPackages.getValue().get(shortName);
            if (collection == null) {
                PackageInfo.$$$reportNull$$$0(2);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qname";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageDirectories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubPackageDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

