/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.ProjectTopics;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.fileTypes.FileTypeRegistry;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.progress.ProgressManager;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.roots.ModuleRootEvent;
import sqldelight.com.intellij.openapi.roots.ModuleRootListener;
import sqldelight.com.intellij.openapi.roots.OrderEntry;
import sqldelight.com.intellij.openapi.roots.SourceFolder;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryIndex;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryInfo;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import sqldelight.com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import sqldelight.com.intellij.openapi.roots.impl.RootIndex;
import sqldelight.com.intellij.openapi.util.LowMemoryWatcher;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileManager;
import sqldelight.com.intellij.openapi.vfs.VirtualFileWithId;
import sqldelight.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import sqldelight.com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import sqldelight.com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import sqldelight.com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import sqldelight.com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import sqldelight.com.intellij.util.Query;
import sqldelight.com.intellij.util.messages.MessageBusConnection;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public final class DirectoryIndexImpl
extends DirectoryIndex
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DirectoryIndexImpl.class);
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private volatile boolean myDisposed;
    private volatile RootIndex myRootIndex;

    public DirectoryIndexImpl(@NotNull Project project) {
        if (project == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConnection = project.getMessageBus().connect();
        this.subscribeToFileChanges();
        LowMemoryWatcher.register(() -> {
            RootIndex index = this.myRootIndex;
            if (index != null) {
                index.onLowMemory();
            }
        }, this);
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
        this.myRootIndex = null;
    }

    private void subscribeToFileChanges() {
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, new ModuleRootListener(){

            @Override
            public void beforeRootsChange(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                DirectoryIndexImpl.this.myRootIndex = null;
            }

            @Override
            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                DirectoryIndexImpl.this.myRootIndex = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/DirectoryIndexImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRootsChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rootsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                RootIndex rootIndex;
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((rootIndex = DirectoryIndexImpl.this.myRootIndex) != null && DirectoryIndexImpl.shouldResetOnEvents(events)) {
                    rootIndex.myPackageDirectoryCache.clear();
                    for (VFileEvent vFileEvent : events) {
                        if (!DirectoryIndexImpl.isIgnoredFileCreated(vFileEvent)) continue;
                        DirectoryIndexImpl.this.myRootIndex = null;
                        break;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "sqldelight/com/intellij/openapi/roots/impl/DirectoryIndexImpl$2", "after"));
            }
        });
    }

    private static boolean shouldResetOnEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(1);
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file;
            if (!(vFileEvent instanceof VFileCreateEvent ? ((VFileCreateEvent)vFileEvent).isDirectory() : (file = vFileEvent.getFile()) == null || file.isDirectory())) continue;
            return true;
        }
        return false;
    }

    private static boolean isIgnoredFileCreated(@NotNull VFileEvent event) {
        if (event == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(2);
        }
        return event instanceof VFileMoveEvent && FileTypeRegistry.getInstance().isFileIgnored(((VFileMoveEvent)event).getNewParent()) || event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name") && FileTypeRegistry.getInstance().isFileIgnored(((VFilePropertyChangeEvent)event).getFile());
    }

    private void dispatchPendingEvents() {
        this.myConnection.deliverImmediately();
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName2, boolean includeLibrarySources) {
        if (packageName2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(3);
        }
        Query<VirtualFile> query = this.getRootIndex().getDirectoriesByPackageName(packageName2, includeLibrarySources);
        if (query == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(4);
        }
        return query;
    }

    @NotNull
    RootIndex getRootIndex() {
        RootIndex rootIndex = this.myRootIndex;
        if (rootIndex == null) {
            this.myRootIndex = rootIndex = new RootIndex(this.myProject);
        }
        RootIndex rootIndex2 = rootIndex;
        if (rootIndex2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(5);
        }
        return rootIndex2;
    }

    @Override
    @NotNull
    public DirectoryInfo getInfoForFile(@NotNull VirtualFile file) {
        if (file == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(6);
        }
        this.checkAvailability();
        this.dispatchPendingEvents();
        if (!(file instanceof VirtualFileWithId)) {
            NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.NOT_SUPPORTED_VIRTUAL_FILE_IMPLEMENTATION;
            if (nonProjectDirectoryInfo == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(7);
            }
            return nonProjectDirectoryInfo;
        }
        DirectoryInfo directoryInfo = this.getRootIndex().getInfoForFile(file);
        if (directoryInfo == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(8);
        }
        return directoryInfo;
    }

    @Override
    @Nullable
    public SourceFolder getSourceRootFolder(@NotNull DirectoryInfo info) {
        boolean inModuleSource;
        if (info == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(9);
        }
        boolean bl = inModuleSource = info instanceof DirectoryInfoImpl && ((DirectoryInfoImpl)info).isInModuleSource();
        if (inModuleSource) {
            return info.getSourceRootFolder();
        }
        return null;
    }

    @Override
    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo info) {
        SourceFolder folder;
        if (info == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(10);
        }
        return (folder = this.getSourceRootFolder(info)) == null ? null : folder.getRootType();
    }

    @Override
    public String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(11);
        }
        this.checkAvailability();
        if (!(dir instanceof VirtualFileWithId)) {
            return null;
        }
        return this.getRootIndex().getPackageName(dir);
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        if (info == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(12);
        }
        this.checkAvailability();
        if (this.myProject.isDefault()) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<OrderEntry> list = this.getRootIndex().getOrderEntries(info);
        if (list == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public Set<String> getDependentUnloadedModules(@NotNull Module module) {
        if (module == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(15);
        }
        this.checkAvailability();
        Set<String> set = this.getRootIndex().getDependentUnloadedModules(module);
        if (set == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(16);
        }
        return set;
    }

    public void assertConsistency(DirectoryInfo info) {
        List<OrderEntry> entries = this.getOrderEntries(info);
        for (int i = 1; i < entries.size(); ++i) {
            assert (RootIndex.BY_OWNER_MODULE.compare(entries.get(i - 1), entries.get(i)) <= 0);
        }
    }

    private void checkAvailability() {
        if (this.myDisposed) {
            ProgressManager.checkCanceled();
            LOG.error("Directory index is already disposed for " + this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/DirectoryIndexImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/DirectoryIndexImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootIndex";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldResetOnEvents";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFileCreated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootFolder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDependentUnloadedModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

