/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.module.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import sqldelight.com.intellij.ProjectTopics;
import sqldelight.com.intellij.configurationStore.StateStorageManagerKt;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.application.Application;
import sqldelight.com.intellij.openapi.application.ApplicationInfo;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.application.ReadAction;
import sqldelight.com.intellij.openapi.components.PersistentStateComponent;
import sqldelight.com.intellij.openapi.components.ProjectComponent;
import sqldelight.com.intellij.openapi.components.impl.stores.IComponentStore;
import sqldelight.com.intellij.openapi.components.impl.stores.ModuleStore;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.module.ModifiableModuleModel;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.module.ModuleDescription;
import sqldelight.com.intellij.openapi.module.ModuleGrouper;
import sqldelight.com.intellij.openapi.module.ModuleManager;
import sqldelight.com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import sqldelight.com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import sqldelight.com.intellij.openapi.module.UnloadedModuleDescription;
import sqldelight.com.intellij.openapi.module.impl.ExternalModuleListStorage;
import sqldelight.com.intellij.openapi.module.impl.ExternalModuleListStorageKt;
import sqldelight.com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import sqldelight.com.intellij.openapi.module.impl.ModuleEx;
import sqldelight.com.intellij.openapi.module.impl.ModuleGroupersKt;
import sqldelight.com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import sqldelight.com.intellij.openapi.module.impl.ModuleManagerEx;
import sqldelight.com.intellij.openapi.module.impl.ModulePath;
import sqldelight.com.intellij.openapi.module.impl.ModulePathSaveItem;
import sqldelight.com.intellij.openapi.module.impl.SaveItem;
import sqldelight.com.intellij.openapi.module.impl.UnloadedModuleDescriptionImpl;
import sqldelight.com.intellij.openapi.module.impl.UnloadedModulesListStorage;
import sqldelight.com.intellij.openapi.progress.EmptyProgressIndicator;
import sqldelight.com.intellij.openapi.progress.ProcessCanceledException;
import sqldelight.com.intellij.openapi.progress.ProgressIndicator;
import sqldelight.com.intellij.openapi.progress.ProgressIndicatorProvider;
import sqldelight.com.intellij.openapi.progress.ProgressManager;
import sqldelight.com.intellij.openapi.progress.util.ProgressWrapper;
import sqldelight.com.intellij.openapi.project.ModuleListener;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.roots.ModuleRootManager;
import sqldelight.com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import sqldelight.com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import sqldelight.com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import sqldelight.com.intellij.openapi.util.Comparing;
import sqldelight.com.intellij.openapi.util.Disposer;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.util.Pair;
import sqldelight.com.intellij.openapi.util.SystemInfo;
import sqldelight.com.intellij.openapi.util.io.FileUtil;
import sqldelight.com.intellij.openapi.util.io.FileUtilRt;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.openapi.vfs.StandardFileSystems;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileManager;
import sqldelight.com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import sqldelight.com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import sqldelight.com.intellij.projectModel.ProjectModelBundle;
import sqldelight.com.intellij.util.ConcurrencyUtil;
import sqldelight.com.intellij.util.ObjectUtils;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.com.intellij.util.concurrency.AppExecutorUtil;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.containers.Interner;
import sqldelight.com.intellij.util.graph.CachingSemiGraph;
import sqldelight.com.intellij.util.graph.DFSTBuilder;
import sqldelight.com.intellij.util.graph.Graph;
import sqldelight.com.intellij.util.graph.GraphGenerator;
import sqldelight.com.intellij.util.graph.InboundSemiGraph;
import sqldelight.it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import sqldelight.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import sqldelight.it.unimi.dsi.fastutil.objects.ObjectArrays;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.annotations.SystemIndependent;

@ApiStatus.Internal
public abstract class ModuleManagerImpl
extends ModuleManagerEx
implements Disposable,
PersistentStateComponent<Element>,
ProjectComponent {
    private static final Logger LOG = Logger.getInstance(ModuleManagerImpl.class);
    private static final Key<String> DISPOSED_MODULE_NAME = Key.create("DisposedNeverAddedModuleName");
    protected final Project myProject;
    private final ProjectRootManagerEx myProjectRootManager;
    protected volatile ModuleModelImpl myModuleModel;
    private Set<ModulePath> myModulePathsToLoad;
    private final Set<ModulePath> myFailedModulePaths;
    private final Map<String, UnloadedModuleDescriptionImpl> myUnloadedModules;
    private boolean myModulesLoaded;
    private double myProgressStep;
    private volatile Module[] myCachedSortedModules;
    private volatile Graph<Module> myCachedModuleProductionGraph;
    private volatile Graph<Module> myCachedModuleTestGraph;
    private volatile Comparator<Module> myCachedModuleComparator;

    public static ModuleManagerImpl getInstanceImpl(Project project) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance(project);
    }

    public ModuleManagerImpl(@NotNull Project project) {
        if (project == null) {
            ModuleManagerImpl.$$$reportNull$$$0(0);
        }
        this.myModuleModel = new ModuleModelImpl(this);
        this.myFailedModulePaths = new HashSet<ModulePath>();
        this.myUnloadedModules = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>();
        this.myProject = project;
        this.myProjectRootManager = ProjectRootManagerEx.getInstanceEx(project);
    }

    @Override
    public void projectOpened() {
        this.fireModulesAdded();
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectOpened();
        }
    }

    @Override
    public void projectClosed() {
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectClosed();
        }
    }

    protected void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
        this.myCachedModuleProductionGraph = null;
        this.myCachedModuleTestGraph = null;
    }

    @Override
    public void dispose() {
        this.myModuleModel.disposeModel();
        this.myProjectRootManager.assertListenersAreDisposed();
    }

    @Override
    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e, ExternalModuleListStorageKt.getFilteredModuleList(this.myProject, this.getModules(), false));
        return e;
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            ModuleManagerImpl.$$$reportNull$$$0(1);
        }
        Set<ModulePath> files = ModuleManagerImpl.getPathsToModuleFiles(state);
        Set<ModulePath> externalModules = this.myProject.getComponent(ExternalModuleListStorage.class).getExternalModules();
        if (externalModules != null) {
            files.addAll(externalModules);
        }
        this.loadState(files);
    }

    @Override
    public void noStateLoaded() {
        Set<ModulePath> externalModules = this.myProject.getComponent(ExternalModuleListStorage.class).getExternalModules();
        if (externalModules != null) {
            this.loadState((Set<ModulePath>)new LinkedHashSet<ModulePath>(externalModules));
        }
    }

    @Override
    private void loadState(@NotNull Set<ModulePath> modulePaths) {
        if (modulePaths == null) {
            ModuleManagerImpl.$$$reportNull$$$0(2);
        }
        boolean isFirstLoadState = this.myModulePathsToLoad == null;
        this.myModulePathsToLoad = modulePaths;
        HashSet<String> unloadedModuleNames = new HashSet<String>(UnloadedModulesListStorage.getInstance(this.myProject).getUnloadedModuleNames());
        Iterator<ModulePath> iterator = this.myModulePathsToLoad.iterator();
        ArrayList<ModulePath> unloadedModulePaths = new ArrayList<ModulePath>();
        while (iterator.hasNext()) {
            ModulePath modulePath = iterator.next();
            if (!unloadedModuleNames.contains(modulePath.getModuleName())) continue;
            unloadedModulePaths.add(modulePath);
            iterator.remove();
        }
        ArrayList<UnloadedModuleDescriptionImpl> unloaded = new ArrayList<UnloadedModuleDescriptionImpl>(UnloadedModuleDescriptionImpl.createFromPaths(unloadedModulePaths, this));
        if (!unloaded.isEmpty()) {
            this.unloadNewlyAddedModulesIfPossible(this.myModulePathsToLoad, unloaded);
        }
        this.myUnloadedModules.clear();
        for (UnloadedModuleDescriptionImpl description : unloaded) {
            this.myUnloadedModules.put(description.getName(), description);
        }
        if (isFirstLoadState) {
            return;
        }
        ModifiableModuleModel model = this.getModifiableModel();
        Module[] existingModules = model.getModules();
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        Object2ObjectOpenHashMap<String, ModulePath> modulePathMap = new Object2ObjectOpenHashMap<String, ModulePath>(this.myModulePathsToLoad.size());
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            modulePathMap.put(modulePath.getPath(), modulePath);
        }
        for (Module existingModule : existingModules) {
            Object[] group;
            ModulePath correspondingPath = (ModulePath)modulePathMap.remove(existingModule.getModuleFilePath());
            if (correspondingPath == null) {
                model.disposeModule(existingModule);
                continue;
            }
            this.myModulePathsToLoad.remove(correspondingPath);
            String groupStr = correspondingPath.getGroup();
            Object[] objectArray = group = groupStr == null ? null : groupStr.split("/");
            if (Arrays.equals(group, model.getModuleGroupPath(existingModule))) continue;
            groupInterner.setModuleGroupPath(model, existingModule, (String[])group);
        }
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(model::commit);
        this.myModulePathsToLoad.clear();
    }

    protected void unloadNewlyAddedModulesIfPossible(@NotNull Set<ModulePath> modulesToLoad, @NotNull List<UnloadedModuleDescriptionImpl> modulesToUnload) {
        if (modulesToLoad == null) {
            ModuleManagerImpl.$$$reportNull$$$0(3);
        }
        if (modulesToUnload == null) {
            ModuleManagerImpl.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    public static Set<ModulePath> getPathsToModuleFiles(@NotNull Element element) {
        if (element == null) {
            ModuleManagerImpl.$$$reportNull$$$0(5);
        }
        LinkedHashSet<ModulePath> paths = new LinkedHashSet<ModulePath>();
        Element modules = element.getChild("modules");
        if (modules != null) {
            for (Element moduleElement : modules.getChildren("module")) {
                String fileUrlValue = moduleElement.getAttributeValue("fileurl");
                String filepath = fileUrlValue == null ? moduleElement.getAttributeValue("filepath") : VirtualFileManager.extractPath(fileUrlValue);
                paths.add(new ModulePath(FileUtilRt.toSystemIndependentName(Objects.requireNonNull(filepath)), moduleElement.getAttributeValue("group")));
            }
        }
        LinkedHashSet<ModulePath> linkedHashSet = paths;
        if (linkedHashSet == null) {
            ModuleManagerImpl.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    protected void loadModules(@NotNull ModuleModelImpl moduleModel) {
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(7);
        }
        this.myFailedModulePaths.clear();
        if (this.myModulePathsToLoad == null || this.myModulePathsToLoad.isEmpty()) {
            this.myModulesLoaded = true;
            return;
        }
        this.myFailedModulePaths.addAll(this.myModulePathsToLoad);
        ProgressIndicator globalIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        ProgressIndicator progressIndicator = this.myProject.isDefault() || globalIndicator == null ? new EmptyProgressIndicator() : globalIndicator;
        progressIndicator.setText(ProjectModelBundle.message("progress.text.loading.modules", new Object[0]));
        progressIndicator.setText2("");
        List errors = Collections.synchronizedList(new ArrayList());
        boolean isParallel = Registry.is("parallel.modules.loading") && !ApplicationManager.getApplication().isDispatchThread();
        ExecutorService service = isParallel ? AppExecutorUtil.createBoundedApplicationPoolExecutor("ModuleManager Loader", Math.min(2, Runtime.getRuntime().availableProcessors())) : ConcurrencyUtil.newSameThreadExecutorService();
        ArrayList<Pair<Future<Module>, ModulePath>> tasks = new ArrayList<Pair<Future<Module>, ModulePath>>();
        HashSet<String> paths = new HashSet<String>(this.myModulePathsToLoad.size());
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            if (progressIndicator.isCanceled()) break;
            String path = modulePath.getPath();
            if (!paths.add(path)) continue;
            tasks.add(new Pair<Future<Module>, ModulePath>(service.submit(() -> {
                progressIndicator.setFraction(progressIndicator.getFraction() + this.myProgressStep);
                return ProgressManager.getInstance().runProcess(() -> {
                    try {
                        return this.myProject.isDisposed() ? null : ModuleManagerImpl.loadModuleInternal(Paths.get(path, new String[0]), this);
                    }
                    catch (IOException e) {
                        this.reportError(errors, modulePath, e);
                    }
                    catch (ProcessCanceledException e) {
                    }
                    catch (Exception e) {
                        LOG.error(e);
                    }
                    return null;
                }, (ProgressIndicator)ProgressWrapper.wrap(progressIndicator));
            }), modulePath));
        }
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        SmartList<Module> modulesWithUnknownTypes = new SmartList<Module>();
        for (Pair pair : tasks) {
            if (progressIndicator.isCanceled()) break;
            try {
                ModulePath modulePath;
                String groupPathString;
                Module module = (Module)((Future)pair.first).get();
                if (module == null) continue;
                moduleModel.addModule(module);
                if (this.isUnknownModuleType(module)) {
                    modulesWithUnknownTypes.add(module);
                }
                if ((groupPathString = (modulePath = (ModulePath)pair.second).getGroup()) != null) {
                    groupInterner.setModuleGroupPath(moduleModel, module, groupPathString.split("/"));
                }
                this.myFailedModulePaths.remove(modulePath);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        service.shutdown();
        progressIndicator.checkCanceled();
        this.myModulesLoaded = true;
        Application app = ApplicationManager.getApplication();
        if (app.isInternal() || app.isEAP() || ApplicationInfo.getInstance().getBuild().isSnapshot()) {
            Object2ObjectOpenHashMap<String, Module> object2ObjectOpenHashMap = new Object2ObjectOpenHashMap<String, Module>();
            for (Module module : moduleModel.getModules()) {
                for (String url : ModuleRootManager.getInstance(module).getContentRootUrls()) {
                    Module oldModule = object2ObjectOpenHashMap.put(url, module);
                    if (oldModule == null) continue;
                    LOG.warn("Module '" + module.getName() + "' and module '" + oldModule.getName() + "' have the same content root: " + url);
                }
            }
        }
        this.onModuleLoadErrors(moduleModel, errors);
        this.showUnknownModuleTypeNotification(modulesWithUnknownTypes);
    }

    @NotNull
    private static Module loadModuleInternal(@NotNull Path filePath, @NotNull ModuleManagerImpl manager) throws IOException {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            ModuleManagerImpl.$$$reportNull$$$0(9);
        }
        String systemIndependentPath = filePath.toString().replace(File.separatorChar, '/');
        VirtualFile virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(systemIndependentPath);
        if (virtualFile != null) {
            virtualFile.setCharset(StandardCharsets.UTF_8, null, false);
        }
        Module module = ReadAction.compute(() -> {
            ModuleEx module = manager.createAndLoadModule(systemIndependentPath);
            ModuleManagerImpl.initModule(module, () -> ((ModuleStore)module.getService(IComponentStore.class)).setPath(filePath, virtualFile, false));
            return module;
        });
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(10);
        }
        return module;
    }

    private static void initModule(@NotNull ModuleEx module, @NotNull Runnable beforeComponentCreation) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(11);
        }
        if (beforeComponentCreation == null) {
            ModuleManagerImpl.$$$reportNull$$$0(12);
        }
        try {
            module.init(beforeComponentCreation);
        }
        catch (Throwable e) {
            ModuleManagerImpl.disposeModuleLater(module);
            throw e;
        }
    }

    private void reportError(@NotNull List<? super ModuleLoadingErrorDescription> errors, @NotNull ModulePath modulePath, @NotNull Exception e) {
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(13);
        }
        if (modulePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(14);
        }
        if (e == null) {
            ModuleManagerImpl.$$$reportNull$$$0(15);
        }
        errors.add(new ModuleLoadingErrorDescription(ProjectModelBundle.message("module.cannot.load.error", modulePath.getPath(), e.getMessage()), modulePath, this));
    }

    public int getModulePathsCount() {
        return this.myModulePathsToLoad == null ? 0 : this.myModulePathsToLoad.size();
    }

    public boolean areModulesLoaded() {
        return this.myModulesLoaded;
    }

    public void setProgressStep(double step) {
        this.myProgressStep = step;
    }

    protected boolean isUnknownModuleType(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(16);
        }
        return false;
    }

    protected void showUnknownModuleTypeNotification(@NotNull List<? extends Module> types) {
        if (types == null) {
            ModuleManagerImpl.$$$reportNull$$$0(17);
        }
    }

    protected void fireModuleRemoved(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(18);
        }
        this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES).moduleRemoved(this.myProject, module);
    }

    protected void fireBeforeModuleRemoved(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(19);
        }
        this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES).beforeModuleRemoved(this.myProject, module);
    }

    protected void fireModulesRenamed(@NotNull List<Module> modules, @NotNull Map<Module, String> oldNames) {
        if (modules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(20);
        }
        if (oldNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(21);
        }
        if (modules.isEmpty()) {
            return;
        }
        try {
            for (Module module : this.getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
                if (!(moduleRootManager instanceof ModuleRootManagerImpl)) continue;
                ((ModuleRootManagerImpl)moduleRootManager).stateChanged();
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
        this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES).modulesRenamed(this.myProject, modules, oldNames::get);
    }

    private void onModuleLoadErrors(@NotNull ModuleModelImpl moduleModel, @NotNull List<? extends ModuleLoadingErrorDescription> errors) {
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(22);
        }
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(23);
        }
        if (errors.isEmpty()) {
            return;
        }
        ModuleModelImpl.access$502(moduleModel, null);
        for (ModuleLoadingErrorDescription moduleLoadingErrorDescription : errors) {
            ModuleEx module = moduleModel.getModuleByFilePath(moduleLoadingErrorDescription.getModulePath().getPath());
            if (module == null) continue;
            moduleModel.myModules.remove(module.getName());
            ModuleManagerImpl.disposeModuleLater(module);
        }
        this.fireModuleLoadErrors(errors);
    }

    private static void disposeModuleLater(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose(module), module.getDisposed());
    }

    protected void fireModuleLoadErrors(@NotNull List<? extends ModuleLoadingErrorDescription> errors) {
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(25);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    void removeFailedModulePath(@NotNull ModulePath modulePath) {
        if (modulePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(26);
        }
        this.myFailedModulePaths.remove(modulePath);
        this.incModificationCount();
    }

    @Override
    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new ModuleModelImpl(this.myModuleModel);
    }

    public void writeExternal(@NotNull Element element, @NotNull List<? extends Module> collection) {
        if (element == null) {
            ModuleManagerImpl.$$$reportNull$$$0(27);
        }
        if (collection == null) {
            ModuleManagerImpl.$$$reportNull$$$0(28);
        }
        ModuleManagerImpl.writeExternal(element, collection, this);
    }

    @ApiStatus.Internal
    public static void writeExternal(@NotNull Element element, @NotNull List<? extends Module> collection, ModuleManagerEx moduleManager) {
        if (element == null) {
            ModuleManagerImpl.$$$reportNull$$$0(29);
        }
        if (collection == null) {
            ModuleManagerImpl.$$$reportNull$$$0(30);
        }
        Collection<ModulePath> failedModulePaths = moduleManager.getFailedModulePaths();
        Collection<UnloadedModuleDescription> unloadedModuleDescriptions = moduleManager.getUnloadedModuleDescriptions();
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.size() + failedModulePaths.size() + unloadedModuleDescriptions.size());
        for (Module module : collection) {
            sorted.add(new ModuleSaveItem(module, moduleManager));
        }
        for (ModulePath modulePath : failedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        for (UnloadedModuleDescription unloadedModuleDescription : unloadedModuleDescriptions) {
            sorted.add(new ModulePathSaveItem(((UnloadedModuleDescriptionImpl)unloadedModuleDescription).getModulePath()));
        }
        if (!sorted.isEmpty()) {
            sorted.sort(Comparator.comparing(SaveItem::getModuleName));
            Element modules = new Element("modules");
            for (SaveItem saveItem : sorted) {
                saveItem.writeExternal(modules);
            }
            element.addContent(modules);
        }
    }

    @Override
    @NotNull
    public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId) {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(31);
        }
        if (moduleTypeId == null) {
            ModuleManagerImpl.$$$reportNull$$$0(32);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(33);
        }
        return module2;
    }

    @Override
    @NotNull
    public Module newNonPersistentModule(@NotNull String moduleName, @NotNull String id) {
        if (moduleName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(34);
        }
        if (id == null) {
            ModuleManagerImpl.$$$reportNull$$$0(35);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newNonPersistentModule(moduleName, id);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(36);
        }
        return module2;
    }

    @Override
    @NotNull
    public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(37);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(38);
        }
        return module2;
    }

    @Override
    public void disposeModule(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(39);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableModuleModel modifiableModel = this.getModifiableModel();
            modifiableModel.disposeModule(module);
            modifiableModel.commit();
        });
    }

    @Override
    public Module @NotNull [] getModules() {
        ModuleModelImpl model = this.myModuleModel;
        if (model.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        Module[] moduleArray = model.getModules();
        if (moduleArray == null) {
            ModuleManagerImpl.$$$reportNull$$$0(40);
        }
        return moduleArray;
    }

    @Override
    public Module @NotNull [] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        Module[] sortedModules = this.myCachedSortedModules;
        if (sortedModules == null) {
            sortedModules = this.myModuleModel.getSortedModules();
            this.myCachedSortedModules = sortedModules;
        }
        if (sortedModules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(41);
        }
        return sortedModules;
    }

    @Override
    public Module findModuleByName(@NotNull String name) {
        if (name == null) {
            ModuleManagerImpl.$$$reportNull$$$0(42);
        }
        return this.myModuleModel.findModuleByName(name);
    }

    @Override
    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        Comparator cachedModuleComparator = this.myCachedModuleComparator;
        if (cachedModuleComparator == null) {
            this.myCachedModuleComparator = cachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        Comparator comparator = cachedModuleComparator;
        if (comparator == null) {
            ModuleManagerImpl.$$$reportNull$$$0(43);
        }
        return comparator;
    }

    protected void deliverPendingEvents() {
    }

    @Override
    @NotNull
    public Graph<Module> moduleGraph() {
        Graph<Module> graph = this.moduleGraph(true);
        if (graph == null) {
            ModuleManagerImpl.$$$reportNull$$$0(44);
        }
        return graph;
    }

    @Override
    @NotNull
    public Graph<Module> moduleGraph(boolean includeTests) {
        Graph<Object> graph;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph<Object> graph2 = graph = includeTests ? this.myCachedModuleTestGraph : this.myCachedModuleProductionGraph;
        if (graph != null) {
            Graph<Object> graph3 = graph;
            if (graph3 == null) {
                ModuleManagerImpl.$$$reportNull$$$0(45);
            }
            return graph3;
        }
        graph = this.myModuleModel.moduleGraph(includeTests);
        if (includeTests) {
            this.myCachedModuleTestGraph = graph;
        } else {
            this.myCachedModuleProductionGraph = graph;
        }
        Graph<Object> graph4 = graph;
        if (graph4 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(46);
        }
        return graph4;
    }

    @Override
    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(47);
        }
        SmartList<Module> result = new SmartList<Module>();
        for (Module aModule : this.getModules()) {
            if (!ModuleManagerImpl.isModuleDependsOn(aModule, module)) continue;
            result.add(aModule);
        }
        SmartList<Module> smartList = result;
        if (smartList == null) {
            ModuleManagerImpl.$$$reportNull$$$0(48);
        }
        return smartList;
    }

    @Override
    public boolean isModuleDependent(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(49);
        }
        if (onModule == null) {
            ModuleManagerImpl.$$$reportNull$$$0(50);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return ModuleManagerImpl.isModuleDependsOn(module, onModule);
    }

    private static boolean isModuleDependsOn(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(51);
        }
        if (onModule == null) {
            ModuleManagerImpl.$$$reportNull$$$0(52);
        }
        return ModuleRootManager.getInstance(module).isDependsOn(onModule);
    }

    protected void fireModulesAdded() {
        for (Module module : this.myModuleModel.getModules()) {
            this.fireModuleAddedInWriteAction((ModuleEx)module);
        }
    }

    protected void fireModuleAddedInWriteAction(@NotNull ModuleEx module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(53);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!module.isLoaded()) {
                module.moduleAdded();
                this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES).moduleAdded(this.myProject, module);
            }
        });
    }

    public static void commitModelWithRunnable(@NotNull ModifiableModuleModel model, @NotNull Runnable runnable) {
        if (model == null) {
            ModuleManagerImpl.$$$reportNull$$$0(54);
        }
        if (runnable == null) {
            ModuleManagerImpl.$$$reportNull$$$0(55);
        }
        ((ModuleModelImpl)model).commitWithRunnable(runnable);
    }

    @NotNull
    protected abstract ModuleEx createModule(@NotNull String var1);

    protected ModuleEx createNonPersistentModule(@NotNull String name) {
        if (name == null) {
            ModuleManagerImpl.$$$reportNull$$$0(56);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected abstract ModuleEx createAndLoadModule(@NotNull String var1) throws IOException;

    private void commitModel(@NotNull ModuleModelImpl moduleModel, @NotNull Runnable runnable) {
        Collection<Object> removedModules;
        Collection<Module> addedModules;
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(57);
        }
        if (runnable == null) {
            ModuleManagerImpl.$$$reportNull$$$0(58);
        }
        ModuleModelImpl.access$502(this.myModuleModel, null);
        this.incModificationCount();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<Module> oldModules = Arrays.asList(this.myModuleModel.getModules());
        List<Module> newModules = Arrays.asList(moduleModel.getModules());
        if (oldModules.isEmpty()) {
            addedModules = newModules;
            removedModules = Collections.emptyList();
        } else {
            addedModules = new HashSet<Module>(newModules);
            addedModules.removeAll(oldModules);
            removedModules = new HashSet<Module>(oldModules);
            removedModules.removeAll(newModules);
        }
        this.myProjectRootManager.makeRootsChange(() -> {
            for (Object removedModule : removedModules) {
                this.fireBeforeModuleRemoved((Module)removedModule);
                this.cleanCachedStuff();
            }
            if (!moduleModel.myModulesToDispose.isEmpty()) {
                ArrayList neverAddedModules = new ArrayList(moduleModel.myModulesToDispose);
                neverAddedModules.removeAll(oldModules);
                for (Module neverAddedModule : neverAddedModules) {
                    neverAddedModule.putUserData(DISPOSED_MODULE_NAME, neverAddedModule.getName());
                    Disposer.dispose(neverAddedModule);
                }
            }
            runnable.run();
            Map modulesToNewNamesMap = moduleModel.myModuleToNewName;
            Set modulesToBeRenamed = modulesToNewNamesMap.keySet();
            modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
            ArrayList<Module> modules = new ArrayList<Module>();
            HashMap<Module, String> oldNames = new HashMap<Module, String>();
            for (Object module : modulesToBeRenamed) {
                oldNames.put((Module)module, module.getName());
                moduleModel.myModules.remove(module.getName());
                modules.add((Module)module);
                ((ModuleEx)module).rename((String)modulesToNewNamesMap.get(module), true);
                moduleModel.myModules.put(module.getName(), (Module)module);
                this.myUnloadedModules.remove(module.getName());
            }
            moduleModel.myIsWritable = false;
            this.myModuleModel = moduleModel;
            for (Object module : removedModules) {
                this.fireModuleRemoved((Module)module);
                this.cleanCachedStuff();
                Disposer.dispose((Disposable)module);
                this.cleanCachedStuff();
            }
            ModuleListener publisher = this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES);
            for (Module addedModule : addedModules) {
                this.myUnloadedModules.remove(addedModule.getName());
                ((ModuleEx)addedModule).moduleAdded();
                this.cleanCachedStuff();
                publisher.moduleAdded(this.myProject, addedModule);
                this.cleanCachedStuff();
            }
            this.cleanCachedStuff();
            this.fireModulesRenamed(modules, oldNames);
            this.cleanCachedStuff();
            UnloadedModulesListStorage unloadedModulesListStorage = UnloadedModulesListStorage.getInstance(this.myProject);
            this.setUnloadedModuleNames(ContainerUtil.filter(unloadedModulesListStorage.getUnloadedModuleNames(), this.myUnloadedModules::containsKey));
        }, false, true);
    }

    public void fireModuleRenamedByVfsEvent(@NotNull Module module, @NotNull String oldName) {
        Module moduleInMap;
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(59);
        }
        if (oldName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(60);
        }
        LOG.assertTrue((moduleInMap = this.myModuleModel.myModules.remove(oldName)) == null || moduleInMap == module);
        this.myModuleModel.myModules.put(module.getName(), module);
        this.incModificationCount();
        this.myProjectRootManager.makeRootsChange(() -> this.fireModulesRenamed(Collections.singletonList(module), Collections.singletonMap(module, oldName)), false, true);
    }

    @Override
    public String[] getModuleGroupPath(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(61);
        }
        return this.myModuleModel.getModuleGroupPath(module);
    }

    @Override
    public boolean hasModuleGroups() {
        return this.myModuleModel.hasModuleGroups();
    }

    @Override
    @NotNull
    public Collection<ModuleDescription> getAllModuleDescriptions() {
        Module[] modules = this.getModules();
        ArrayList<ModuleDescription> descriptions = new ArrayList<ModuleDescription>(modules.length + this.myUnloadedModules.size());
        for (Module module : modules) {
            descriptions.add(new LoadedModuleDescriptionImpl(module));
        }
        descriptions.addAll(this.myUnloadedModules.values());
        ArrayList<ModuleDescription> arrayList = descriptions;
        if (arrayList == null) {
            ModuleManagerImpl.$$$reportNull$$$0(62);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions() {
        Collection<UnloadedModuleDescription> collection = Collections.unmodifiableCollection(this.myUnloadedModules.values());
        if (collection == null) {
            ModuleManagerImpl.$$$reportNull$$$0(63);
        }
        return collection;
    }

    @Override
    public Collection<ModulePath> getFailedModulePaths() {
        return Collections.unmodifiableSet(this.myFailedModulePaths);
    }

    @Override
    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull String moduleName) {
        if (moduleName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(64);
        }
        return this.myUnloadedModules.get(moduleName);
    }

    @Override
    @NotNull
    public ModuleGrouper getModuleGrouper(@Nullable ModifiableModuleModel model) {
        ModuleGrouper moduleGrouper = ModuleGroupersKt.createGrouper(this.myProject, model);
        if (moduleGrouper == null) {
            ModuleManagerImpl.$$$reportNull$$$0(65);
        }
        return moduleGrouper;
    }

    @Override
    public void setUnloadedModules(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(66);
        }
        if (this.myUnloadedModules.keySet().equals(new HashSet<String>(unloadedModuleNames))) {
            return;
        }
        this.setUnloadedModuleNames(unloadedModuleNames);
        ModifiableModuleModel model = this.getModifiableModel();
        LinkedHashMap<String, UnloadedModuleDescriptionImpl> toLoad = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>(this.myUnloadedModules);
        this.myUnloadedModules.clear();
        for (String name : unloadedModuleNames) {
            if (toLoad.containsKey(name)) {
                this.myUnloadedModules.put(name, (UnloadedModuleDescriptionImpl)toLoad.remove(name));
                continue;
            }
            Module module = this.findModuleByName(name);
            if (module == null) continue;
            LoadedModuleDescriptionImpl description = new LoadedModuleDescriptionImpl(module);
            ModuleSaveItem saveItem = new ModuleSaveItem(module, this);
            ModulePath modulePath = new ModulePath(saveItem.getModuleFilePath(), saveItem.getGroupPathString());
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            List<VirtualFilePointer> contentRoots = ContainerUtil.map(ModuleRootManager.getInstance(module).getContentRootUrls(), url -> pointerManager.create((String)url, (Disposable)this, null));
            UnloadedModuleDescriptionImpl unloadedModuleDescription = new UnloadedModuleDescriptionImpl(modulePath, description.getDependencyModuleNames(), contentRoots);
            StateStorageManagerKt.saveComponentManager(module);
            model.disposeModule(module);
            this.myUnloadedModules.put(name, unloadedModuleDescription);
        }
        ArrayList<ModulePath> oldFailedPaths = new ArrayList<ModulePath>(this.myFailedModulePaths);
        this.myModulePathsToLoad = toLoad.values().stream().map(UnloadedModuleDescriptionImpl::getModulePath).collect(Collectors.toCollection(LinkedHashSet::new));
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(model::commit);
        this.myFailedModulePaths.addAll(oldFailedPaths);
        this.myModulePathsToLoad.clear();
    }

    @Override
    public void removeUnloadedModules(@NotNull Collection<? extends UnloadedModuleDescription> unloadedModules) {
        if (unloadedModules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(67);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (UnloadedModuleDescription unloadedModuleDescription : unloadedModules) {
            this.myUnloadedModules.remove(unloadedModuleDescription.getName());
        }
        this.setUnloadedModuleNames(new ArrayList<String>(this.myUnloadedModules.keySet()));
    }

    protected void setUnloadedModuleNames(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(68);
        }
        UnloadedModulesListStorage.getInstance(this.myProject).setUnloadedModuleNames(unloadedModuleNames);
    }

    public void setModuleGroupPath(@NotNull Module module, String @Nullable [] groupPath) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(69);
        }
        this.myModuleModel.setModuleGroupPath(module, groupPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 62: 
            case 63: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 62: 
            case 63: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesToLoad";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesToUnload";
                break;
            }
            case 5: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 10: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 62: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/module/impl/ModuleManagerImpl";
                break;
            }
            case 7: 
            case 22: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 8: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 59: 
            case 61: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeComponentCreation";
                break;
            }
            case 13: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNames";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTypeId";
                break;
            }
            case 34: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 42: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onModule";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModuleNames";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/module/impl/ModuleManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToModuleFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModuleInternal";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "newModule";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "newNonPersistentModule";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModule";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedModules";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleDependencyComparator";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleGraph";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependentModules";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModuleDescriptions";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModuleDescriptions";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleGrouper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unloadNewlyAddedModulesIfPossible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPathsToModuleFiles";
                break;
            }
            case 6: 
            case 10: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 62: 
            case 63: 
            case 65: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadModules";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadModuleInternal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "initModule";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isUnknownModuleType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showUnknownModuleTypeNotification";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleRemoved";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeModuleRemoved";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fireModulesRenamed";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onModuleLoadErrors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "disposeModuleLater";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleLoadErrors";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeFailedModulePath";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "newModule";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "newNonPersistentModule";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "loadModule";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "disposeModule";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDependentModules";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependent";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependsOn";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleAddedInWriteAction";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "commitModelWithRunnable";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createNonPersistentModule";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "commitModel";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleRenamedByVfsEvent";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getModuleGroupPath";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleDescription";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setUnloadedModules";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "removeUnloadedModules";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setUnloadedModuleNames";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "setModuleGroupPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 62: 
            case 63: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class ModuleModelImpl
    implements ModifiableModuleModel {
        final Map<String, Module> myModules;
        private volatile Module[] myModulesCache;
        private final List<Module> myModulesToDispose;
        private final Map<Module, String> myModuleToNewName;
        private final Map<String, Module> myNewNameToModule;
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;
        private final ModuleManagerImpl myManager;

        private ModuleModelImpl(@NotNull ModuleManagerImpl manager) {
            if (manager == null) {
                ModuleModelImpl.$$$reportNull$$$0(0);
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new HashMap<Module, String>();
            this.myNewNameToModule = new HashMap<String, Module>();
            this.myManager = manager;
            this.myIsWritable = false;
        }

        private ModuleModelImpl(@NotNull ModuleModelImpl that) {
            if (that == null) {
                ModuleModelImpl.$$$reportNull$$$0(1);
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new HashMap<Module, String>();
            this.myNewNameToModule = new HashMap<String, Module>();
            this.myManager = that.myManager;
            this.myModules.putAll(that.myModules);
            Map<Module, String[]> groupPath = that.myModuleGroupPath;
            if (groupPath != null) {
                this.myModuleGroupPath = new Object2ObjectOpenHashMap<Module, String[]>();
                this.myModuleGroupPath.putAll(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, "Attempt to modify committed ModifiableModuleModel");
        }

        @Override
        public Module @NotNull [] getModules() {
            Module[] cache = this.myModulesCache;
            if (cache == null) {
                Collection<Module> modules = this.myModules.values();
                cache = modules.toArray(Module.EMPTY_ARRAY);
                this.myModulesCache = cache;
            }
            if (cache == null) {
                ModuleModelImpl.$$$reportNull$$$0(2);
            }
            return cache;
        }

        private Module @NotNull [] getSortedModules() {
            Module[] allModules = (Module[])this.getModules().clone();
            Arrays.sort(allModules, this.moduleDependencyComparator());
            if (allModules == null) {
                ModuleModelImpl.$$$reportNull$$$0(3);
            }
            return allModules;
        }

        @Override
        public void renameModule(@NotNull Module module, @NotNull String newName) throws ModuleWithNameAlreadyExists {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(4);
            }
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(5);
            }
            Module oldModule = this.getModuleByNewName(newName);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module));
            if (module.getName().equals(newName)) {
                this.myModuleToNewName.remove(module);
                this.myNewNameToModule.remove(newName);
            } else {
                this.myModuleToNewName.put(module, newName);
                this.myNewNameToModule.put(newName, module);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectModelBundle.message("module.already.exists.error", newName), newName);
            }
        }

        @Override
        public Module getModuleToBeRenamed(@NotNull String newName) {
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(6);
            }
            return this.myNewNameToModule.get(newName);
        }

        private Module getModuleByNewName(@NotNull String newName) {
            Module moduleToBeRenamed;
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(7);
            }
            if ((moduleToBeRenamed = this.getModuleToBeRenamed(newName)) != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName);
            return this.myModuleToNewName.get(moduleWithOldName) == null ? moduleWithOldName : null;
        }

        @Override
        public String getNewName(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(8);
            }
            return this.myModuleToNewName.get(module);
        }

        @Override
        @NotNull
        public String getActualName(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(9);
            }
            String string = ObjectUtils.notNull(this.getNewName(module), module.getName());
            if (string == null) {
                ModuleModelImpl.$$$reportNull$$$0(10);
            }
            return string;
        }

        @Override
        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(11);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(12);
            }
            Module module = this.newModule(filePath, moduleTypeId, null);
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(13);
            }
            return module;
        }

        @Override
        @NotNull
        public Module newNonPersistentModule(@NotNull String moduleName, @NotNull String moduleTypeId) {
            if (moduleName == null) {
                ModuleModelImpl.$$$reportNull$$$0(14);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(15);
            }
            this.assertWritable();
            ModuleEx module = this.myManager.createNonPersistentModule(moduleName);
            ModuleManagerImpl.initModule(module, () -> module.setModuleType(moduleTypeId));
            this.addModule(module);
            ModuleEx moduleEx = module;
            if (moduleEx == null) {
                ModuleModelImpl.$$$reportNull$$$0(16);
            }
            return moduleEx;
        }

        @Override
        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId, @Nullable Map<String, String> options) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(17);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(18);
            }
            this.assertWritable();
            filePath = FileUtil.toSystemIndependentName(ModuleModelImpl.resolveShortWindowsName(filePath));
            ModuleEx module = this.getModuleByFilePath(filePath);
            if (module != null) {
                ModuleEx moduleEx = module;
                if (moduleEx == null) {
                    ModuleModelImpl.$$$reportNull$$$0(19);
                }
                return moduleEx;
            }
            ModuleEx newModule = module = this.myManager.createModule(filePath);
            Path finalFilePath = Paths.get(filePath, new String[0]);
            ModuleManagerImpl.initModule(module, () -> {
                ((ModuleStore)newModule.getService(IComponentStore.class)).setPath(finalFilePath, null, true);
                newModule.setModuleType(moduleTypeId);
                if (options != null) {
                    for (Map.Entry option : options.entrySet()) {
                        newModule.setOption((String)option.getKey(), (String)option.getValue());
                    }
                }
            });
            this.addModule(module);
            ModuleEx moduleEx = module;
            if (moduleEx == null) {
                ModuleModelImpl.$$$reportNull$$$0(20);
            }
            return moduleEx;
        }

        @NotNull
        private static String resolveShortWindowsName(@NotNull String filePath) {
            String string;
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(21);
            }
            try {
                string = FileUtil.resolveShortWindowsName(filePath);
            }
            catch (IOException ignored) {
                String string2 = filePath;
                if (string2 == null) {
                    ModuleModelImpl.$$$reportNull$$$0(23);
                }
                return string2;
            }
            if (string == null) {
                ModuleModelImpl.$$$reportNull$$$0(22);
            }
            return string;
        }

        @Nullable
        private ModuleEx getModuleByFilePath(@NotNull @SystemIndependent String filePath) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(24);
            }
            for (Module module : this.getModules()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? module.getModuleFilePath().equals(filePath) : module.getModuleFilePath().equalsIgnoreCase(filePath))) continue;
                return (ModuleEx)module;
            }
            return null;
        }

        @Override
        @NotNull
        public Module loadModule(@NotNull @SystemIndependent String filePath) throws IOException {
            ModuleEx moduleEx;
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(25);
            }
            this.assertWritable();
            String resolvedPath = FileUtilRt.toSystemIndependentName(ModuleModelImpl.resolveShortWindowsName(filePath));
            try {
                Module module = this.getModuleByFilePath(resolvedPath);
                if (module == null) {
                    module = ModuleManagerImpl.loadModuleInternal(Paths.get(resolvedPath, new String[0]), this.myManager);
                    this.addModule(module);
                }
                moduleEx = module;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(ProjectModelBundle.message("module.corrupted.file.error", FileUtilRt.toSystemDependentName(resolvedPath), e.getMessage()), e);
            }
            if (moduleEx == null) {
                ModuleModelImpl.$$$reportNull$$$0(26);
            }
            return moduleEx;
        }

        private void addModule(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(27);
            }
            this.myModulesCache = null;
            this.myModules.put(module.getName(), module);
        }

        @Override
        public void disposeModule(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(28);
            }
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myModules.remove(module.getName()) != null) {
                this.myModulesToDispose.add(module);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module);
            }
        }

        @Override
        public Module findModuleByName(@NotNull String name) {
            Module module;
            if (name == null) {
                ModuleModelImpl.$$$reportNull$$$0(29);
            }
            if ((module = this.myModules.get(name)) != null && !module.isDisposed()) {
                return module;
            }
            return null;
        }

        @NotNull
        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder<Module> builder = new DFSTBuilder<Module>(this.moduleGraph(true));
            Comparator<Module> comparator = builder.comparator();
            if (comparator == null) {
                ModuleModelImpl.$$$reportNull$$$0(30);
            }
            return comparator;
        }

        @NotNull
        private Graph<Module> moduleGraph(final boolean includeTests) {
            Graph<Module> graph = GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<Module>(){

                @Override
                @NotNull
                public Collection<Module> getNodes() {
                    Collection<Module> collection = myModules.values();
                    if (collection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return collection;
                }

                @Override
                @NotNull
                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance(m).getDependencies(includeTests);
                    Iterator<Module> iterator = Arrays.asList(dependentModules).iterator();
                    if (iterator == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return iterator;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "sqldelight/com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNodes";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIn";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }));
            if (graph == null) {
                ModuleModelImpl.$$$reportNull$$$0(31);
            }
            return graph;
        }

        @Override
        public void commit() {
            ModifiableModelCommitter.multiCommit(Collections.emptyList(), (ModifiableModuleModel)this);
        }

        private void commitWithRunnable(@NotNull Runnable runnable) {
            if (runnable == null) {
                ModuleModelImpl.$$$reportNull$$$0(32);
            }
            this.myManager.commitModel(this, runnable);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        @Override
        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            Set<Module> existingModules = ContainerUtil.set(this.myManager.myModuleModel.getModules());
            for (Module thisModule : this.getModules()) {
                if (existingModules.contains(thisModule)) continue;
                Disposer.dispose(thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (existingModules.contains(moduleToDispose)) continue;
                Disposer.dispose(moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        @Override
        public boolean isChanged() {
            if (!this.myIsWritable) {
                return false;
            }
            ModuleModelImpl model = this.myManager.myModuleModel;
            return !this.myModules.equals(model.myModules) || !Comparing.equal(model.myModuleGroupPath, this.myModuleGroupPath) || !this.myModuleToNewName.isEmpty();
        }

        private void disposeModel() {
            Module[] modules = this.getModules();
            this.myModulesCache = null;
            this.myModules.clear();
            for (Module module : modules) {
                Disposer.dispose(module);
            }
            this.myModuleGroupPath = null;
        }

        @Override
        public String[] getModuleGroupPath(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(33);
            }
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module);
        }

        @Override
        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        @Override
        public void setModuleGroupPath(@NotNull Module module, String @Nullable(value="null means remove") [] groupPath) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(34);
            }
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new Object2ObjectOpenHashMap<Module, String[]>();
            }
            if (groupPath == null) {
                this.myModuleGroupPath.remove(module);
            } else {
                this.myModuleGroupPath.put(module, groupPath);
            }
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = this.myManager.myProject;
            if (project == null) {
                ModuleModelImpl.$$$reportNull$$$0(35);
            }
            return project;
        }

        static /* synthetic */ Module[] access$502(ModuleModelImpl x0, Module[] x1) {
            x0.myModulesCache = x1;
            return x1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 16: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 26: 
                case 30: 
                case 31: 
                case 35: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 16: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 26: 
                case 30: 
                case 31: 
                case 35: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 16: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 26: 
                case 30: 
                case 31: 
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl";
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 27: 
                case 28: 
                case 33: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 11: 
                case 17: 
                case 21: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 12: 
                case 15: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleTypeId";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortedModules";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActualName";
                    break;
                }
                case 13: 
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newModule";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newNonPersistentModule";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveShortWindowsName";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadModule";
                    break;
                }
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moduleDependencyComparator";
                    break;
                }
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moduleGraph";
                    break;
                }
                case 35: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 16: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 26: 
                case 30: 
                case 31: 
                case 35: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "renameModule";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleToBeRenamed";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleByNewName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNewName";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getActualName";
                    break;
                }
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "newModule";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "newNonPersistentModule";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveShortWindowsName";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleByFilePath";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "loadModule";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "addModule";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeModule";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "findModuleByName";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "commitWithRunnable";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleGroupPath";
                    break;
                }
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "setModuleGroupPath";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 16: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 26: 
                case 30: 
                case 31: 
                case 35: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;
        private final ModuleManager myModuleManager;

        ModuleSaveItem(@NotNull Module module, @NotNull ModuleManager moduleManager) {
            if (module == null) {
                ModuleSaveItem.$$$reportNull$$$0(0);
            }
            if (moduleManager == null) {
                ModuleSaveItem.$$$reportNull$$$0(1);
            }
            this.myModule = module;
            this.myModuleManager = moduleManager;
        }

        @Override
        @NotNull
        protected String getModuleName() {
            String string = this.myModule.getName();
            if (string == null) {
                ModuleSaveItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath = this.myModuleManager.getModuleGroupPath(this.myModule);
            return groupPath != null ? StringUtil.join(groupPath, "/") : null;
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            String string = this.myModule.getModuleFilePath();
            if (string == null) {
                ModuleSaveItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleManager";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ModuleGroupInterner {
        private final Interner<String> groups = Interner.createStringInterner();
        private final Map<String[], String[]> paths = new Object2ObjectOpenCustomHashMap<String[], String[]>(ObjectArrays.HASH_STRATEGY);

        private ModuleGroupInterner() {
        }

        private void setModuleGroupPath(@NotNull ModifiableModuleModel model, @NotNull Module module, String @Nullable [] group) {
            String[] cached;
            if (model == null) {
                ModuleGroupInterner.$$$reportNull$$$0(0);
            }
            if (module == null) {
                ModuleGroupInterner.$$$reportNull$$$0(1);
            }
            String[] stringArray = cached = group == null ? null : this.paths.get(group);
            if (cached == null && group != null) {
                cached = new String[group.length];
                for (int i = 0; i < group.length; ++i) {
                    String g = group[i];
                    cached[i] = this.groups.intern(g);
                }
                this.paths.put(cached, cached);
            }
            model.setModuleGroupPath(module, cached);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
            }
            objectArray[1] = "sqldelight/com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner";
            objectArray[2] = "setModuleGroupPath";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

