/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.openapi.application.ReadAction;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.module.ModuleManager;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.roots.JdkOrderEntry;
import sqldelight.com.intellij.openapi.roots.LibraryOrderEntry;
import sqldelight.com.intellij.openapi.roots.ModuleOrderEntry;
import sqldelight.com.intellij.openapi.roots.ModuleRootManager;
import sqldelight.com.intellij.openapi.roots.OrderEntry;
import sqldelight.com.intellij.openapi.roots.ProjectFileIndex;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.util.io.FileUtil;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiFileSystemItem;
import sqldelight.com.intellij.util.PathUtilRt;
import sqldelight.com.intellij.util.graph.Graph;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class ModuleUtilCore {
    public static final Key<Module> KEY_MODULE = new Key("Module");

    public static boolean projectContainsFile(@NotNull Project project, @NotNull VirtualFile file, boolean isLibraryElement) {
        if (project == null) {
            ModuleUtilCore.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ModuleUtilCore.$$$reportNull$$$0(1);
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        if (isLibraryElement) {
            List<OrderEntry> orders = projectFileIndex.getOrderEntriesForFile(file);
            for (OrderEntry orderEntry : orders) {
                if (!(orderEntry instanceof JdkOrderEntry) && !(orderEntry instanceof LibraryOrderEntry)) continue;
                return true;
            }
            return false;
        }
        return projectFileIndex.isInContent(file);
    }

    @NotNull
    public static String getModuleNameInReadAction(@NotNull Module module) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(2);
        }
        String string = ReadAction.compute(module::getName);
        if (string == null) {
            ModuleUtilCore.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean isModuleDisposed(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            ModuleUtilCore.$$$reportNull$$$0(4);
        }
        if (!element.isValid()) {
            return true;
        }
        Project project = element.getProject();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return true;
        }
        VirtualFile vFile = file.getVirtualFile();
        Module module2 = module = vFile == null ? null : projectFileIndex.getModuleForFile(vFile);
        return module == null ? !projectFileIndex.isInLibraryClasses(vFile) : module.isDisposed();
    }

    @Nullable
    public static Module findModuleForFile(@Nullable PsiFile containingFile) {
        VirtualFile vFile;
        if (containingFile != null && (vFile = containingFile.getVirtualFile()) != null) {
            return ModuleUtilCore.findModuleForFile(vFile, containingFile.getProject());
        }
        return null;
    }

    @Nullable
    public static Module findModuleForFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            ModuleUtilCore.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ModuleUtilCore.$$$reportNull$$$0(6);
        }
        if (project.isDefault()) {
            return null;
        }
        return ProjectFileIndex.getInstance(project).getModuleForFile(file);
    }

    @Nullable
    public static Module findModuleForPsiElement(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            ModuleUtilCore.$$$reportNull$$$0(7);
        }
        if ((containingFile = element.getContainingFile()) == null ? !element.isValid() : !containingFile.isValid()) {
            return null;
        }
        Project project = (containingFile == null ? element : containingFile).getProject();
        if (project.isDefault()) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        if (element instanceof PsiFileSystemItem && (!(element instanceof PsiFile) || element.getContext() == null)) {
            VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
            if (vFile == null) {
                VirtualFile virtualFile = vFile = containingFile == null ? null : containingFile.getOriginalFile().getVirtualFile();
                if (vFile == null) {
                    return element.getUserData(KEY_MODULE);
                }
            }
            if (fileIndex.isInLibrary(vFile)) {
                List<OrderEntry> orderEntries = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries.isEmpty()) {
                    return null;
                }
                if (orderEntries.size() == 1) {
                    return orderEntries.get(0).getOwnerModule();
                }
                HashSet<Module> modules = new HashSet<Module>();
                for (OrderEntry orderEntry : orderEntries) {
                    modules.add(orderEntry.getOwnerModule());
                }
                Module[] candidates = modules.toArray(Module.EMPTY_ARRAY);
                Arrays.sort(candidates, ModuleManager.getInstance(project).moduleDependencyComparator());
                return candidates[0];
            }
            return fileIndex.getModuleForFile(vFile);
        }
        if (containingFile != null) {
            PsiFile file;
            PsiElement context;
            while ((context = containingFile.getContext()) != null && (file = context.getContainingFile()) != null) {
                containingFile = file;
            }
            if (containingFile.getUserData(KEY_MODULE) != null) {
                return containingFile.getUserData(KEY_MODULE);
            }
            PsiFile originalFile = containingFile.getOriginalFile();
            if (originalFile.getUserData(KEY_MODULE) != null) {
                return originalFile.getUserData(KEY_MODULE);
            }
            VirtualFile virtualFile = originalFile.getVirtualFile();
            if (virtualFile != null) {
                return fileIndex.getModuleForFile(virtualFile);
            }
        }
        return element.getUserData(KEY_MODULE);
    }

    public static void getDependencies(@NotNull Module module, @NotNull Set<? super Module> modules) {
        Module[] dependencies;
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(8);
        }
        if (modules == null) {
            ModuleUtilCore.$$$reportNull$$$0(9);
        }
        if (modules.contains(module)) {
            return;
        }
        modules.add(module);
        for (Module dependency : dependencies = ModuleRootManager.getInstance(module).getDependencies()) {
            ModuleUtilCore.getDependencies(dependency, modules);
        }
    }

    public static void collectModulesDependsOn(@NotNull Module module, @NotNull Set<? super Module> result) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(10);
        }
        if (result == null) {
            ModuleUtilCore.$$$reportNull$$$0(11);
        }
        if (!result.add(module)) {
            return;
        }
        ModuleManager moduleManager = ModuleManager.getInstance(module.getProject());
        List<Module> dependentModules = moduleManager.getModuleDependentModules(module);
        block0: for (Module dependentModule : dependentModules) {
            OrderEntry[] orderEntries;
            for (OrderEntry o : orderEntries = ModuleRootManager.getInstance(dependentModule).getOrderEntries()) {
                ModuleOrderEntry orderEntry;
                if (!(o instanceof ModuleOrderEntry) || (orderEntry = (ModuleOrderEntry)o).getModule() != module) continue;
                if (orderEntry.isExported()) {
                    ModuleUtilCore.collectModulesDependsOn(dependentModule, result);
                    continue block0;
                }
                result.add(dependentModule);
                continue block0;
            }
        }
    }

    @NotNull
    public static List<Module> getAllDependentModules(@NotNull Module module) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(12);
        }
        ArrayList<Module> list = new ArrayList<Module>();
        Graph<Module> graph = ModuleManager.getInstance(module.getProject()).moduleGraph();
        Iterator<Module> i = graph.getOut(module);
        while (i.hasNext()) {
            list.add(i.next());
        }
        ArrayList<Module> arrayList = list;
        if (arrayList == null) {
            ModuleUtilCore.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public static boolean visitMeAndDependentModules(@NotNull Module module, @NotNull ModuleVisitor visitor) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(14);
        }
        if (visitor == null) {
            ModuleUtilCore.$$$reportNull$$$0(15);
        }
        if (!visitor.visit(module)) {
            return false;
        }
        List<Module> list = ModuleUtilCore.getAllDependentModules(module);
        for (Module dependentModule : list) {
            if (visitor.visit(dependentModule)) continue;
            return false;
        }
        return true;
    }

    public static boolean moduleContainsFile(@NotNull Module module, @NotNull VirtualFile file, boolean isLibraryElement) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(16);
        }
        if (file == null) {
            ModuleUtilCore.$$$reportNull$$$0(17);
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
        if (isLibraryElement) {
            OrderEntry orderEntry = moduleRootManager.getFileIndex().getOrderEntryForFile(file);
            return orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }
        return moduleRootManager.getFileIndex().isInContent(file);
    }

    public static boolean isModuleFile(@NotNull Module module, @NotNull VirtualFile file) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(18);
        }
        if (file == null) {
            ModuleUtilCore.$$$reportNull$$$0(19);
        }
        return FileUtil.namesEqual(file.getPath(), module.getModuleFilePath());
    }

    public static boolean isModuleDir(@NotNull Module module, @NotNull VirtualFile dir) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(20);
        }
        if (dir == null) {
            ModuleUtilCore.$$$reportNull$$$0(21);
        }
        return FileUtil.namesEqual(dir.getPath(), ModuleUtilCore.getModuleDirPath(module));
    }

    @NotNull
    public static String getModuleDirPath(@NotNull Module module) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(22);
        }
        String string = PathUtilRt.getParentPath(module.getModuleFilePath());
        if (string == null) {
            ModuleUtilCore.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/module/ModuleUtilCore";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/module/ModuleUtilCore";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNameInReadAction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "projectContainsFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameInReadAction";
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDisposed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForPsiElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesDependsOn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitMeAndDependentModules";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "moduleContainsFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isModuleFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDir";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDirPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ModuleVisitor {
        public boolean visit(@NotNull Module var1);
    }
}

