/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.application;

import java.awt.EventQueue;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;
import sqldelight.com.intellij.diagnostic.LoadingState;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.application.AccessToken;
import sqldelight.com.intellij.openapi.application.AppUIExecutor;
import sqldelight.com.intellij.openapi.application.Application;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.application.ModalityState;
import sqldelight.com.intellij.openapi.application.TransactionGuard;
import sqldelight.com.intellij.openapi.application.TransactionId;
import sqldelight.com.intellij.openapi.application.WriteThread;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.progress.ProcessCanceledException;
import sqldelight.com.intellij.openapi.progress.ProgressIndicatorProvider;
import sqldelight.com.intellij.openapi.util.Disposer;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class TransactionGuardImpl
extends TransactionGuard {
    private static final Logger LOG = Logger.getInstance(TransactionGuardImpl.class);
    private final Map<ModalityState, Boolean> myWriteSafeModalities = ContainerUtil.createConcurrentWeakMap();
    private boolean myWritingAllowed;
    private boolean myErrorReported;

    public TransactionGuardImpl() {
        this.myWriteSafeModalities.put(ModalityState.NON_MODAL, true);
        this.myWritingAllowed = SwingUtilities.isEventDispatchThread();
    }

    @Override
    public void submitTransaction(@NotNull Disposable parentDisposable, @Nullable TransactionId expectedContext, @NotNull Runnable transaction) {
        if (parentDisposable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(0);
        }
        if (transaction == null) {
            TransactionGuardImpl.$$$reportNull$$$0(1);
        }
        ModalityState modality = expectedContext == null ? ModalityState.NON_MODAL : ((TransactionIdImpl)expectedContext).myModality;
        Application app = ApplicationManager.getApplication();
        if (app.isWriteThread() && this.myWritingAllowed && !ModalityState.current().dominates(modality)) {
            if (!Disposer.isDisposed(parentDisposable)) {
                transaction.run();
            }
        } else {
            ((AppUIExecutor)AppUIExecutor.onWriteThread(modality).later().expireWith(parentDisposable)).submit(transaction);
        }
    }

    @Override
    public void submitTransactionAndWait(@NotNull Runnable runnable) throws ProcessCanceledException {
        Application app;
        if (runnable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(2);
        }
        if ((app = ApplicationManager.getApplication()).isWriteThread()) {
            if (!this.myWritingAllowed) {
                String message = "Cannot run synchronous submitTransactionAndWait from invokeLater. Please use asynchronous submit*Transaction. See TransactionGuard FAQ for details.\nTransaction: " + runnable;
                if (!this.isWriteSafeModality(ModalityState.current())) {
                    message = message + "\nUnsafe modality: " + ModalityState.current();
                }
                LOG.error(message);
            }
            runnable.run();
            return;
        }
        if (app.isReadAccessAllowed()) {
            throw new IllegalStateException("submitTransactionAndWait should not be invoked from a read action");
        }
        ModalityState state = ModalityState.defaultModalityState();
        if (!this.isWriteSafeModality(state)) {
            LOG.error("Cannot run synchronous submitTransactionAndWait from a background thread created in a write-unsafe context");
        }
        WriteThread.invokeAndWait(runnable);
    }

    public void performUserActivity(Runnable activity) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        AccessToken token = this.startActivity(true);
        try {
            activity.run();
        }
        finally {
            token.finish();
        }
    }

    @NotNull
    public AccessToken startActivity(boolean userActivity) {
        boolean allowWriting;
        this.myErrorReported = false;
        boolean bl = allowWriting = userActivity && this.isWriteSafeModality(ModalityState.current());
        if (this.myWritingAllowed == allowWriting) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                TransactionGuardImpl.$$$reportNull$$$0(3);
            }
            return accessToken;
        }
        if (allowWriting) {
            ApplicationManager.getApplication().assertIsWriteThread();
        } else if (!EventQueue.isDispatchThread()) {
            LOG.error("must be swing thread");
        }
        final boolean prev = this.myWritingAllowed;
        this.myWritingAllowed = allowWriting;
        return new AccessToken(){

            @Override
            public void finish() {
                TransactionGuardImpl.this.myWritingAllowed = prev;
            }
        };
    }

    @Override
    public boolean isWritingAllowed() {
        ApplicationManager.getApplication().assertIsWriteThread();
        return this.myWritingAllowed;
    }

    @Override
    public boolean isWriteSafeModality(ModalityState state) {
        return Boolean.TRUE.equals(this.myWriteSafeModalities.get(state));
    }

    public void assertWriteActionAllowed() {
        ApplicationManager.getApplication().assertIsWriteThread();
        if (!this.myWritingAllowed && TransactionGuardImpl.areAssertionsEnabled() && !this.myErrorReported) {
            LOG.error(TransactionGuardImpl.reportWriteUnsafeContext(ModalityState.current()));
            this.myErrorReported = true;
        }
    }

    private static String reportWriteUnsafeContext(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(4);
        }
        return "Write-unsafe context! Model changes are allowed from write-safe contexts only. Please ensure you're using invokeLater/invokeAndWait with a correct modality state (not \"any\"). See TransactionGuard documentation for details.\n  current modality=" + modality;
    }

    @Override
    public void assertWriteSafeContext(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(5);
        }
        if (!this.isWriteSafeModality(modality) && TransactionGuardImpl.areAssertionsEnabled()) {
            LOG.error(TransactionGuardImpl.reportWriteUnsafeContext(modality));
        }
    }

    private static boolean areAssertionsEnabled() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() && Registry.is("ide.require.transaction.for.model.changes", false);
    }

    @Override
    public void submitTransactionLater(@NotNull Disposable parentDisposable, @NotNull Runnable transaction) {
        if (parentDisposable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(6);
        }
        if (transaction == null) {
            TransactionGuardImpl.$$$reportNull$$$0(7);
        }
        TransactionIdImpl ctx = this.getContextTransaction();
        ApplicationManager.getApplication().invokeLaterOnWriteThread(transaction, ctx == null ? ModalityState.NON_MODAL : ctx.myModality);
    }

    @Override
    public TransactionIdImpl getContextTransaction() {
        if (ApplicationManager.getApplication().isWriteThread() ? !this.myWritingAllowed : ProgressIndicatorProvider.getGlobalProgressIndicator() == null) {
            return null;
        }
        ModalityState state = ModalityState.defaultModalityState();
        return this.isWriteSafeModality(state) ? new TransactionIdImpl(state) : null;
    }

    public void enteredModality(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(8);
        }
        this.myWriteSafeModalities.put(modality, this.myWritingAllowed);
    }

    @NotNull
    public Runnable wrapLaterInvocation(final @NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        if (runnable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(9);
        }
        if (modalityState == null) {
            TransactionGuardImpl.$$$reportNull$$$0(10);
        }
        if (this.isWriteSafeModality(modalityState)) {
            return new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().assertIsWriteThread();
                    boolean prev = TransactionGuardImpl.this.myWritingAllowed;
                    TransactionGuardImpl.this.myWritingAllowed = true;
                    try {
                        runnable.run();
                    }
                    finally {
                        TransactionGuardImpl.this.myWritingAllowed = prev;
                    }
                }

                public String toString() {
                    return runnable.toString();
                }
            };
        }
        Runnable runnable2 = runnable;
        if (runnable2 == null) {
            TransactionGuardImpl.$$$reportNull$$$0(11);
        }
        return runnable2;
    }

    public String toString() {
        return "TransactionGuardImpl{myWritingAllowed=" + this.myWritingAllowed + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/application/TransactionGuardImpl";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/application/TransactionGuardImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startActivity";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapLaterInvocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "submitTransaction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "submitTransactionAndWait";
                break;
            }
            case 3: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportWriteUnsafeContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertWriteSafeContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "submitTransactionLater";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enteredModality";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wrapLaterInvocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TransactionIdImpl
    implements TransactionId {
        final ModalityState myModality;

        private TransactionIdImpl(ModalityState modality) {
            this.myModality = modality;
        }

        public String toString() {
            return this.myModality.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionIdImpl)) {
                return false;
            }
            TransactionIdImpl id = (TransactionIdImpl)o;
            return Objects.equals(this.myModality, id.myModality);
        }

        public int hashCode() {
            return Objects.hash(this.myModality);
        }
    }
}

