/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.jna;

import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.SystemInfo;
import sqldelight.com.sun.jna.Native;

public final class JnaLoader {
    private static Boolean ourJnaLoaded = null;

    public static synchronized void load(Logger logger2) {
        if (ourJnaLoaded == null) {
            ourJnaLoaded = Boolean.FALSE;
            try {
                long t = System.currentTimeMillis();
                int ptrSize = Native.POINTER_SIZE;
                t = System.currentTimeMillis() - t;
                logger2.info("JNA library (" + (ptrSize << 3) + "-bit) loaded in " + t + " ms");
                ourJnaLoaded = Boolean.TRUE;
            }
            catch (Throwable t) {
                logger2.warn("Unable to load JNA library (OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + ")", t);
            }
        }
    }

    public static synchronized boolean isLoaded() {
        if (ourJnaLoaded == null) {
            JnaLoader.load(Logger.getInstance(JnaLoader.class));
        }
        return ourJnaLoaded;
    }
}

