/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ide.plugins;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import sqldelight.com.intellij.ide.plugins.DescriptorListLoadingContext;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import sqldelight.com.intellij.ide.plugins.PluginError;
import sqldelight.com.intellij.ide.plugins.PluginManagerCore;
import sqldelight.com.intellij.openapi.extensions.PluginId;
import sqldelight.com.intellij.openapi.util.BuildNumber;
import sqldelight.com.intellij.openapi.util.io.FileUtil;
import sqldelight.com.intellij.util.PlatformUtils;
import sqldelight.com.intellij.util.text.VersionComparatorUtil;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class PluginLoadingResult {
    private final Map<PluginId, Set<String>> brokenPluginVersions;
    @NotNull
    final Supplier<BuildNumber> productBuildNumber;
    final Map<PluginId, IdeaPluginDescriptorImpl> incompletePlugins;
    private final Map<PluginId, IdeaPluginDescriptorImpl> plugins;
    final Map<PluginId, IdeaPluginDescriptorImpl> idMap;
    @Nullable
    Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateModuleMap;
    private final Map<PluginId, PluginError> errors;
    private final Set<PluginId> shadowedBundledIds;
    private final boolean checkModuleDependencies;
    private List<IdeaPluginDescriptorImpl> enabledPlugins;

    @NotNull
    List<IdeaPluginDescriptorImpl> getEnabledPlugins() {
        List<IdeaPluginDescriptorImpl> list = this.enabledPlugins;
        if (list == null) {
            PluginLoadingResult.$$$reportNull$$$0(0);
        }
        return list;
    }

    PluginLoadingResult(@NotNull Map<PluginId, Set<String>> brokenPluginVersions, @NotNull Supplier<BuildNumber> productBuildNumber) {
        if (brokenPluginVersions == null) {
            PluginLoadingResult.$$$reportNull$$$0(1);
        }
        if (productBuildNumber == null) {
            PluginLoadingResult.$$$reportNull$$$0(2);
        }
        this(brokenPluginVersions, productBuildNumber, !PlatformUtils.isIntelliJ());
    }

    PluginLoadingResult(@NotNull Map<PluginId, Set<String>> brokenPluginVersions, @NotNull Supplier<BuildNumber> productBuildNumber, boolean checkModuleDependencies) {
        if (brokenPluginVersions == null) {
            PluginLoadingResult.$$$reportNull$$$0(3);
        }
        if (productBuildNumber == null) {
            PluginLoadingResult.$$$reportNull$$$0(4);
        }
        this.incompletePlugins = new ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl>();
        this.plugins = new HashMap<PluginId, IdeaPluginDescriptorImpl>();
        this.idMap = new ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl>();
        this.errors = new ConcurrentHashMap<PluginId, PluginError>();
        this.shadowedBundledIds = new HashSet<PluginId>();
        this.brokenPluginVersions = brokenPluginVersions;
        this.productBuildNumber = productBuildNumber;
        this.checkModuleDependencies = checkModuleDependencies;
    }

    int enabledPluginCount() {
        return this.plugins.size();
    }

    void finishLoading() {
        IdeaPluginDescriptorImpl[] enabledPlugins = this.plugins.values().toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        this.plugins.clear();
        Arrays.sort(enabledPlugins, Comparator.comparing(IdeaPluginDescriptorImpl::getPluginId));
        this.enabledPlugins = Arrays.asList(enabledPlugins);
    }

    boolean isBroken(@NotNull PluginId id) {
        Set<String> set;
        if (id == null) {
            PluginLoadingResult.$$$reportNull$$$0(5);
        }
        if ((set = this.brokenPluginVersions.get(id)) == null) {
            return false;
        }
        IdeaPluginDescriptorImpl descriptor = this.idMap.get(id);
        return descriptor != null && set.contains(descriptor.getVersion());
    }

    @NotNull
    List<PluginError> getErrors() {
        if (this.errors.isEmpty()) {
            List<PluginError> list = Collections.emptyList();
            if (list == null) {
                PluginLoadingResult.$$$reportNull$$$0(6);
            }
            return list;
        }
        PluginId[] ids = this.errors.keySet().toArray(PluginId.EMPTY_ARRAY);
        Arrays.sort(ids, null);
        ArrayList<PluginError> result = new ArrayList<PluginError>(ids.length);
        for (PluginId id : ids) {
            result.add(this.errors.get(id));
        }
        ArrayList<PluginError> arrayList = result;
        if (arrayList == null) {
            PluginLoadingResult.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    void addIncompletePlugin(@NotNull IdeaPluginDescriptorImpl plugin, @Nullable PluginError error) {
        if (plugin == null) {
            PluginLoadingResult.$$$reportNull$$$0(8);
        }
        if (!this.idMap.containsKey(plugin.getPluginId())) {
            this.incompletePlugins.put(plugin.getPluginId(), plugin);
        }
        if (error != null) {
            this.errors.put(plugin.getPluginId(), error);
        }
    }

    void reportIncompatiblePlugin(@NotNull IdeaPluginDescriptorImpl plugin, @NotNull String reason, @Nullable String since, @Nullable String until) {
        if (plugin == null) {
            PluginLoadingResult.$$$reportNull$$$0(9);
        }
        if (reason == null) {
            PluginLoadingResult.$$$reportNull$$$0(10);
        }
        if (this.idMap.containsKey(plugin.getPluginId())) {
            return;
        }
        if (since == null) {
            since = "0.0";
        }
        if (until == null) {
            until = "*.*";
        }
        String message = "is incompatible (reason: " + reason + ", target build " + (since.equals(until) ? "is " + since : "range is " + since + " to " + until) + ")";
        this.errors.put(plugin.getPluginId(), new PluginError(plugin, message, reason));
    }

    void reportCannotLoad(@NotNull Path file, Exception e) {
        if (file == null) {
            PluginLoadingResult.$$$reportNull$$$0(11);
        }
        DescriptorListLoadingContext.LOG.warn("Cannot load " + file, e);
        this.errors.put(PluginId.getId("__cannot load__"), new PluginError(null, "File \"" + FileUtil.getLocationRelativeToUserHome(file.toString(), false) + "\" contains invalid plugin descriptor", null));
    }

    boolean add(@NotNull IdeaPluginDescriptorImpl descriptor, boolean overrideUseIfCompatible) {
        PluginId pluginId;
        if (descriptor == null) {
            PluginLoadingResult.$$$reportNull$$$0(12);
        }
        if ((pluginId = descriptor.getPluginId()) == null) {
            PluginManagerCore.getLogger().warn("No id is provided by \"" + descriptor.getPluginPath().getFileName().toString() + "\"");
            return true;
        }
        if (descriptor.incomplete) {
            return true;
        }
        if (!descriptor.isBundled() && this.checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor)) {
            String message = "defines no module dependencies (supported only in IntelliJ IDEA)";
            this.errors.put(pluginId, new PluginError(descriptor, message, "supported only in IntelliJ IDEA"));
            return false;
        }
        this.errors.remove(pluginId);
        this.incompletePlugins.remove(pluginId);
        IdeaPluginDescriptorImpl prevDescriptor = this.plugins.put(pluginId, descriptor);
        if (prevDescriptor == null) {
            this.idMap.put(pluginId, descriptor);
            for (PluginId module : descriptor.getModules()) {
                this.checkAndAdd(descriptor, module);
            }
            return true;
        }
        if (prevDescriptor.isBundled() || descriptor.isBundled()) {
            this.shadowedBundledIds.add(pluginId);
        }
        if (this.isCompatible(descriptor) && (overrideUseIfCompatible || VersionComparatorUtil.compare(descriptor.getVersion(), prevDescriptor.getVersion()) > 0)) {
            PluginManagerCore.getLogger().info(descriptor.getPluginPath() + " overrides " + prevDescriptor.getPluginPath());
            this.idMap.put(pluginId, descriptor);
            return true;
        }
        this.plugins.put(pluginId, prevDescriptor);
        return false;
    }

    private boolean isCompatible(@NotNull IdeaPluginDescriptorImpl descriptor) {
        if (descriptor == null) {
            PluginLoadingResult.$$$reportNull$$$0(13);
        }
        return PluginManagerCore.getIncompatibleMessage(this.productBuildNumber.get(), descriptor.getSinceBuild(), descriptor.getUntilBuild()) == null;
    }

    private void checkAndAdd(@NotNull IdeaPluginDescriptorImpl descriptor, @NotNull PluginId id) {
        List<IdeaPluginDescriptorImpl> duplicates;
        if (descriptor == null) {
            PluginLoadingResult.$$$reportNull$$$0(14);
        }
        if (id == null) {
            PluginLoadingResult.$$$reportNull$$$0(15);
        }
        if (this.duplicateModuleMap != null && (duplicates = this.duplicateModuleMap.get(id)) != null) {
            duplicates.add(descriptor);
            return;
        }
        IdeaPluginDescriptorImpl existingDescriptor = this.idMap.put(id, descriptor);
        if (existingDescriptor == null) {
            return;
        }
        this.idMap.remove(id);
        if (this.duplicateModuleMap == null) {
            this.duplicateModuleMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list = new ArrayList<IdeaPluginDescriptorImpl>();
        list.add(existingDescriptor);
        list.add(descriptor);
        this.duplicateModuleMap.put(id, list);
    }

    Set<PluginId> getShadowedBundledIds() {
        return this.shadowedBundledIds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/ide/plugins/PluginLoadingResult";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brokenPluginVersions";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productBuildNumber";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPlugins";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/ide/plugins/PluginLoadingResult";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBroken";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addIncompletePlugin";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportIncompatiblePlugin";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportCannotLoad";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkAndAdd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

