/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ide.plugins;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptor;
import sqldelight.com.intellij.ide.plugins.PluginLoadingResult;
import sqldelight.com.intellij.ide.plugins.PluginManagerCore;
import sqldelight.com.intellij.ide.plugins.PluginXmlFactory;
import sqldelight.com.intellij.openapi.application.PathManager;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.extensions.PluginId;
import sqldelight.com.intellij.openapi.util.SafeJdomFactory;
import sqldelight.com.intellij.util.ConcurrencyUtil;
import sqldelight.com.intellij.util.concurrency.AppExecutorUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

final class DescriptorListLoadingContext
implements AutoCloseable {
    private static final boolean unitTestWithBundledPlugins = Boolean.getBoolean("idea.run.tests.with.bundled.plugins");
    static final int IS_PARALLEL = 1;
    static final int IGNORE_MISSING_INCLUDE = 2;
    static final int IGNORE_MISSING_SUB_DESCRIPTOR = 4;
    static final int CHECK_OPTIONAL_CONFIG_NAME_UNIQUENESS = 8;
    static final Logger LOG = PluginManagerCore.getLogger();
    @NotNull
    private final ExecutorService executorService;
    private final ConcurrentLinkedQueue<SafeJdomFactory[]> toDispose;
    private final Supplier<PluginXmlFactory> xmlFactorySupplier;
    @Nullable
    private final ThreadLocal<PluginXmlFactory[]> threadLocalXmlFactory;
    private final int maxThreads;
    @NotNull
    final PluginLoadingResult result;
    final Set<PluginId> disabledPlugins;
    private volatile String defaultVersion;
    final boolean ignoreMissingInclude;
    final boolean ignoreMissingSubDescriptor;
    boolean usePluginClassLoader;
    private final Map<String, PluginId> optionalConfigNames;
    private final Path bundledPluginsPath;
    final boolean loadBundledPlugins;

    @NotNull
    public static DescriptorListLoadingContext createSingleDescriptorContext(@NotNull Set<PluginId> disabledPlugins) {
        if (disabledPlugins == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(0);
        }
        return new DescriptorListLoadingContext(4, disabledPlugins, PluginManagerCore.createLoadingResult(null));
    }

    DescriptorListLoadingContext(int flags, @NotNull Set<PluginId> disabledPlugins, @NotNull PluginLoadingResult result) {
        if (disabledPlugins == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(1);
        }
        if (result == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(2);
        }
        this(flags, disabledPlugins, result, null);
    }

    DescriptorListLoadingContext(int flags, @NotNull Set<PluginId> disabledPlugins, @NotNull PluginLoadingResult result, @Nullable Path bundledPluginsPath) {
        if (disabledPlugins == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(3);
        }
        if (result == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(4);
        }
        this.usePluginClassLoader = !PluginManagerCore.isUnitTestMode || unitTestWithBundledPlugins;
        this.result = result;
        this.disabledPlugins = disabledPlugins;
        this.ignoreMissingInclude = (flags & 2) == 2;
        this.ignoreMissingSubDescriptor = (flags & 4) == 4;
        this.optionalConfigNames = (flags & 8) == 8 ? new ConcurrentHashMap() : null;
        int n = this.maxThreads = (flags & 1) == 1 ? Runtime.getRuntime().availableProcessors() - 1 : 1;
        if (this.maxThreads > 1) {
            this.executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor("PluginManager Loader", this.maxThreads, false);
            this.toDispose = new ConcurrentLinkedQueue();
            this.threadLocalXmlFactory = ThreadLocal.withInitial(() -> {
                PluginXmlFactory factory = new PluginXmlFactory();
                PluginXmlFactory[] ref = new PluginXmlFactory[]{factory};
                this.toDispose.add(ref);
                return ref;
            });
            this.xmlFactorySupplier = () -> this.threadLocalXmlFactory.get()[0];
        } else {
            this.executorService = ConcurrencyUtil.newSameThreadExecutorService();
            this.toDispose = null;
            this.threadLocalXmlFactory = null;
            PluginXmlFactory factory = new PluginXmlFactory();
            this.xmlFactorySupplier = () -> factory;
        }
        this.loadBundledPlugins = bundledPluginsPath != null || !PluginManagerCore.isUnitTestMode;
        this.bundledPluginsPath = bundledPluginsPath;
    }

    @NotNull
    Path getBundledPluginsPath() {
        Path path = this.bundledPluginsPath == null ? Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]) : this.bundledPluginsPath;
        if (path == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(5);
        }
        return path;
    }

    boolean isPluginDisabled(@NotNull PluginId id) {
        if (id == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(6);
        }
        return id != PluginManagerCore.CORE_ID && this.disabledPlugins.contains(id);
    }

    @NotNull
    ExecutorService getExecutorService() {
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(7);
        }
        return executorService;
    }

    @NotNull
    SafeJdomFactory getXmlFactory() {
        SafeJdomFactory safeJdomFactory = this.xmlFactorySupplier.get();
        if (safeJdomFactory == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(8);
        }
        return safeJdomFactory;
    }

    @Override
    public void close() {
        if (this.threadLocalXmlFactory == null) {
            return;
        }
        if (this.maxThreads <= 1) {
            this.threadLocalXmlFactory.remove();
            return;
        }
        this.executorService.execute(() -> {
            for (SafeJdomFactory[] ref : this.toDispose) {
                ref[0] = null;
            }
        });
        this.executorService.shutdown();
    }

    @NotNull
    public String internString(@NotNull String string) {
        if (string == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(9);
        }
        String string2 = this.xmlFactorySupplier.get().intern(string);
        if (string2 == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    public String getDefaultVersion() {
        String result = this.defaultVersion;
        if (result == null) {
            this.defaultVersion = result = this.result.productBuildNumber.get().asStringWithoutProductCode();
        }
        String string = result;
        if (string == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public DateFormat getDateParser() {
        DateFormat dateFormat = this.xmlFactorySupplier.get().releaseDateFormat;
        if (dateFormat == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(12);
        }
        return dateFormat;
    }

    @NotNull
    public List<String> getVisitedFiles() {
        List<String> list = this.xmlFactorySupplier.get().visitedFiles;
        if (list == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(13);
        }
        return list;
    }

    boolean checkOptionalConfigShortName(@NotNull String configFile, @NotNull IdeaPluginDescriptor descriptor, @NotNull IdeaPluginDescriptor rootDescriptor) {
        PluginId pluginId;
        if (configFile == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(14);
        }
        if (descriptor == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(15);
        }
        if (rootDescriptor == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(16);
        }
        if ((pluginId = descriptor.getPluginId()) == null) {
            return false;
        }
        Map<String, PluginId> configNames = this.optionalConfigNames;
        if (configNames == null) {
            return false;
        }
        PluginId oldPluginId = configNames.put(configFile, pluginId);
        if (oldPluginId == null || oldPluginId.equals(pluginId)) {
            return false;
        }
        LOG.error("Optional config file with name '" + configFile + "' already registered by '" + oldPluginId + "'. Please rename to ensure that lookup in the classloader by short name returns correct optional config. Current plugin: '" + rootDescriptor + "'. ");
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/ide/plugins/DescriptorListLoadingContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/ide/plugins/DescriptorListLoadingContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledPluginsPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutorService";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlFactory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "internString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVersion";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateParser";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisitedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSingleDescriptorContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPluginDisabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "internString";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkOptionalConfigShortName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

