/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.codeInspection;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import sqldelight.com.intellij.codeInspection.InspectionManager;
import sqldelight.com.intellij.codeInspection.InspectionProfileEntry;
import sqldelight.com.intellij.codeInspection.LocalInspectionToolSession;
import sqldelight.com.intellij.codeInspection.ProblemDescriptor;
import sqldelight.com.intellij.codeInspection.ProblemsHolder;
import sqldelight.com.intellij.diagnostic.PluginException;
import sqldelight.com.intellij.lang.injection.InjectedLanguageManager;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.Pair;
import sqldelight.com.intellij.openapi.util.TextRange;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiElementVisitor;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiLanguageInjectionHost;
import sqldelight.com.intellij.psi.PsiNamedElement;
import sqldelight.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import sqldelight.com.intellij.psi.PsiRecursiveVisitor;
import sqldelight.org.intellij.lang.annotations.Language;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class LocalInspectionTool
extends InspectionProfileEntry {
    public static final LocalInspectionTool[] EMPTY_ARRAY = new LocalInspectionTool[0];
    private static final Logger LOG = Logger.getInstance(LocalInspectionTool.class);
    @NonNls
    @Language(value="RegExp")
    public static final String VALID_ID_PATTERN = "[a-zA-Z_0-9.-]+";
    private static final Pattern COMPILED_VALID_ID_PATTERN = Pattern.compile("[a-zA-Z_0-9.-]+");

    public static boolean isValidID(@NotNull String id) {
        if (id == null) {
            LocalInspectionTool.$$$reportNull$$$0(0);
        }
        return !id.isEmpty() && COMPILED_VALID_ID_PATTERN.matcher(id).matches();
    }

    @NonNls
    @NotNull
    public String getID() {
        String id;
        if (this.myNameProvider instanceof LocalDefaultNameProvider && (id = ((LocalDefaultNameProvider)this.myNameProvider).getDefaultID()) != null) {
            String string = id;
            if (string == null) {
                LocalInspectionTool.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.getShortName();
        if (string == null) {
            LocalInspectionTool.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected final String getSuppressId() {
        String string = this.getID();
        if (string == null) {
            LocalInspectionTool.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NonNls
    @Nullable
    public String getAlternativeID() {
        if (this.myNameProvider instanceof LocalDefaultNameProvider) {
            return ((LocalDefaultNameProvider)this.myNameProvider).getDefaultAlternativeID();
        }
        return null;
    }

    public boolean runForWholeFile() {
        return false;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            LocalInspectionTool.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            LocalInspectionTool.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            LocalInspectionTool.$$$reportNull$$$0(6);
        }
        if (session == null) {
            LocalInspectionTool.$$$reportNull$$$0(7);
        }
        PsiElementVisitor psiElementVisitor = this.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            LocalInspectionTool.$$$reportNull$$$0(8);
        }
        return psiElementVisitor;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            LocalInspectionTool.$$$reportNull$$$0(9);
        }
        return new PsiElementVisitor(){

            @Override
            public void visitFile(@NotNull PsiFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.addDescriptors(LocalInspectionTool.this.checkFile(file, holder.getManager(), isOnTheFly));
            }

            private void addDescriptors(ProblemDescriptor[] descriptors) {
                if (descriptors != null) {
                    for (ProblemDescriptor descriptor : descriptors) {
                        if (descriptor != null) {
                            holder.registerProblem(descriptor);
                            continue;
                        }
                        Class<?> inspectionToolClass = LocalInspectionTool.this.getClass();
                        LOG.error(PluginException.createByClass("Array returned from checkFile() method of " + inspectionToolClass + " contains null element", null, inspectionToolClass));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "sqldelight/com/intellij/codeInspection/LocalInspectionTool$1", "visitFile"));
            }
        };
    }

    @Nullable
    public PsiNamedElement getProblemElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            LocalInspectionTool.$$$reportNull$$$0(10);
        }
        return psiElement.getContainingFile();
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        if (session == null) {
            LocalInspectionTool.$$$reportNull$$$0(11);
        }
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        if (session == null) {
            LocalInspectionTool.$$$reportNull$$$0(12);
        }
        if (problemsHolder == null) {
            LocalInspectionTool.$$$reportNull$$$0(13);
        }
        this.inspectionFinished(session);
    }

    @Deprecated
    public void inspectionFinished(@NotNull LocalInspectionToolSession session) {
        if (session == null) {
            LocalInspectionTool.$$$reportNull$$$0(14);
        }
    }

    @NotNull
    public List<ProblemDescriptor> processFile(@NotNull PsiFile file, @NotNull InspectionManager manager) {
        LocalInspectionToolSession session;
        ProblemsHolder holder;
        PsiElementVisitor customVisitor;
        if (file == null) {
            LocalInspectionTool.$$$reportNull$$$0(15);
        }
        if (manager == null) {
            LocalInspectionTool.$$$reportNull$$$0(16);
        }
        LOG.assertTrue(!((customVisitor = this.buildVisitor(holder = new ProblemsHolder(manager, file, false), false, session = new LocalInspectionToolSession(file, 0, file.getTextLength()))) instanceof PsiRecursiveVisitor), "The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive: " + customVisitor);
        if (customVisitor == PsiElementVisitor.EMPTY_VISITOR) {
            List<ProblemDescriptor> list = Collections.emptyList();
            if (list == null) {
                LocalInspectionTool.$$$reportNull$$$0(17);
            }
            return list;
        }
        this.inspectionStarted(session, false);
        final InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(holder.getProject());
        file.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                element.accept(customVisitor);
                this.processInjectedFile(element);
                super.visitElement(element);
            }

            private void processInjectedFile(PsiElement element) {
                List<Pair<PsiElement, TextRange>> files;
                if (element instanceof PsiLanguageInjectionHost && (files = injectedLanguageManager.getInjectedPsiFiles(element)) != null) {
                    for (Pair<PsiElement, TextRange> pair : files) {
                        ((PsiElement)pair.first).accept(new PsiRecursiveElementWalkingVisitor(){

                            @Override
                            public void visitElement(@NotNull PsiElement injectedElement) {
                                if (injectedElement == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                injectedElement.accept(customVisitor);
                                super.visitElement(injectedElement);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedElement", "sqldelight/com/intellij/codeInspection/LocalInspectionTool$2$1", "visitElement"));
                            }
                        });
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "sqldelight/com/intellij/codeInspection/LocalInspectionTool$2", "visitElement"));
            }
        });
        this.inspectionFinished(session, holder);
        List<ProblemDescriptor> list = holder.getResults();
        if (list == null) {
            LocalInspectionTool.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/codeInspection/LocalInspectionTool";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/codeInspection/LocalInspectionTool";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidID";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 17: 
            case 18: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProblemElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inspectionStarted";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface LocalDefaultNameProvider
    extends InspectionProfileEntry.DefaultNameProvider {
        @Nullable
        public String getDefaultID();

        @Nullable
        public String getDefaultAlternativeID();
    }
}

