/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.codeInsight;

import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import sqldelight.com.intellij.codeInsight.AnnotationUtil;
import sqldelight.com.intellij.openapi.util.Pair;
import sqldelight.com.intellij.psi.JavaPsiFacade;
import sqldelight.com.intellij.psi.PsiAnnotation;
import sqldelight.com.intellij.psi.PsiAnnotationMemberValue;
import sqldelight.com.intellij.psi.PsiNameValuePair;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

class AnnotationInvocationHandler
implements InvocationHandler {
    @NotNull
    private final Class<? extends Annotation> myType;
    @NotNull
    private final PsiAnnotation myAnnotation;

    AnnotationInvocationHandler(@NotNull Class<? extends Annotation> type2, @NotNull PsiAnnotation annotation) {
        if (type2 == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(1);
        }
        this.myType = type2;
        this.myAnnotation = annotation;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        assert (method.getParameterCount() == 0) : Arrays.toString(method.getParameterTypes());
        String member = method.getName();
        if (member.equals("toString")) {
            return this.toStringImpl();
        }
        if (member.equals("annotationType")) {
            return this.myType;
        }
        Pair<Object, String> pair = AnnotationInvocationHandler.attributeValueOrError(this.myAnnotation, this.myType, member);
        Object value = pair.first;
        if (value == null) {
            String error = (String)pair.second;
            String message = member + ". (Unable to find attribute in '" + this.myAnnotation.getText() + "': " + error + ")";
            throw new IncompleteAnnotationException(this.myType, message);
        }
        return value;
    }

    @NotNull
    private static Pair<Object, String> attributeValueOrError(@NotNull PsiAnnotation annotation, Class<? extends Annotation> type2, @Nullable @NonNls String attributeName) {
        Method method;
        PsiNameValuePair attribute;
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(2);
        }
        PsiAnnotationMemberValue psiAnnotationMemberValue = value = (attribute = AnnotationUtil.findDeclaredAttribute(annotation, attributeName)) == null ? null : attribute.getValue();
        if (value != null) {
            Object result = JavaPsiFacade.getInstance(annotation.getProject()).getConstantEvaluationHelper().computeConstantExpression(value);
            if (result == null) {
                Pair<Object, String> pair = Pair.create(null, "Unable to evaluate annotation value '" + value.getText() + "'");
                if (pair == null) {
                    AnnotationInvocationHandler.$$$reportNull$$$0(3);
                }
                return pair;
            }
            Pair<Object, Object> pair = Pair.create(result, null);
            if (pair == null) {
                AnnotationInvocationHandler.$$$reportNull$$$0(4);
            }
            return pair;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        try {
            method = type2.getMethod(attributeName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Pair<Object, String> pair = Pair.create(null, "Method not found: " + attributeName);
            if (pair == null) {
                AnnotationInvocationHandler.$$$reportNull$$$0(5);
            }
            return pair;
        }
        Object defaultValue = method.getDefaultValue();
        if (defaultValue == null) {
            Pair<Object, String> pair = Pair.create(null, "No default value is specified for method " + attributeName);
            if (pair == null) {
                AnnotationInvocationHandler.$$$reportNull$$$0(6);
            }
            return pair;
        }
        Pair<Object, Object> pair = Pair.create(defaultValue, null);
        if (pair == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(7);
        }
        return pair;
    }

    private String toStringImpl() {
        PsiNameValuePair[] attributes;
        StringBuilder result = new StringBuilder(128);
        result.append('@');
        result.append(this.myType.getName());
        result.append('(');
        boolean firstMember = true;
        for (PsiNameValuePair e : attributes = this.myAnnotation.getParameterList().getAttributes()) {
            if (firstMember) {
                firstMember = false;
            } else {
                result.append(", ");
            }
            result.append(e.getName());
            result.append('=');
            PsiAnnotationMemberValue value = e.getValue();
            result.append(value == null ? "null" : value.getText());
        }
        result.append(')');
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/codeInsight/AnnotationInvocationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/codeInsight/AnnotationInvocationHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "attributeValueOrError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attributeValueOrError";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

