/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.wire;

import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.wire.WireRequestBodyConverter;
import retrofit2.converter.wire.WireResponseBodyConverter;

public final class WireConverterFactory
extends Converter.Factory {
    private final boolean streaming;

    public static WireConverterFactory create() {
        return new WireConverterFactory(false);
    }

    private WireConverterFactory(boolean streaming) {
        this.streaming = streaming;
    }

    public WireConverterFactory withStreaming() {
        return new WireConverterFactory(true);
    }

    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class c = (Class)type;
        if (!Message.class.isAssignableFrom(c)) {
            return null;
        }
        ProtoAdapter adapter = ProtoAdapter.get((Class)c);
        return new WireResponseBodyConverter(adapter);
    }

    @Nullable
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class c = (Class)type;
        if (!Message.class.isAssignableFrom(c)) {
            return null;
        }
        ProtoAdapter adapter = ProtoAdapter.get((Class)c);
        return new WireRequestBodyConverter(adapter, this.streaming);
    }
}

