/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.protobuf;

import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.protobuf.ProtoRequestBodyConverter;
import retrofit2.converter.protobuf.ProtoResponseBodyConverter;

public final class ProtoConverterFactory
extends Converter.Factory {
    @Nullable
    private final ExtensionRegistryLite registry;
    private final boolean streaming;

    public static ProtoConverterFactory create() {
        return new ProtoConverterFactory(null, false);
    }

    public static ProtoConverterFactory createWithRegistry(@Nullable ExtensionRegistryLite registry) {
        return new ProtoConverterFactory(registry, false);
    }

    private ProtoConverterFactory(@Nullable ExtensionRegistryLite registry, boolean streaming) {
        this.registry = registry;
        this.streaming = streaming;
    }

    public ProtoConverterFactory withStreaming() {
        return new ProtoConverterFactory(this.registry, true);
    }

    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        Parser parser;
        if (!(type instanceof Class)) {
            return null;
        }
        Class c = (Class)type;
        if (!MessageLite.class.isAssignableFrom(c)) {
            return null;
        }
        try {
            Method method = c.getDeclaredMethod("parser", new Class[0]);
            parser = (Parser)method.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (IllegalAccessException | NoSuchMethodException ignored) {
            try {
                Field field = c.getDeclaredField("PARSER");
                parser = (Parser)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException("Found a protobuf message but " + c.getName() + " had no parser() method or PARSER field.", e);
            }
        }
        return new ProtoResponseBodyConverter(parser, this.registry);
    }

    @Nullable
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        if (!(type instanceof Class)) {
            return null;
        }
        if (!MessageLite.class.isAssignableFrom((Class)type)) {
            return null;
        }
        return new ProtoRequestBodyConverter(this.streaming);
    }
}

