/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.kotlinx.serialization;

import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ1\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\u00052\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00102\u0006\u0010\u0011\u001a\u0002H\u0005H&\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0012\u0010\u0013\u001a\u00020\u0014X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u0082\u0001\u0002\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lretrofit2/converter/kotlinx/serialization/Serializer;", "", "<init>", "()V", "fromResponseBody", "T", "loader", "Lkotlinx/serialization/DeserializationStrategy;", "body", "Lokhttp3/ResponseBody;", "(Lkotlinx/serialization/DeserializationStrategy;Lokhttp3/ResponseBody;)Ljava/lang/Object;", "toRequestBody", "Lokhttp3/RequestBody;", "contentType", "Lokhttp3/MediaType;", "saver", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lokhttp3/MediaType;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lokhttp3/RequestBody;", "format", "Lkotlinx/serialization/SerialFormat;", "getFormat", "()Lkotlinx/serialization/SerialFormat;", "serializer", "Lkotlinx/serialization/KSerializer;", "type", "Ljava/lang/reflect/Type;", "FromString", "FromBytes", "Lretrofit2/converter/kotlinx/serialization/Serializer$FromBytes;", "Lretrofit2/converter/kotlinx/serialization/Serializer$FromString;", "kotlinx-serialization"})
public abstract class Serializer {
    private Serializer() {
    }

    public abstract <T> T fromResponseBody(@NotNull DeserializationStrategy<? extends T> var1, @NotNull ResponseBody var2);

    @NotNull
    public abstract <T> RequestBody toRequestBody(@NotNull MediaType var1, @NotNull SerializationStrategy<? super T> var2, T var3);

    @NotNull
    protected abstract SerialFormat getFormat();

    @NotNull
    public final KSerializer<Object> serializer(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return SerializersKt.serializer((SerializersModule)this.getFormat().getSerializersModule(), (Type)type);
    }

    public /* synthetic */ Serializer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ1\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\t0\u00142\u0006\u0010\u0015\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lretrofit2/converter/kotlinx/serialization/Serializer$FromBytes;", "Lretrofit2/converter/kotlinx/serialization/Serializer;", "format", "Lkotlinx/serialization/BinaryFormat;", "<init>", "(Lkotlinx/serialization/BinaryFormat;)V", "getFormat", "()Lkotlinx/serialization/BinaryFormat;", "fromResponseBody", "T", "loader", "Lkotlinx/serialization/DeserializationStrategy;", "body", "Lokhttp3/ResponseBody;", "(Lkotlinx/serialization/DeserializationStrategy;Lokhttp3/ResponseBody;)Ljava/lang/Object;", "toRequestBody", "Lokhttp3/RequestBody;", "contentType", "Lokhttp3/MediaType;", "saver", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lokhttp3/MediaType;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lokhttp3/RequestBody;", "kotlinx-serialization"})
    public static final class FromBytes
    extends Serializer {
        @NotNull
        private final BinaryFormat format;

        public FromBytes(@NotNull BinaryFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            super(null);
            this.format = format;
        }

        @NotNull
        protected BinaryFormat getFormat() {
            return this.format;
        }

        @Override
        public <T> T fromResponseBody(@NotNull DeserializationStrategy<? extends T> loader, @NotNull ResponseBody body) {
            Intrinsics.checkNotNullParameter(loader, (String)"loader");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            byte[] bytes = body.bytes();
            BinaryFormat binaryFormat = this.getFormat();
            Intrinsics.checkNotNull((Object)bytes);
            return (T)binaryFormat.decodeFromByteArray(loader, bytes);
        }

        @Override
        @NotNull
        public <T> RequestBody toRequestBody(@NotNull MediaType contentType, @NotNull SerializationStrategy<? super T> saver, T value) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(saver, (String)"saver");
            byte[] bytes = this.getFormat().encodeToByteArray(saver, value);
            RequestBody requestBody = RequestBody.create((MediaType)contentType, (byte[])bytes);
            Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"create(...)");
            return requestBody;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ1\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\t0\u00142\u0006\u0010\u0015\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lretrofit2/converter/kotlinx/serialization/Serializer$FromString;", "Lretrofit2/converter/kotlinx/serialization/Serializer;", "format", "Lkotlinx/serialization/StringFormat;", "<init>", "(Lkotlinx/serialization/StringFormat;)V", "getFormat", "()Lkotlinx/serialization/StringFormat;", "fromResponseBody", "T", "loader", "Lkotlinx/serialization/DeserializationStrategy;", "body", "Lokhttp3/ResponseBody;", "(Lkotlinx/serialization/DeserializationStrategy;Lokhttp3/ResponseBody;)Ljava/lang/Object;", "toRequestBody", "Lokhttp3/RequestBody;", "contentType", "Lokhttp3/MediaType;", "saver", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lokhttp3/MediaType;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lokhttp3/RequestBody;", "kotlinx-serialization"})
    public static final class FromString
    extends Serializer {
        @NotNull
        private final StringFormat format;

        public FromString(@NotNull StringFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            super(null);
            this.format = format;
        }

        @NotNull
        protected StringFormat getFormat() {
            return this.format;
        }

        @Override
        public <T> T fromResponseBody(@NotNull DeserializationStrategy<? extends T> loader, @NotNull ResponseBody body) {
            Intrinsics.checkNotNullParameter(loader, (String)"loader");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            String string = body.string();
            StringFormat stringFormat = this.getFormat();
            Intrinsics.checkNotNull((Object)string);
            return (T)stringFormat.decodeFromString(loader, string);
        }

        @Override
        @NotNull
        public <T> RequestBody toRequestBody(@NotNull MediaType contentType, @NotNull SerializationStrategy<? super T> saver, T value) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(saver, (String)"saver");
            String string = this.getFormat().encodeToString(saver, value);
            RequestBody requestBody = RequestBody.create((MediaType)contentType, (String)string);
            Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"create(...)");
            return requestBody;
        }
    }
}

