/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.jaxb3;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.IOException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.ByteString;
import retrofit2.Converter;
import retrofit2.converter.jaxb3.JaxbConverterFactory;

final class JaxbRequestConverter<T>
implements Converter<T, RequestBody> {
    final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    final JAXBContext context;
    final Class<T> type;

    JaxbRequestConverter(JAXBContext context, Class<T> type) {
        this.context = context;
        this.type = type;
    }

    public RequestBody convert(T value) throws IOException {
        Buffer buffer = new Buffer();
        try {
            Marshaller marshaller = this.context.createMarshaller();
            XMLStreamWriter xmlWriter = this.xmlOutputFactory.createXMLStreamWriter(buffer.outputStream(), JaxbConverterFactory.XML.charset().name());
            marshaller.marshal(value, xmlWriter);
        }
        catch (JAXBException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return RequestBody.create((MediaType)JaxbConverterFactory.XML, (ByteString)buffer.readByteString());
    }
}

