/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.scala;

import java.lang.reflect.Type;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;
import scala.concurrent.Future;
import scala.concurrent.Promise;

final class BodyCallAdapter<T>
implements CallAdapter<T, Future<T>> {
    private final Type responseType;

    BodyCallAdapter(Type responseType) {
        this.responseType = responseType;
    }

    public Type responseType() {
        return this.responseType;
    }

    public Future<T> adapt(Call<T> call) {
        final Promise promise = Promise.apply();
        call.enqueue(new Callback<T>(){

            public void onResponse(Call<T> call, Response<T> response) {
                if (response.isSuccessful()) {
                    promise.success(response.body());
                } else {
                    promise.failure((Throwable)new HttpException(response));
                }
            }

            public void onFailure(Call<T> call, Throwable t) {
                promise.failure(t);
            }
        });
        return promise.future();
    }
}

