/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.protoparser;

import com.squareup.protoparser.Extensions;
import com.squareup.protoparser.Option;
import com.squareup.protoparser.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MessageType
implements Type {
    private final String name;
    private final String fqname;
    private final String documentation;
    private final List<Field> fields;
    private final List<Type> nestedTypes;
    private final List<Extensions> extensions;
    private final List<Option> options;

    MessageType(String name, String fqname, String documentation, List<Field> fields, List<Type> nestedTypes, List<Extensions> extensions, List<Option> options) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (fqname == null) {
            throw new NullPointerException("fqname");
        }
        if (documentation == null) {
            throw new NullPointerException("documentation");
        }
        if (fields == null) {
            throw new NullPointerException("fields");
        }
        if (nestedTypes == null) {
            throw new NullPointerException("nestedTypes");
        }
        if (extensions == null) {
            throw new NullPointerException("extensions");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.name = name;
        this.fqname = fqname;
        this.documentation = documentation;
        this.fields = Collections.unmodifiableList(new ArrayList<Field>(fields));
        this.nestedTypes = Collections.unmodifiableList(new ArrayList<Type>(nestedTypes));
        this.extensions = Collections.unmodifiableList(new ArrayList<Extensions>(extensions));
        this.options = Collections.unmodifiableList(new ArrayList<Option>(options));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fqname;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public List<Type> getNestedTypes() {
        return this.nestedTypes;
    }

    public List<Extensions> getExtensions() {
        return this.extensions;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public boolean equals(Object other) {
        if (other instanceof MessageType) {
            MessageType that = (MessageType)other;
            return this.name.equals(that.name) && this.documentation.equals(that.documentation) && this.fields.equals(that.fields) && this.nestedTypes.equals(that.nestedTypes) && this.options.equals(that.options);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        for (Option option : this.options) {
            result.append("\n  option: ").append(option);
        }
        for (Field field : this.fields) {
            result.append("\n  ").append(field);
        }
        for (Type type : this.nestedTypes) {
            result.append(type).append("\n");
        }
        return result.toString();
    }

    public static final class Field {
        private final Label label;
        private final String type;
        private final String name;
        private final int tag;
        private final List<Option> options;
        private final String documentation;

        Field(Label label, String type, String name, int tag, String documentation, List<Option> options) {
            if (label == null) {
                throw new NullPointerException("label");
            }
            if (type == null) {
                throw new NullPointerException("type");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (documentation == null) {
                throw new NullPointerException("documentation");
            }
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.label = label;
            this.type = type;
            this.name = name;
            this.tag = tag;
            this.documentation = documentation;
            this.options = Collections.unmodifiableList(new ArrayList<Option>(options));
        }

        public Label getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getTag() {
            return this.tag;
        }

        public List<Option> getOptions() {
            return this.options;
        }

        public Map<String, Object> getExtensions() {
            return this.optionsToMap(this.options);
        }

        private Map<String, Object> optionsToMap(List<Option> options) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Option option : options) {
                String name = option.getName();
                Object value = option.getValue();
                if (value instanceof String || value instanceof List) {
                    map.put(name, value);
                    continue;
                }
                if (value instanceof Option) {
                    Map<String, Object> newMap = this.optionsToMap(Arrays.asList((Option)value));
                    Object oldValue = map.get(name);
                    if (oldValue instanceof Map) {
                        Map oldMap = (Map)oldValue;
                        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
                            oldMap.put(entry.getKey(), entry.getValue());
                        }
                        continue;
                    }
                    map.put(name, newMap);
                    continue;
                }
                if (value instanceof Map) {
                    Object oldValue = map.get(name);
                    if (oldValue instanceof Map) {
                        ((Map)oldValue).putAll((Map)value);
                        continue;
                    }
                    map.put(name, value);
                    continue;
                }
                throw new AssertionError((Object)"Option value must be String, List, or Map<String, ?>");
            }
            return map;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public boolean isDeprecated() {
            return "true".equals(this.getOptionValue("deprecated"));
        }

        public boolean isPacked() {
            return "true".equals(this.getOptionValue("packed"));
        }

        public String getDefault() {
            return (String)this.getOptionValue("default");
        }

        private Object getOptionValue(String name) {
            for (Option option : this.options) {
                if (!option.getName().equals(name)) continue;
                return option.getValue();
            }
            return null;
        }

        public boolean equals(Object other) {
            if (other instanceof Field) {
                Field that = (Field)other;
                return this.label.equals((Object)that.label) && this.type.equals(that.type) && this.name.equals(that.name) && this.tag == that.tag && this.options.equals(that.options) && this.documentation.equals(that.documentation);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + 37 * this.type.hashCode();
        }

        public String toString() {
            return String.format("%s %s %s = %d %s", new Object[]{this.label, this.type, this.name, this.tag, this.options});
        }
    }

    public static enum Label {
        OPTIONAL,
        REQUIRED,
        REPEATED;

    }
}

