/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.protoparser;

import com.squareup.protoparser.Option;
import com.squareup.protoparser.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EnumType
implements Type {
    private final String name;
    private final String fqname;
    private final String documentation;
    private final List<Value> values;

    EnumType(String name, String fqname, String documentation, List<Value> values) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (fqname == null) {
            throw new NullPointerException("fqname");
        }
        if (documentation == null) {
            throw new NullPointerException("documentation");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.name = name;
        this.fqname = fqname;
        this.documentation = documentation;
        this.values = Collections.unmodifiableList(new ArrayList<Value>(values));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fqname;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<Value> getValues() {
        return this.values;
    }

    @Override
    public List<Type> getNestedTypes() {
        return Collections.emptyList();
    }

    public boolean equals(Object other) {
        if (other instanceof EnumType) {
            EnumType that = (EnumType)other;
            return this.name.equals(that.name) && this.documentation.equals(that.documentation) && this.values.equals(that.values);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        for (Value value : this.values) {
            result.append("\n  ").append(value);
        }
        return result.toString();
    }

    public static final class Value {
        private final String name;
        private final int tag;
        private final String documentation;
        private final List<Option> options;

        Value(String name, int tag, String documentation, List<Option> options) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (documentation == null) {
                throw new NullPointerException("documentation");
            }
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.name = name;
            this.tag = tag;
            this.documentation = documentation;
            this.options = Collections.unmodifiableList(new ArrayList<Option>(options));
        }

        public String getName() {
            return this.name;
        }

        public int getTag() {
            return this.tag;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public List<Option> getOptions() {
            return this.options;
        }

        public boolean equals(Object other) {
            if (other instanceof Value) {
                Value that = (Value)other;
                return this.name.equals(that.name) && this.tag == that.tag && this.documentation.equals(that.documentation) && this.options.equals(that.options);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(String.format("%s = %d", this.name, this.tag));
            for (Option option : this.options) {
                sb.append("\n    option: ").append(option);
            }
            return sb.toString();
        }
    }
}

